/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.hadoop.api;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.carbondata.core.datamap.DataMapStoreManager;
import org.apache.carbondata.core.datamap.Segment;
import org.apache.carbondata.core.datamap.TableDataMap;
import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.carbondata.core.indexstore.ExtendedBlocklet;
import org.apache.carbondata.core.indexstore.PartitionSpec;
import org.apache.carbondata.core.metadata.AbsoluteTableIdentifier;
import org.apache.carbondata.core.metadata.schema.PartitionInfo;
import org.apache.carbondata.core.metadata.schema.SchemaReader;
import org.apache.carbondata.core.metadata.schema.partition.PartitionType;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.metadata.schema.table.TableInfo;
import org.apache.carbondata.core.mutate.CarbonUpdateUtil;
import org.apache.carbondata.core.mutate.SegmentUpdateDetails;
import org.apache.carbondata.core.mutate.UpdateVO;
import org.apache.carbondata.core.mutate.data.BlockMappingVO;
import org.apache.carbondata.core.profiler.ExplainCollector;
import org.apache.carbondata.core.readcommitter.LatestFilesReadCommittedScope;
import org.apache.carbondata.core.readcommitter.ReadCommittedScope;
import org.apache.carbondata.core.readcommitter.TableStatusReadCommittedScope;
import org.apache.carbondata.core.scan.expression.Expression;
import org.apache.carbondata.core.scan.filter.FilterExpressionProcessor;
import org.apache.carbondata.core.scan.filter.resolver.FilterResolverIntf;
import org.apache.carbondata.core.statusmanager.FileFormat;
import org.apache.carbondata.core.statusmanager.LoadMetadataDetails;
import org.apache.carbondata.core.statusmanager.SegmentStatus;
import org.apache.carbondata.core.statusmanager.SegmentStatusManager;
import org.apache.carbondata.core.statusmanager.SegmentUpdateStatusManager;
import org.apache.carbondata.core.stream.StreamFile;
import org.apache.carbondata.core.stream.StreamPruner;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.core.util.path.CarbonTablePath;
import org.apache.carbondata.hadoop.CarbonInputSplit;
import org.apache.carbondata.hadoop.api.CarbonInputFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;

public class CarbonTableInputFormat<T>
extends CarbonInputFormat<T> {
    public static final String INPUT_SEGMENT_NUMBERS = "mapreduce.input.carboninputformat.segmentnumbers";
    public static final String INPUT_FILES = "mapreduce.input.carboninputformat.files";
    private static final String ALTER_PARTITION_ID = "mapreduce.input.carboninputformat.partitionid";
    private static final Log LOG = LogFactory.getLog(CarbonTableInputFormat.class);
    private static final String CARBON_READ_SUPPORT = "mapreduce.input.carboninputformat.readsupport";
    private static final String CARBON_CONVERTER = "mapreduce.input.carboninputformat.converter";
    private static final String CARBON_TRANSACTIONAL_TABLE = "mapreduce.input.carboninputformat.transactional";
    public static final String DATABASE_NAME = "mapreduce.input.carboninputformat.databaseName";
    public static final String TABLE_NAME = "mapreduce.input.carboninputformat.tableName";
    private CarbonTable carbonTable;
    private ReadCommittedScope readCommittedScope;

    @Override
    public CarbonTable getOrCreateCarbonTable(Configuration configuration) throws IOException {
        if (this.carbonTable == null) {
            TableInfo tableInfo = CarbonTableInputFormat.getTableInfo(configuration);
            CarbonTable carbonTable = tableInfo != null ? CarbonTable.buildFromTableInfo((TableInfo)tableInfo) : SchemaReader.readCarbonTableFromStore((AbsoluteTableIdentifier)this.getAbsoluteTableIdentifier(configuration));
            this.carbonTable = carbonTable;
            return carbonTable;
        }
        return this.carbonTable;
    }

    @Override
    public List<InputSplit> getSplits(JobContext job) throws IOException {
        List<InputSplit> splitsOfStreaming;
        List<Segment> filteredSegmentToAccess;
        AbsoluteTableIdentifier identifier = this.getAbsoluteTableIdentifier(job.getConfiguration());
        CarbonTable carbonTable = this.getOrCreateCarbonTable(job.getConfiguration());
        if (null == carbonTable) {
            throw new IOException("Missing/Corrupt schema file for table.");
        }
        this.readCommittedScope = this.getReadCommitted(job, identifier);
        LoadMetadataDetails[] loadMetadataDetails = this.readCommittedScope.getSegmentList();
        SegmentUpdateStatusManager updateStatusManager = new SegmentUpdateStatusManager(carbonTable, loadMetadataDetails);
        ArrayList<Segment> invalidSegments = new ArrayList<Segment>();
        ArrayList<UpdateVO> invalidTimestampsList = new ArrayList<UpdateVO>();
        List streamSegments = null;
        SegmentStatusManager segmentStatusManager = new SegmentStatusManager(identifier, this.readCommittedScope.getConfiguration());
        SegmentStatusManager.ValidAndInvalidSegmentsInfo segments = segmentStatusManager.getValidAndInvalidSegments(loadMetadataDetails, this.readCommittedScope);
        boolean accessStreamingSegments = CarbonTableInputFormat.getAccessStreamingSegments(job.getConfiguration());
        if (CarbonTableInputFormat.getValidateSegmentsToAccess(job.getConfiguration())) {
            if (!accessStreamingSegments) {
                List validSegments = segments.getValidSegments();
                streamSegments = segments.getStreamSegments();
                streamSegments = this.getFilteredSegment(job, streamSegments, true, this.readCommittedScope);
                if (validSegments.size() == 0) {
                    return this.getSplitsOfStreaming(job, streamSegments, carbonTable);
                }
                filteredSegmentToAccess = this.getFilteredSegment(job, segments.getValidSegments(), true, this.readCommittedScope);
                if (filteredSegmentToAccess.size() == 0) {
                    return this.getSplitsOfStreaming(job, streamSegments, carbonTable);
                }
                CarbonTableInputFormat.setSegmentsToAccess(job.getConfiguration(), filteredSegmentToAccess);
            } else {
                List<Segment> filteredNormalSegments = this.getFilteredNormalSegments(job, segments.getValidSegments(), this.getSegmentsToAccess(job, this.readCommittedScope));
                streamSegments = segments.getStreamSegments();
                if (filteredNormalSegments.size() == 0) {
                    return this.getSplitsOfStreaming(job, streamSegments, carbonTable);
                }
                CarbonTableInputFormat.setSegmentsToAccess(job.getConfiguration(), filteredNormalSegments);
            }
            invalidSegments.addAll(segments.getInvalidSegments());
            invalidTimestampsList.addAll(updateStatusManager.getInvalidTimestampRange());
            if (invalidSegments.size() > 0) {
                DataMapStoreManager.getInstance().clearInvalidSegments(this.getOrCreateCarbonTable(job.getConfiguration()), invalidSegments);
            }
        }
        ArrayList validAndInProgressSegments = new ArrayList(segments.getValidSegments());
        validAndInProgressSegments.addAll(segments.getListOfInProgressSegments());
        filteredSegmentToAccess = this.getFilteredSegment(job, new ArrayList<Segment>(validAndInProgressSegments), false, this.readCommittedScope);
        this.refreshSegmentCacheIfRequired(job, carbonTable, updateStatusManager, filteredSegmentToAccess);
        Expression filter = this.getFilterPredicates(job.getConfiguration());
        PartitionInfo partitionInfo = carbonTable.getPartitionInfo(carbonTable.getTableName());
        BitSet matchedPartitions = null;
        if (partitionInfo != null && partitionInfo.getPartitionType() != PartitionType.NATIVE_HIVE) {
            carbonTable.processFilterExpression(filter, null, null);
            matchedPartitions = this.setMatchedPartitions(null, filter, partitionInfo, null);
            if (matchedPartitions != null) {
                if (matchedPartitions.cardinality() == 0) {
                    return new ArrayList<InputSplit>();
                }
                if (matchedPartitions.cardinality() == partitionInfo.getNumPartitions()) {
                    matchedPartitions = null;
                }
            }
        }
        List<InputSplit> splits = this.getSplits(job, filter, filteredSegmentToAccess, matchedPartitions, partitionInfo, null, updateStatusManager);
        if (invalidSegments.size() > 0) {
            for (InputSplit split : splits) {
                ((CarbonInputSplit)split).setInvalidSegments(invalidSegments);
                ((CarbonInputSplit)split).setInvalidTimestampRange(invalidTimestampsList);
            }
        }
        if (!(splitsOfStreaming = this.getSplitsOfStreaming(job, streamSegments, carbonTable)).isEmpty()) {
            splits.addAll(splitsOfStreaming);
        }
        return splits;
    }

    public void refreshSegmentCacheIfRequired(JobContext job, CarbonTable carbonTable, SegmentUpdateStatusManager updateStatusManager, List<Segment> filteredSegmentToAccess) throws IOException {
        ArrayList<Segment> toBeCleanedSegments = new ArrayList<Segment>();
        for (Segment filteredSegment : filteredSegmentToAccess) {
            boolean refreshNeeded = DataMapStoreManager.getInstance().getTableSegmentRefresher(carbonTable).isRefreshNeeded(filteredSegment, updateStatusManager.getInvalidTimestampRange(filteredSegment.getSegmentNo()));
            if (!refreshNeeded) continue;
            toBeCleanedSegments.add(filteredSegment);
        }
        for (Segment segment : filteredSegmentToAccess) {
            if (!DataMapStoreManager.getInstance().getTableSegmentRefresher(carbonTable).isRefreshNeeded(segment.getSegmentNo())) continue;
            toBeCleanedSegments.add(segment);
        }
        if (toBeCleanedSegments.size() > 0) {
            DataMapStoreManager.getInstance().clearInvalidSegments(this.getOrCreateCarbonTable(job.getConfiguration()), toBeCleanedSegments);
        }
    }

    private List<Segment> getFilteredNormalSegments(JobContext job, List<Segment> validSegments, Segment[] segmentsToAccess) {
        List<Segment> segmentToAccessSet = Arrays.asList(segmentsToAccess);
        ArrayList<Segment> filteredSegment = new ArrayList<Segment>();
        for (Segment seg : validSegments) {
            if (segmentToAccessSet.contains(seg)) continue;
            filteredSegment.add(seg);
        }
        return filteredSegment;
    }

    private List<Segment> getFilteredSegment(JobContext job, List<Segment> validSegments, boolean validationRequired, ReadCommittedScope readCommittedScope) {
        Segment[] segmentsToAccess = this.getSegmentsToAccess(job, readCommittedScope);
        ArrayList<Segment> segmentToAccessSet = new ArrayList<Segment>(new HashSet<Segment>(Arrays.asList(segmentsToAccess)));
        ArrayList<Segment> filteredSegmentToAccess = new ArrayList<Segment>();
        if (segmentsToAccess.length == 0 || segmentsToAccess[0].getSegmentNo().equalsIgnoreCase("*")) {
            filteredSegmentToAccess.addAll(validSegments);
        } else {
            for (Segment validSegment : validSegments) {
                int index = segmentToAccessSet.indexOf(validSegment);
                if (index <= -1) continue;
                if (((Segment)segmentToAccessSet.get(index)).getSegmentFileName() != null && validSegment.getSegmentFileName() == null) {
                    filteredSegmentToAccess.add((Segment)segmentToAccessSet.get(index));
                    continue;
                }
                filteredSegmentToAccess.add(validSegment);
            }
            if (filteredSegmentToAccess.size() != segmentToAccessSet.size() && !validationRequired) {
                for (Segment segment : segmentToAccessSet) {
                    if (filteredSegmentToAccess.contains(segment)) continue;
                    filteredSegmentToAccess.add(segment);
                }
            }
            if (!filteredSegmentToAccess.containsAll(segmentToAccessSet)) {
                ArrayList<Segment> filteredSegmentToAccessTemp = new ArrayList<Segment>(filteredSegmentToAccess);
                filteredSegmentToAccessTemp.removeAll(segmentToAccessSet);
                LOG.info((Object)("Segments ignored are : " + Arrays.toString(filteredSegmentToAccessTemp.toArray())));
            }
        }
        return filteredSegmentToAccess;
    }

    public List<InputSplit> getSplitsOfStreaming(JobContext job, List<Segment> streamSegments, CarbonTable carbonTable) throws IOException {
        return this.getSplitsOfStreaming(job, streamSegments, carbonTable, null);
    }

    public List<InputSplit> getSplitsOfStreaming(JobContext job, List<Segment> streamSegments, CarbonTable carbonTable, FilterResolverIntf filterResolverIntf) throws IOException {
        ArrayList<InputSplit> splits = new ArrayList<InputSplit>();
        if (streamSegments != null && !streamSegments.isEmpty()) {
            Expression filter;
            this.numStreamSegments = streamSegments.size();
            long minSize = Math.max(this.getFormatMinSplitSize(), CarbonTableInputFormat.getMinSplitSize((JobContext)job));
            long maxSize = CarbonTableInputFormat.getMaxSplitSize((JobContext)job);
            if (filterResolverIntf == null && carbonTable != null && (filter = this.getFilterPredicates(job.getConfiguration())) != null) {
                carbonTable.processFilterExpression(filter, null, null);
                filterResolverIntf = CarbonTable.resolveFilter((Expression)filter, (AbsoluteTableIdentifier)carbonTable.getAbsoluteTableIdentifier());
            }
            StreamPruner streamPruner = new StreamPruner(carbonTable);
            streamPruner.init(filterResolverIntf);
            List streamFiles = streamPruner.prune(streamSegments);
            this.hitedStreamFiles = streamFiles.size();
            this.numStreamFiles = streamPruner.getTotalFileNums();
            for (StreamFile streamFile : streamFiles) {
                int blkIndex;
                Path path = new Path(streamFile.getFilePath());
                long length = streamFile.getFileSize();
                if (length == 0L) continue;
                FileSystem fs = FileFactory.getFileSystem((Path)path);
                FileStatus file = fs.getFileStatus(path);
                BlockLocation[] blkLocations = fs.getFileBlockLocations(path, 0L, length);
                long blockSize = file.getBlockSize();
                long splitSize = this.computeSplitSize(blockSize, minSize, maxSize);
                long bytesRemaining = length;
                while ((double)bytesRemaining / (double)splitSize > 1.1) {
                    blkIndex = this.getBlockIndex(blkLocations, length - bytesRemaining);
                    splits.add((InputSplit)this.makeSplit(streamFile.getSegmentNo(), path, length - bytesRemaining, splitSize, blkLocations[blkIndex].getHosts(), blkLocations[blkIndex].getCachedHosts(), FileFormat.ROW_V1));
                    bytesRemaining -= splitSize;
                }
                if (bytesRemaining == 0L) continue;
                blkIndex = this.getBlockIndex(blkLocations, length - bytesRemaining);
                splits.add((InputSplit)this.makeSplit(streamFile.getSegmentNo(), path, length - bytesRemaining, bytesRemaining, blkLocations[blkIndex].getHosts(), blkLocations[blkIndex].getCachedHosts(), FileFormat.ROW_V1));
            }
        }
        return splits;
    }

    protected FileSplit makeSplit(String segmentId, Path file, long start, long length, String[] hosts, FileFormat fileFormat) {
        return new CarbonInputSplit(segmentId, file, start, length, hosts, fileFormat);
    }

    protected FileSplit makeSplit(String segmentId, Path file, long start, long length, String[] hosts, String[] inMemoryHosts, FileFormat fileFormat) {
        return new CarbonInputSplit(segmentId, file, start, length, hosts, inMemoryHosts, fileFormat);
    }

    public List<InputSplit> getSplitsOfOneSegment(JobContext job, String targetSegment, List<Integer> oldPartitionIdList, PartitionInfo partitionInfo) {
        ArrayList<Segment> invalidSegments = new ArrayList<Segment>();
        ArrayList<UpdateVO> invalidTimestampsList = new ArrayList<UpdateVO>();
        try {
            ReadCommittedScope readCommittedScope;
            this.carbonTable = this.getOrCreateCarbonTable(job.getConfiguration());
            this.readCommittedScope = readCommittedScope = this.getReadCommitted(job, this.carbonTable.getAbsoluteTableIdentifier());
            ArrayList<Segment> segmentList = new ArrayList<Segment>();
            Segment segment = Segment.getSegment((String)targetSegment, (String)this.carbonTable.getTablePath());
            segmentList.add(new Segment(segment.getSegmentNo(), segment.getSegmentFileName(), readCommittedScope));
            CarbonTableInputFormat.setSegmentsToAccess(job.getConfiguration(), segmentList);
            Expression filter = this.getFilterPredicates(job.getConfiguration());
            CarbonTable carbonTable = this.getOrCreateCarbonTable(job.getConfiguration());
            if (null == carbonTable) {
                throw new IOException("Missing/Corrupt schema file for table.");
            }
            carbonTable.processFilterExpression(filter, null, null);
            String partitionIds = job.getConfiguration().get(ALTER_PARTITION_ID);
            BitSet matchedPartitions = null;
            if (partitionInfo != null && (matchedPartitions = this.setMatchedPartitions(partitionIds, filter, partitionInfo, oldPartitionIdList)) != null) {
                if (matchedPartitions.cardinality() == 0) {
                    return new ArrayList<InputSplit>();
                }
                if (matchedPartitions.cardinality() == partitionInfo.getNumPartitions()) {
                    matchedPartitions = null;
                }
            }
            List<InputSplit> splits = this.getSplits(job, filter, segmentList, matchedPartitions, partitionInfo, oldPartitionIdList, new SegmentUpdateStatusManager(carbonTable));
            if (invalidSegments.size() > 0) {
                for (InputSplit split : splits) {
                    ((CarbonInputSplit)split).setInvalidSegments(invalidSegments);
                    ((CarbonInputSplit)split).setInvalidTimestampRange(invalidTimestampsList);
                }
            }
            return splits;
        }
        catch (IOException e) {
            throw new RuntimeException("Can't get splits of the target segment ", e);
        }
    }

    private BitSet setMatchedPartitions(String partitionIds, Expression filter, PartitionInfo partitionInfo, List<Integer> oldPartitionIdList) {
        BitSet matchedPartitions = null;
        if (null != partitionIds) {
            String[] partList = partitionIds.replace("[", "").replace("]", "").split(",");
            matchedPartitions = new BitSet(Integer.parseInt(partList[0].trim()));
            for (String partitionId : partList) {
                Integer index = oldPartitionIdList.indexOf(Integer.parseInt(partitionId.trim()));
                matchedPartitions.set(index);
            }
        } else if (null != filter) {
            matchedPartitions = new FilterExpressionProcessor().getFilteredPartitions(filter, partitionInfo);
        }
        return matchedPartitions;
    }

    private List<InputSplit> getSplits(JobContext job, Expression expression, List<Segment> validSegments, BitSet matchedPartitions, PartitionInfo partitionInfo, List<Integer> oldPartitionIdList, SegmentUpdateStatusManager updateStatusManager) throws IOException {
        this.numSegments = validSegments.size();
        LinkedList<InputSplit> result = new LinkedList<InputSplit>();
        UpdateVO invalidBlockVOForSegmentId = null;
        Boolean isIUDTable = false;
        isIUDTable = updateStatusManager.getUpdateStatusDetails().length != 0;
        List<CarbonInputSplit> dataBlocksOfSegment = this.getDataBlocksOfSegment(job, this.carbonTable, expression, matchedPartitions, validSegments, partitionInfo, oldPartitionIdList);
        this.numBlocks = dataBlocksOfSegment.size();
        for (CarbonInputSplit inputSplit : dataBlocksOfSegment) {
            if (isIUDTable.booleanValue()) {
                invalidBlockVOForSegmentId = updateStatusManager.getInvalidTimestampRange(inputSplit.getSegmentId());
            }
            String[] deleteDeltaFilePath = null;
            if (isIUDTable.booleanValue()) {
                if (CarbonUtil.isInvalidTableBlock((String)inputSplit.getSegmentId(), (String)inputSplit.getPath().toString(), (UpdateVO)invalidBlockVOForSegmentId, (SegmentUpdateStatusManager)updateStatusManager)) continue;
                try {
                    deleteDeltaFilePath = updateStatusManager.getDeleteDeltaFilePath(inputSplit.getPath().toString(), inputSplit.getSegmentId());
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }
            inputSplit.setDeleteDeltaFiles(deleteDeltaFilePath);
            result.add((InputSplit)inputSplit);
        }
        return result;
    }

    public Segment[] getSegmentsToAccess(JobContext job, ReadCommittedScope readCommittedScope) {
        String segmentString = job.getConfiguration().get(INPUT_SEGMENT_NUMBERS, "");
        if (segmentString.trim().isEmpty()) {
            return new Segment[0];
        }
        List segments = Segment.toSegmentList((String[])segmentString.split(","), (ReadCommittedScope)readCommittedScope);
        return segments.toArray(new Segment[segments.size()]);
    }

    public BlockMappingVO getBlockRowCount(Job job, CarbonTable table, List<PartitionSpec> partitions) throws IOException {
        ExplainCollector.remove();
        AbsoluteTableIdentifier identifier = table.getAbsoluteTableIdentifier();
        TableDataMap blockletMap = DataMapStoreManager.getInstance().getDefaultDataMap(table);
        ReadCommittedScope readCommittedScope = this.getReadCommitted((JobContext)job, identifier);
        LoadMetadataDetails[] loadMetadataDetails = readCommittedScope.getSegmentList();
        SegmentUpdateStatusManager updateStatusManager = new SegmentUpdateStatusManager(table, loadMetadataDetails);
        SegmentStatusManager.ValidAndInvalidSegmentsInfo allSegments = new SegmentStatusManager(identifier, readCommittedScope.getConfiguration()).getValidAndInvalidSegments(loadMetadataDetails, readCommittedScope);
        HashMap<String, Long> blockRowCountMapping = new HashMap<String, Long>();
        HashMap<String, Long> segmentAndBlockCountMapping = new HashMap<String, Long>();
        List<Segment> filteredSegment = this.getFilteredSegment((JobContext)job, allSegments.getValidSegments(), false, readCommittedScope);
        ArrayList<Segment> toBeCleanedSegments = new ArrayList<Segment>();
        for (Segment eachSegment : filteredSegment) {
            boolean refreshNeeded = DataMapStoreManager.getInstance().getTableSegmentRefresher(this.getOrCreateCarbonTable(job.getConfiguration())).isRefreshNeeded(eachSegment, updateStatusManager.getInvalidTimestampRange(eachSegment.getSegmentNo()));
            if (!refreshNeeded) continue;
            toBeCleanedSegments.add(eachSegment);
        }
        if (toBeCleanedSegments.size() > 0) {
            DataMapStoreManager.getInstance().clearInvalidSegments(this.getOrCreateCarbonTable(job.getConfiguration()), toBeCleanedSegments);
        }
        List blocklets = blockletMap.prune(filteredSegment, (FilterResolverIntf)null, partitions);
        for (ExtendedBlocklet blocklet : blocklets) {
            String blockName = blocklet.getPath();
            blockName = CarbonTablePath.getCarbonDataFileName((String)blockName);
            blockName = blockName + CarbonTablePath.getCarbonDataExtension();
            long rowCount = blocklet.getDetailInfo().getRowCount();
            String segmentId = Segment.toSegment((String)blocklet.getSegmentId()).getSegmentNo();
            String key = CarbonUpdateUtil.getSegmentBlockNameKey((String)segmentId, (String)blockName);
            SegmentUpdateDetails details = updateStatusManager.getDetailsForABlock(key);
            if (null != details && CarbonUpdateUtil.isBlockInvalid((SegmentStatus)details.getSegmentStatus())) continue;
            Long blockCount = (Long)blockRowCountMapping.get(key);
            if (blockCount == null) {
                blockCount = 0L;
                Long count = (Long)segmentAndBlockCountMapping.get(segmentId);
                if (count == null) {
                    count = 0L;
                }
                segmentAndBlockCountMapping.put(segmentId, count + 1L);
            }
            blockCount = blockCount + rowCount;
            blockRowCountMapping.put(key, blockCount);
        }
        return new BlockMappingVO(blockRowCountMapping, segmentAndBlockCountMapping);
    }

    public ReadCommittedScope getReadCommitted(JobContext job, AbsoluteTableIdentifier identifier) throws IOException {
        if (this.readCommittedScope == null) {
            ReadCommittedScope readCommittedScope;
            if (job.getConfiguration().getBoolean(CARBON_TRANSACTIONAL_TABLE, true)) {
                readCommittedScope = new TableStatusReadCommittedScope(identifier, job.getConfiguration());
            } else {
                readCommittedScope = CarbonTableInputFormat.getReadCommittedScope(job.getConfiguration());
                if (readCommittedScope == null) {
                    readCommittedScope = new LatestFilesReadCommittedScope(identifier.getTablePath(), job.getConfiguration());
                }
            }
            this.readCommittedScope = readCommittedScope;
        }
        return this.readCommittedScope;
    }
}

