/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.hadoop;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.carbondata.common.CarbonIterator;
import org.apache.carbondata.core.cache.dictionary.Dictionary;
import org.apache.carbondata.core.datamap.DataMapStoreManager;
import org.apache.carbondata.core.datastore.FileReader;
import org.apache.carbondata.core.datastore.block.TableBlockInfo;
import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.carbondata.core.scan.executor.QueryExecutor;
import org.apache.carbondata.core.scan.executor.QueryExecutorFactory;
import org.apache.carbondata.core.scan.executor.exception.QueryExecutionException;
import org.apache.carbondata.core.scan.model.QueryModel;
import org.apache.carbondata.core.scan.result.iterator.ChunkRowIterator;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.hadoop.AbstractRecordReader;
import org.apache.carbondata.hadoop.CarbonInputSplit;
import org.apache.carbondata.hadoop.CarbonMultiBlockSplit;
import org.apache.carbondata.hadoop.InputMetricsStats;
import org.apache.carbondata.hadoop.readsupport.CarbonReadSupport;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class CarbonRecordReader<T>
extends AbstractRecordReader<T> {
    protected QueryModel queryModel;
    protected CarbonReadSupport<T> readSupport;
    protected CarbonIterator<Object[]> carbonIterator;
    protected QueryExecutor queryExecutor;
    private InputMetricsStats inputMetricsStats;
    private boolean skipClearDataMapAtClose = false;

    public CarbonRecordReader(QueryModel queryModel, CarbonReadSupport<T> readSupport, InputMetricsStats inputMetricsStats, Configuration configuration) {
        this(queryModel, readSupport, configuration);
        this.inputMetricsStats = inputMetricsStats;
    }

    public CarbonRecordReader(QueryModel queryModel, CarbonReadSupport<T> readSupport, Configuration configuration) {
        this.queryModel = queryModel;
        this.readSupport = readSupport;
        this.queryExecutor = QueryExecutorFactory.getQueryExecutor((QueryModel)queryModel, (Configuration)configuration);
    }

    public void initialize(InputSplit inputSplit, TaskAttemptContext context) throws IOException, InterruptedException {
        ArrayList<CarbonInputSplit> splitList;
        if (inputSplit instanceof CarbonInputSplit) {
            splitList = new ArrayList(1);
            String splitPath = ((CarbonInputSplit)inputSplit).getPath().toString();
            if (((CarbonInputSplit)inputSplit).getDetailInfo().getBlockFooterOffset() == 0L) {
                FileReader reader = FileFactory.getFileHolder((FileFactory.FileType)FileFactory.getFileType((String)splitPath), (Configuration)context.getConfiguration());
                ByteBuffer buffer = reader.readByteBuffer(FileFactory.getUpdatedFilePath((String)splitPath), inputSplit.getLength() - 8L, 8);
                ((CarbonInputSplit)inputSplit).getDetailInfo().setBlockFooterOffset(buffer.getLong());
            }
            splitList.add((CarbonInputSplit)inputSplit);
        } else if (inputSplit instanceof CarbonMultiBlockSplit) {
            CarbonMultiBlockSplit multiBlockSplit = (CarbonMultiBlockSplit)inputSplit;
            splitList = multiBlockSplit.getAllSplits();
        } else {
            throw new RuntimeException("unsupported input split type: " + inputSplit);
        }
        if (!this.queryModel.isFG()) {
            List<TableBlockInfo> tableBlockInfoList = CarbonInputSplit.createBlocks(splitList);
            this.queryModel.setTableBlockInfos(tableBlockInfoList);
        }
        this.readSupport.initialize(this.queryModel.getProjectionColumns(), this.queryModel.getTable());
        try {
            this.carbonIterator = new ChunkRowIterator(this.queryExecutor.execute(this.queryModel));
        }
        catch (QueryExecutionException e) {
            throw new InterruptedException(e.getMessage());
        }
    }

    public boolean nextKeyValue() {
        return this.carbonIterator.hasNext();
    }

    public Void getCurrentKey() throws IOException, InterruptedException {
        return null;
    }

    public T getCurrentValue() throws IOException, InterruptedException {
        ++this.rowCount;
        if (null != this.inputMetricsStats) {
            this.inputMetricsStats.incrementRecordRead(1L);
        }
        return this.readSupport.readRow((Object[])this.carbonIterator.next());
    }

    public List<Object[]> getBatchValue() {
        if (null != this.inputMetricsStats) {
            this.inputMetricsStats.incrementRecordRead(1L);
        }
        List objects = ((ChunkRowIterator)this.carbonIterator).nextBatch();
        this.rowCount += objects.size();
        return objects;
    }

    public float getProgress() throws IOException, InterruptedException {
        return 0.0f;
    }

    public void close() throws IOException {
        this.logStatistics(this.rowCount, this.queryModel.getStatisticsRecorder());
        Map columnToDictionaryMapping = this.queryModel.getColumnToDictionaryMapping();
        if (null != columnToDictionaryMapping) {
            for (Map.Entry entry : columnToDictionaryMapping.entrySet()) {
                CarbonUtil.clearDictionaryCache((Dictionary)((Dictionary)entry.getValue()));
            }
        }
        if (!this.skipClearDataMapAtClose) {
            DataMapStoreManager.getInstance().clearDataMaps(this.queryModel.getTable().getAbsoluteTableIdentifier());
        }
        this.readSupport.close();
        this.carbonIterator.close();
        try {
            this.queryExecutor.finish();
        }
        catch (QueryExecutionException e) {
            throw new IOException(e);
        }
    }

    public void setSkipClearDataMapAtClose(boolean skipClearDataMapAtClose) {
        this.skipClearDataMapAtClose = skipClearDataMapAtClose;
    }
}

