/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.hadoop.api;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.carbondata.common.annotations.InterfaceAudience;
import org.apache.carbondata.common.annotations.InterfaceStability;
import org.apache.carbondata.core.datamap.Segment;
import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.carbondata.core.metadata.AbsoluteTableIdentifier;
import org.apache.carbondata.core.metadata.schema.PartitionInfo;
import org.apache.carbondata.core.metadata.schema.SchemaReader;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.metadata.schema.table.TableInfo;
import org.apache.carbondata.core.readcommitter.LatestFilesReadCommittedScope;
import org.apache.carbondata.core.readcommitter.ReadCommittedScope;
import org.apache.carbondata.core.scan.expression.Expression;
import org.apache.carbondata.core.scan.filter.resolver.FilterResolverIntf;
import org.apache.carbondata.core.statusmanager.LoadMetadataDetails;
import org.apache.carbondata.core.util.path.CarbonTablePath;
import org.apache.carbondata.hadoop.CarbonInputSplit;
import org.apache.carbondata.hadoop.api.CarbonInputFormat;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;

@InterfaceAudience.User
@InterfaceStability.Evolving
public class CarbonFileInputFormat<T>
extends CarbonInputFormat<T>
implements Serializable {
    private CarbonTable carbonTable;

    @Override
    public CarbonTable getOrCreateCarbonTable(Configuration configuration) throws IOException {
        if (this.carbonTable == null) {
            CarbonTable localCarbonTable;
            TableInfo tableInfo = CarbonFileInputFormat.getTableInfo(configuration);
            if (tableInfo != null) {
                localCarbonTable = CarbonTable.buildFromTableInfo((TableInfo)tableInfo);
            } else {
                String schemaPath = CarbonTablePath.getSchemaFilePath((String)this.getAbsoluteTableIdentifier(configuration).getTablePath());
                if (!FileFactory.isFileExist((String)schemaPath, (FileFactory.FileType)FileFactory.getFileType((String)schemaPath))) {
                    TableInfo tableInfoInfer = SchemaReader.inferSchema((AbsoluteTableIdentifier)this.getAbsoluteTableIdentifier(configuration), (boolean)true);
                    localCarbonTable = CarbonTable.buildFromTableInfo((TableInfo)tableInfoInfer);
                } else {
                    localCarbonTable = SchemaReader.readCarbonTableFromStore((AbsoluteTableIdentifier)this.getAbsoluteTableIdentifier(configuration));
                }
            }
            this.carbonTable = localCarbonTable;
            return localCarbonTable;
        }
        CarbonTable carbonTableTemp = this.carbonTable;
        return carbonTableTemp;
    }

    @Override
    public List<InputSplit> getSplits(JobContext job) throws IOException {
        CarbonTable carbonTable = this.getOrCreateCarbonTable(job.getConfiguration());
        if (null == carbonTable) {
            throw new IOException("Missing/Corrupt schema file for table.");
        }
        AbsoluteTableIdentifier identifier = carbonTable.getAbsoluteTableIdentifier();
        if (CarbonFileInputFormat.getValidateSegmentsToAccess(job.getConfiguration())) {
            LatestFilesReadCommittedScope readCommittedScope = null;
            readCommittedScope = carbonTable.isTransactionalTable() ? new LatestFilesReadCommittedScope(identifier.getTablePath() + "/Fact/Part0/Segment_null/") : new LatestFilesReadCommittedScope(identifier.getTablePath());
            Expression filter = this.getFilterPredicates(job.getConfiguration());
            PartitionInfo partitionInfo = carbonTable.getPartitionInfo(carbonTable.getTableName());
            carbonTable.processFilterExpression(filter, null, null);
            FilterResolverIntf filterInterface = carbonTable.resolveFilter(filter);
            ArrayList<Segment> externalTableSegments = new ArrayList<Segment>();
            if (carbonTable.isTransactionalTable()) {
                Segment seg = new Segment("null", null, (ReadCommittedScope)readCommittedScope);
                externalTableSegments.add(seg);
            } else {
                LoadMetadataDetails[] loadMetadataDetails;
                for (LoadMetadataDetails load : loadMetadataDetails = readCommittedScope.getSegmentList()) {
                    Segment seg = new Segment(load.getLoadName(), null, (ReadCommittedScope)readCommittedScope);
                    externalTableSegments.add(seg);
                }
            }
            List<InputSplit> splits = this.getSplits(job, filterInterface, externalTableSegments, null, partitionInfo, null);
            if (CarbonFileInputFormat.getColumnProjection(job.getConfiguration()) == null) {
                String[] projectionColumns = this.projectAllColumns(carbonTable);
                CarbonFileInputFormat.setColumnProjection(job.getConfiguration(), projectionColumns);
            }
            return splits;
        }
        return null;
    }

    private List<InputSplit> getSplits(JobContext job, FilterResolverIntf filterResolver, List<Segment> validSegments, BitSet matchedPartitions, PartitionInfo partitionInfo, List<Integer> oldPartitionIdList) throws IOException {
        this.numSegments = validSegments.size();
        LinkedList<InputSplit> result = new LinkedList<InputSplit>();
        List<CarbonInputSplit> dataBlocksOfSegment = this.getDataBlocksOfSegment(job, this.carbonTable, filterResolver, matchedPartitions, validSegments, partitionInfo, oldPartitionIdList);
        this.numBlocks = dataBlocksOfSegment.size();
        result.addAll(dataBlocksOfSegment);
        return result;
    }
}

