/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.hadoop.internal;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.apache.hadoop.io.Writable;

public class ObjectArrayWritable
implements Writable {
    private Object[] values;

    public void set(Object[] values) {
        this.values = values;
    }

    public Object[] get() {
        return this.values;
    }

    public void readFields(DataInput in) throws IOException {
        int length = in.readInt();
        this.values = new Object[length];
        for (int i = 0; i < length; ++i) {
            byte[] b = new byte[in.readInt()];
            in.readFully(b);
            this.values[i] = new String(b, Charset.defaultCharset());
        }
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.values.length);
        for (int i = 0; i < this.values.length; ++i) {
            byte[] b = this.values[i].toString().getBytes(Charset.defaultCharset());
            out.writeInt(b.length);
            out.write(b);
        }
    }

    public String toString() {
        return Arrays.toString(this.values);
    }
}

