/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.hadoop.util;

import java.io.IOException;
import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.carbondata.core.metadata.AbsoluteTableIdentifier;
import org.apache.carbondata.core.metadata.CarbonMetadata;
import org.apache.carbondata.core.metadata.CarbonTableIdentifier;
import org.apache.carbondata.core.metadata.converter.ThriftWrapperSchemaConverterImpl;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.core.util.path.CarbonStorePath;
import org.apache.carbondata.core.util.path.CarbonTablePath;
import org.apache.carbondata.format.TableInfo;

public class SchemaReader {
    public static CarbonTable readCarbonTableFromStore(AbsoluteTableIdentifier identifier) throws IOException {
        CarbonTablePath carbonTablePath = CarbonStorePath.getCarbonTablePath((AbsoluteTableIdentifier)identifier);
        String schemaFilePath = carbonTablePath.getSchemaFilePath();
        if (FileFactory.isFileExist((String)schemaFilePath, (FileFactory.FileType)FileFactory.FileType.LOCAL) || FileFactory.isFileExist((String)schemaFilePath, (FileFactory.FileType)FileFactory.FileType.HDFS) || FileFactory.isFileExist((String)schemaFilePath, (FileFactory.FileType)FileFactory.FileType.S3) || FileFactory.isFileExist((String)schemaFilePath, (FileFactory.FileType)FileFactory.FileType.VIEWFS)) {
            String tableName = identifier.getCarbonTableIdentifier().getTableName();
            TableInfo tableInfo = CarbonUtil.readSchemaFile((String)carbonTablePath.getSchemaFilePath());
            ThriftWrapperSchemaConverterImpl schemaConverter = new ThriftWrapperSchemaConverterImpl();
            org.apache.carbondata.core.metadata.schema.table.TableInfo wrapperTableInfo = schemaConverter.fromExternalToWrapperTableInfo(tableInfo, identifier.getCarbonTableIdentifier().getDatabaseName(), tableName, identifier.getTablePath());
            CarbonMetadata.getInstance().loadTableMetadata(wrapperTableInfo);
            return CarbonMetadata.getInstance().getCarbonTable(identifier.getCarbonTableIdentifier().getTableUniqueName());
        }
        throw new IOException("File does not exist: " + schemaFilePath);
    }

    public static org.apache.carbondata.core.metadata.schema.table.TableInfo getTableInfo(AbsoluteTableIdentifier absoluteTableIdentifier) throws IOException {
        CarbonTablePath carbonTablePath = CarbonStorePath.getCarbonTablePath((AbsoluteTableIdentifier)absoluteTableIdentifier);
        TableInfo thriftTableInfo = CarbonUtil.readSchemaFile((String)carbonTablePath.getSchemaFilePath());
        ThriftWrapperSchemaConverterImpl thriftWrapperSchemaConverter = new ThriftWrapperSchemaConverterImpl();
        CarbonTableIdentifier carbonTableIdentifier = absoluteTableIdentifier.getCarbonTableIdentifier();
        return thriftWrapperSchemaConverter.fromExternalToWrapperTableInfo(thriftTableInfo, carbonTableIdentifier.getDatabaseName(), carbonTableIdentifier.getTableName(), absoluteTableIdentifier.getTablePath());
    }
}

