/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.hadoop.util;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.carbondata.core.metadata.AbsoluteTableIdentifier;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonDimension;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonMeasure;
import org.apache.carbondata.core.scan.expression.Expression;
import org.apache.carbondata.core.scan.filter.FilterExpressionProcessor;
import org.apache.carbondata.core.scan.filter.TableProvider;
import org.apache.carbondata.core.scan.filter.intf.FilterOptimizer;
import org.apache.carbondata.core.scan.filter.intf.FilterOptimizerBasic;
import org.apache.carbondata.core.scan.filter.optimizer.RangeFilterOptmizer;
import org.apache.carbondata.core.scan.filter.resolver.FilterResolverIntf;
import org.apache.carbondata.core.scan.model.CarbonQueryPlan;
import org.apache.carbondata.core.scan.model.QueryDimension;
import org.apache.carbondata.core.scan.model.QueryMeasure;
import org.apache.carbondata.core.scan.model.QueryModel;
import org.apache.carbondata.hadoop.api.CarbonTableInputFormat;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;

public class CarbonInputFormatUtil {
    public static CarbonQueryPlan createQueryPlan(CarbonTable carbonTable, String columnString) {
        String[] columns = null;
        if (columnString != null) {
            columns = columnString.split(",");
        }
        String factTableName = carbonTable.getTableName();
        CarbonQueryPlan plan = new CarbonQueryPlan(carbonTable.getDatabaseName(), factTableName);
        int i = 0;
        if (columns != null) {
            for (String column : columns) {
                CarbonDimension dimensionByName = carbonTable.getDimensionByName(factTableName, column);
                if (dimensionByName != null) {
                    CarbonInputFormatUtil.addQueryDimension(plan, i, dimensionByName);
                    ++i;
                    continue;
                }
                CarbonMeasure measure = carbonTable.getMeasureByName(factTableName, column);
                if (measure == null) {
                    throw new RuntimeException(column + " column not found in the table " + factTableName);
                }
                CarbonInputFormatUtil.addQueryMeasure(plan, i, measure);
                ++i;
            }
        }
        plan.setQueryId(System.nanoTime() + "");
        return plan;
    }

    public static <V> CarbonTableInputFormat<V> createCarbonInputFormat(AbsoluteTableIdentifier identifier, Job job) throws IOException {
        CarbonTableInputFormat carbonInputFormat = new CarbonTableInputFormat();
        CarbonTableInputFormat.setDatabaseName(job.getConfiguration(), identifier.getCarbonTableIdentifier().getDatabaseName());
        CarbonTableInputFormat.setTableName(job.getConfiguration(), identifier.getCarbonTableIdentifier().getTableName());
        FileInputFormat.addInputPath((Job)job, (Path)new Path(identifier.getTablePath()));
        return carbonInputFormat;
    }

    public static <V> CarbonTableInputFormat<V> createCarbonTableInputFormat(AbsoluteTableIdentifier identifier, List<String> partitionId, Job job) throws IOException {
        CarbonTableInputFormat carbonTableInputFormat = new CarbonTableInputFormat();
        CarbonTableInputFormat.setPartitionIdList(job.getConfiguration(), partitionId);
        CarbonTableInputFormat.setDatabaseName(job.getConfiguration(), identifier.getCarbonTableIdentifier().getDatabaseName());
        CarbonTableInputFormat.setTableName(job.getConfiguration(), identifier.getCarbonTableIdentifier().getTableName());
        FileInputFormat.addInputPath((Job)job, (Path)new Path(identifier.getTablePath()));
        return carbonTableInputFormat;
    }

    private static void addQueryMeasure(CarbonQueryPlan plan, int order, CarbonMeasure measure) {
        QueryMeasure queryMeasure = new QueryMeasure(measure.getColName());
        queryMeasure.setQueryOrder(order);
        queryMeasure.setMeasure(measure);
        plan.addMeasure(queryMeasure);
    }

    private static void addQueryDimension(CarbonQueryPlan plan, int order, CarbonDimension dimension) {
        QueryDimension queryDimension = new QueryDimension(dimension.getColName());
        queryDimension.setQueryOrder(order);
        queryDimension.setDimension(dimension);
        plan.addDimension(queryDimension);
    }

    public static void processFilterExpression(Expression filterExpression, CarbonTable carbonTable, boolean[] isFilterDimensions, boolean[] isFilterMeasures) {
        QueryModel.processFilterExpression((CarbonTable)carbonTable, (Expression)filterExpression, (boolean[])isFilterDimensions, (boolean[])isFilterMeasures);
        if (null != filterExpression) {
            RangeFilterOptmizer rangeFilterOptimizer = new RangeFilterOptmizer((FilterOptimizer)new FilterOptimizerBasic(), filterExpression);
            rangeFilterOptimizer.optimizeFilter();
        }
    }

    public static FilterResolverIntf resolveFilter(Expression filterExpression, AbsoluteTableIdentifier absoluteTableIdentifier, TableProvider tableProvider) {
        try {
            FilterExpressionProcessor filterExpressionProcessor = new FilterExpressionProcessor();
            return filterExpressionProcessor.getFilterResolver(filterExpression, absoluteTableIdentifier, tableProvider);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while resolving filter expression", e);
        }
    }

    public static String createJobTrackerID(Date date) {
        return new SimpleDateFormat("yyyyMMddHHmmss", Locale.US).format(date);
    }

    public static JobID getJobId(Date date, int batch) {
        String jobtrackerID = CarbonInputFormatUtil.createJobTrackerID(date);
        return new JobID(jobtrackerID, batch);
    }
}

