/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.hadoop.streaming;

import java.io.IOException;
import java.util.List;
import org.apache.carbondata.core.cache.Cache;
import org.apache.carbondata.core.cache.dictionary.Dictionary;
import org.apache.carbondata.core.cache.dictionary.DictionaryColumnUniqueIdentifier;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.metadata.encoder.Encoding;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonColumn;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonDimension;
import org.apache.carbondata.core.scan.complextypes.ArrayQueryType;
import org.apache.carbondata.core.scan.complextypes.PrimitiveQueryType;
import org.apache.carbondata.core.scan.complextypes.StructQueryType;
import org.apache.carbondata.core.scan.filter.GenericQueryType;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.hadoop.streaming.CarbonStreamRecordReader;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;

public class CarbonStreamInputFormat
extends FileInputFormat<Void, Object> {
    public static final String READ_BUFFER_SIZE = "carbon.stream.read.buffer.size";
    public static final String READ_BUFFER_SIZE_DEFAULT = "65536";

    public RecordReader<Void, Object> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        return new CarbonStreamRecordReader();
    }

    public static GenericQueryType[] getComplexDimensions(CarbonTable carbontable, CarbonColumn[] carbonColumns, Cache<DictionaryColumnUniqueIdentifier, Dictionary> cache) throws IOException {
        GenericQueryType[] queryTypes = new GenericQueryType[carbonColumns.length];
        for (int i = 0; i < carbonColumns.length; ++i) {
            if (!carbonColumns[i].isComplex().booleanValue()) continue;
            if (DataTypes.isArrayType((DataType)carbonColumns[i].getDataType())) {
                queryTypes[i] = new ArrayQueryType(carbonColumns[i].getColName(), carbonColumns[i].getColName(), i);
            } else if (DataTypes.isStructType((DataType)carbonColumns[i].getDataType())) {
                queryTypes[i] = new StructQueryType(carbonColumns[i].getColName(), carbonColumns[i].getColName(), i);
            } else {
                throw new UnsupportedOperationException(carbonColumns[i].getDataType().getName() + " is not supported");
            }
            CarbonStreamInputFormat.fillChildren(carbontable, queryTypes[i], (CarbonDimension)carbonColumns[i], i, cache);
        }
        return queryTypes;
    }

    private static void fillChildren(CarbonTable carbontable, GenericQueryType parentQueryType, CarbonDimension dimension, int parentBlockIndex, Cache<DictionaryColumnUniqueIdentifier, Dictionary> cache) throws IOException {
        for (int i = 0; i < dimension.getNumberOfChild(); ++i) {
            CarbonDimension child = (CarbonDimension)dimension.getListOfChildDimensions().get(i);
            DataType dataType = child.getDataType();
            ArrayQueryType queryType = null;
            if (DataTypes.isArrayType((DataType)dataType)) {
                queryType = new ArrayQueryType(child.getColName(), dimension.getColName(), ++parentBlockIndex);
            } else if (DataTypes.isStructType((DataType)dataType)) {
                queryType = new StructQueryType(child.getColName(), dimension.getColName(), ++parentBlockIndex);
                parentQueryType.addChildren((GenericQueryType)queryType);
            } else {
                boolean isDirectDictionary = CarbonUtil.hasEncoding((List)child.getEncoder(), (Encoding)Encoding.DIRECT_DICTIONARY);
                String dictionaryPath = (String)carbontable.getTableInfo().getFactTable().getTableProperties().get("dictionary_path");
                DictionaryColumnUniqueIdentifier dictionarIdentifier = new DictionaryColumnUniqueIdentifier(carbontable.getAbsoluteTableIdentifier(), child.getColumnIdentifier(), child.getDataType(), dictionaryPath);
                queryType = new PrimitiveQueryType(child.getColName(), dimension.getColName(), ++parentBlockIndex, child.getDataType(), 4, (Dictionary)cache.get((Object)dictionarIdentifier), isDirectDictionary);
            }
            parentQueryType.addChildren((GenericQueryType)queryType);
            if (child.getNumberOfChild() <= 0) continue;
            CarbonStreamInputFormat.fillChildren(carbontable, (GenericQueryType)queryType, child, parentBlockIndex, cache);
        }
    }
}

