/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.hadoop.util;

import org.apache.carbondata.core.keygenerator.directdictionary.DirectDictionaryGenerator;
import org.apache.carbondata.core.keygenerator.directdictionary.DirectDictionaryKeyGeneratorFactory;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.encoder.Encoding;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonColumn;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonMeasure;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.StructField;

public class CarbonTypeUtil {
    public static org.apache.spark.sql.types.DataType convertCarbonToSparkDataType(DataType carbonDataType) {
        if (carbonDataType == org.apache.carbondata.core.metadata.datatype.DataTypes.STRING) {
            return DataTypes.StringType;
        }
        if (carbonDataType == org.apache.carbondata.core.metadata.datatype.DataTypes.SHORT) {
            return DataTypes.ShortType;
        }
        if (carbonDataType == org.apache.carbondata.core.metadata.datatype.DataTypes.INT) {
            return DataTypes.IntegerType;
        }
        if (carbonDataType == org.apache.carbondata.core.metadata.datatype.DataTypes.LONG) {
            return DataTypes.LongType;
        }
        if (carbonDataType == org.apache.carbondata.core.metadata.datatype.DataTypes.DOUBLE) {
            return DataTypes.DoubleType;
        }
        if (carbonDataType == org.apache.carbondata.core.metadata.datatype.DataTypes.BOOLEAN) {
            return DataTypes.BooleanType;
        }
        if (org.apache.carbondata.core.metadata.datatype.DataTypes.isDecimal((DataType)carbonDataType)) {
            return DataTypes.createDecimalType();
        }
        if (carbonDataType == org.apache.carbondata.core.metadata.datatype.DataTypes.TIMESTAMP) {
            return DataTypes.TimestampType;
        }
        if (carbonDataType == org.apache.carbondata.core.metadata.datatype.DataTypes.DATE) {
            return DataTypes.DateType;
        }
        return null;
    }

    public static StructField[] convertCarbonSchemaToSparkSchema(CarbonColumn[] carbonColumns) {
        StructField[] fields = new StructField[carbonColumns.length];
        for (int i = 0; i < carbonColumns.length; ++i) {
            CarbonColumn carbonColumn = carbonColumns[i];
            if (carbonColumn.isDimension().booleanValue()) {
                if (carbonColumn.hasEncoding(Encoding.DIRECT_DICTIONARY)) {
                    DirectDictionaryGenerator generator = DirectDictionaryKeyGeneratorFactory.getDirectDictionaryGenerator((DataType)carbonColumn.getDataType());
                    fields[i] = new StructField(carbonColumn.getColName(), CarbonTypeUtil.convertCarbonToSparkDataType(generator.getReturnType()), true, null);
                    continue;
                }
                if (!carbonColumn.hasEncoding(Encoding.DICTIONARY)) {
                    fields[i] = new StructField(carbonColumn.getColName(), CarbonTypeUtil.convertCarbonToSparkDataType(carbonColumn.getDataType()), true, null);
                    continue;
                }
                if (carbonColumn.isComplex().booleanValue()) {
                    fields[i] = new StructField(carbonColumn.getColName(), CarbonTypeUtil.convertCarbonToSparkDataType(carbonColumn.getDataType()), true, null);
                    continue;
                }
                fields[i] = new StructField(carbonColumn.getColName(), CarbonTypeUtil.convertCarbonToSparkDataType(org.apache.carbondata.core.metadata.datatype.DataTypes.INT), true, null);
                continue;
            }
            if (!carbonColumn.isMeasure().booleanValue()) continue;
            DataType dataType = carbonColumn.getDataType();
            if (dataType == org.apache.carbondata.core.metadata.datatype.DataTypes.BOOLEAN || dataType == org.apache.carbondata.core.metadata.datatype.DataTypes.SHORT || dataType == org.apache.carbondata.core.metadata.datatype.DataTypes.INT || dataType == org.apache.carbondata.core.metadata.datatype.DataTypes.LONG) {
                fields[i] = new StructField(carbonColumn.getColName(), CarbonTypeUtil.convertCarbonToSparkDataType(dataType), true, null);
                continue;
            }
            if (org.apache.carbondata.core.metadata.datatype.DataTypes.isDecimal((DataType)dataType)) {
                CarbonMeasure measure = (CarbonMeasure)carbonColumn;
                fields[i] = new StructField(carbonColumn.getColName(), (org.apache.spark.sql.types.DataType)new DecimalType(measure.getPrecision(), measure.getScale()), true, null);
                continue;
            }
            fields[i] = new StructField(carbonColumn.getColName(), CarbonTypeUtil.convertCarbonToSparkDataType(org.apache.carbondata.core.metadata.datatype.DataTypes.DOUBLE), true, null);
        }
        return fields;
    }
}

