/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.hadoop.util;

import java.util.Map;
import org.apache.carbondata.core.datastore.DataRefNode;
import org.apache.carbondata.core.datastore.IndexKey;
import org.apache.carbondata.core.datastore.block.AbstractIndex;
import org.apache.carbondata.core.datastore.block.SegmentProperties;
import org.apache.carbondata.core.datastore.impl.btree.BTreeDataRefNodeFinder;
import org.apache.carbondata.core.datastore.impl.btree.BlockBTreeLeafNode;
import org.apache.carbondata.core.keygenerator.KeyGenException;
import org.apache.carbondata.core.mutate.CarbonUpdateUtil;
import org.apache.carbondata.core.mutate.SegmentUpdateDetails;
import org.apache.carbondata.core.scan.filter.FilterUtil;
import org.apache.carbondata.core.statusmanager.SegmentStatus;
import org.apache.carbondata.core.statusmanager.SegmentUpdateStatusManager;
import org.apache.carbondata.core.util.path.CarbonTablePath;

public class BlockLevelTraverser {
    public long getBlockRowMapping(AbstractIndex abstractIndex, Map<String, Long> blockRowMap, String segId, SegmentUpdateStatusManager updateStatusManager) throws KeyGenException {
        IndexKey searchStartKey = FilterUtil.prepareDefaultStartIndexKey((SegmentProperties)abstractIndex.getSegmentProperties());
        BTreeDataRefNodeFinder blockFinder = new BTreeDataRefNodeFinder(abstractIndex.getSegmentProperties().getEachDimColumnValueSize(), abstractIndex.getSegmentProperties().getNumberOfSortColumns(), abstractIndex.getSegmentProperties().getNumberOfNoDictSortColumns());
        long count = 0L;
        for (DataRefNode currentBlock = blockFinder.findFirstDataBlock(abstractIndex.getDataRefNode(), searchStartKey); currentBlock != null; currentBlock = currentBlock.getNextDataRefNode()) {
            String blockName = ((BlockBTreeLeafNode)currentBlock).getTableBlockInfo().getFilePath();
            blockName = CarbonTablePath.getCarbonDataFileName((String)blockName);
            blockName = blockName + CarbonTablePath.getCarbonDataExtension();
            long rowCount = currentBlock.nodeSize();
            String key = CarbonUpdateUtil.getSegmentBlockNameKey((String)segId, (String)blockName);
            SegmentUpdateDetails details = updateStatusManager.getDetailsForABlock(key);
            if (null != details && CarbonUpdateUtil.isBlockInvalid((SegmentStatus)details.getSegmentStatus())) continue;
            blockRowMap.put(key, rowCount);
            ++count;
        }
        return count;
    }
}

