/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.hadoop.api;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.carbondata.core.datamap.DataMapDistributable;
import org.apache.carbondata.core.datamap.DataMapStoreManager;
import org.apache.carbondata.core.datamap.TableDataMap;
import org.apache.carbondata.core.indexstore.ExtendedBlocklet;
import org.apache.carbondata.core.metadata.AbsoluteTableIdentifier;
import org.apache.carbondata.core.scan.filter.resolver.FilterResolverIntf;
import org.apache.carbondata.hadoop.util.ObjectSerializationUtil;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;

public class DistributableDataMapFormat
extends FileInputFormat<Void, ExtendedBlocklet>
implements Serializable {
    private static final String FILTER_EXP = "mapreduce.input.distributed.datamap.filter";
    private AbsoluteTableIdentifier identifier;
    private String dataMapName;
    private List<String> validSegments;
    private String className;
    private List<String> partitions;

    public DistributableDataMapFormat(AbsoluteTableIdentifier identifier, String dataMapName, List<String> validSegments, List<String> partitions, String className) {
        this.identifier = identifier;
        this.dataMapName = dataMapName;
        this.validSegments = validSegments;
        this.className = className;
        this.partitions = partitions;
    }

    public static void setFilterExp(Configuration configuration, FilterResolverIntf filterExp) throws IOException {
        if (filterExp != null) {
            String string = ObjectSerializationUtil.convertObjectToString(filterExp);
            configuration.set(FILTER_EXP, string);
        }
    }

    private static FilterResolverIntf getFilterExp(Configuration configuration) throws IOException {
        String filterString = configuration.get(FILTER_EXP);
        if (filterString != null) {
            Object toObject = ObjectSerializationUtil.convertStringToObject(filterString);
            return (FilterResolverIntf)toObject;
        }
        return null;
    }

    public List<InputSplit> getSplits(JobContext job) throws IOException {
        TableDataMap dataMap = DataMapStoreManager.getInstance().getDataMap(this.identifier, this.dataMapName, this.className);
        List distributables = dataMap.toDistributable(this.validSegments);
        ArrayList<InputSplit> inputSplits = new ArrayList<InputSplit>(distributables.size());
        inputSplits.addAll(distributables);
        return inputSplits;
    }

    public RecordReader<Void, ExtendedBlocklet> createRecordReader(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        return new RecordReader<Void, ExtendedBlocklet>(){
            private Iterator<ExtendedBlocklet> blockletIterator;
            private ExtendedBlocklet currBlocklet;

            public void initialize(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
                DataMapDistributable distributable = (DataMapDistributable)inputSplit;
                TableDataMap dataMap = DataMapStoreManager.getInstance().getDataMap(DistributableDataMapFormat.this.identifier, distributable.getDataMapName(), distributable.getDataMapFactoryClass());
                this.blockletIterator = dataMap.prune(distributable, DistributableDataMapFormat.getFilterExp(taskAttemptContext.getConfiguration()), DistributableDataMapFormat.this.partitions).iterator();
            }

            public boolean nextKeyValue() throws IOException, InterruptedException {
                boolean hasNext = this.blockletIterator.hasNext();
                if (hasNext) {
                    this.currBlocklet = this.blockletIterator.next();
                }
                return hasNext;
            }

            public Void getCurrentKey() throws IOException, InterruptedException {
                return null;
            }

            public ExtendedBlocklet getCurrentValue() throws IOException, InterruptedException {
                return this.currBlocklet;
            }

            public float getProgress() throws IOException, InterruptedException {
                return 0.0f;
            }

            public void close() throws IOException {
            }
        };
    }
}

