/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.hadoop.api;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import org.apache.carbondata.common.CarbonIterator;
import org.apache.carbondata.core.constants.CarbonLoadOptionConstants;
import org.apache.carbondata.core.metadata.datatype.StructField;
import org.apache.carbondata.core.metadata.datatype.StructType;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.metadata.schema.table.TableInfo;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.carbondata.core.util.CarbonThreadFactory;
import org.apache.carbondata.hadoop.api.CarbonOutputCommitter;
import org.apache.carbondata.hadoop.util.ObjectSerializationUtil;
import org.apache.carbondata.processing.loading.DataLoadExecutor;
import org.apache.carbondata.processing.loading.TableProcessingOperations;
import org.apache.carbondata.processing.loading.csvinput.StringArrayWritable;
import org.apache.carbondata.processing.loading.iterator.CarbonOutputIteratorWrapper;
import org.apache.carbondata.processing.loading.model.CarbonDataLoadSchema;
import org.apache.carbondata.processing.loading.model.CarbonLoadModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;

public class CarbonTableOutputFormat
extends FileOutputFormat<NullWritable, StringArrayWritable> {
    private static final String LOAD_MODEL = "mapreduce.carbontable.load.model";
    private static final String DATABASE_NAME = "mapreduce.carbontable.databaseName";
    private static final String TABLE_NAME = "mapreduce.carbontable.tableName";
    private static final String TABLE = "mapreduce.carbontable.table";
    private static final String TABLE_PATH = "mapreduce.carbontable.tablepath";
    private static final String INPUT_SCHEMA = "mapreduce.carbontable.inputschema";
    private static final String TEMP_STORE_LOCATIONS = "mapreduce.carbontable.tempstore.locations";
    private static final String OVERWRITE_SET = "mapreduce.carbontable.set.overwrite";
    public static final String COMPLEX_DELIMITERS = "mapreduce.carbontable.complex_delimiters";
    public static final String SERIALIZATION_NULL_FORMAT = "mapreduce.carbontable.serialization.null.format";
    public static final String BAD_RECORDS_LOGGER_ENABLE = "mapreduce.carbontable.bad.records.logger.enable";
    public static final String BAD_RECORDS_LOGGER_ACTION = "mapreduce.carbontable.bad.records.logger.action";
    public static final String IS_EMPTY_DATA_BAD_RECORD = "mapreduce.carbontable.empty.data.bad.record";
    public static final String SKIP_EMPTY_LINE = "mapreduce.carbontable.skip.empty.line";
    public static final String SORT_SCOPE = "mapreduce.carbontable.load.sort.scope";
    public static final String BATCH_SORT_SIZE_INMB = "mapreduce.carbontable.batch.sort.size.inmb";
    public static final String GLOBAL_SORT_PARTITIONS = "mapreduce.carbontable.global.sort.partitions";
    public static final String BAD_RECORD_PATH = "mapreduce.carbontable.bad.record.path";
    public static final String DATE_FORMAT = "mapreduce.carbontable.date.format";
    public static final String TIMESTAMP_FORMAT = "mapreduce.carbontable.timestamp.format";
    public static final String IS_ONE_PASS_LOAD = "mapreduce.carbontable.one.pass.load";
    public static final String DICTIONARY_SERVER_HOST = "mapreduce.carbontable.dict.server.host";
    public static final String DICTIONARY_SERVER_PORT = "mapreduce.carbontable.dict.server.port";
    public static final String UPADTE_TIMESTAMP = "mapreduce.carbontable.update.timestamp";
    public static final String SEGMENTS_TO_BE_DELETED = "mapreduce.carbontable.segments.to.be.removed";
    public static final String OPERATION_CONTEXT = "mapreduce.carbontable.operation.context";
    private static final Log LOG = LogFactory.getLog(CarbonTableOutputFormat.class);
    private CarbonOutputCommitter committer;

    public static void setDatabaseName(Configuration configuration, String databaseName) {
        if (null != databaseName) {
            configuration.set(DATABASE_NAME, databaseName);
        }
    }

    public static String getDatabaseName(Configuration configuration) {
        return configuration.get(DATABASE_NAME);
    }

    public static void setTableName(Configuration configuration, String tableName) {
        if (null != tableName) {
            configuration.set(TABLE_NAME, tableName);
        }
    }

    public static String getTableName(Configuration configuration) {
        return configuration.get(TABLE_NAME);
    }

    public static void setTablePath(Configuration configuration, String tablePath) {
        if (null != tablePath) {
            configuration.set(TABLE_PATH, tablePath);
        }
    }

    public static String getTablePath(Configuration configuration) {
        return configuration.get(TABLE_PATH);
    }

    public static void setCarbonTable(Configuration configuration, CarbonTable carbonTable) throws IOException {
        if (carbonTable != null) {
            configuration.set(TABLE, ObjectSerializationUtil.convertObjectToString(carbonTable.getTableInfo().serialize()));
        }
    }

    public static CarbonTable getCarbonTable(Configuration configuration) throws IOException {
        CarbonTable carbonTable = null;
        String encodedString = configuration.get(TABLE);
        if (encodedString != null) {
            byte[] bytes = (byte[])ObjectSerializationUtil.convertStringToObject(encodedString);
            TableInfo tableInfo = TableInfo.deserialize((byte[])bytes);
            carbonTable = CarbonTable.buildFromTableInfo((TableInfo)tableInfo);
        }
        return carbonTable;
    }

    public static void setLoadModel(Configuration configuration, CarbonLoadModel loadModel) throws IOException {
        if (loadModel != null) {
            configuration.set(LOAD_MODEL, ObjectSerializationUtil.convertObjectToString(loadModel));
        }
    }

    public static void setInputSchema(Configuration configuration, StructType inputSchema) throws IOException {
        if (inputSchema == null || inputSchema.getFields().size() <= 0) {
            throw new UnsupportedOperationException("Input schema must be set");
        }
        configuration.set(INPUT_SCHEMA, ObjectSerializationUtil.convertObjectToString(inputSchema));
    }

    private static StructType getInputSchema(Configuration configuration) throws IOException {
        String encodedString = configuration.get(INPUT_SCHEMA);
        if (encodedString != null) {
            return (StructType)ObjectSerializationUtil.convertStringToObject(encodedString);
        }
        return null;
    }

    public static boolean isOverwriteSet(Configuration configuration) {
        String overwrite = configuration.get(OVERWRITE_SET);
        if (overwrite != null) {
            return Boolean.parseBoolean(overwrite);
        }
        return false;
    }

    public static void setOverwrite(Configuration configuration, boolean overwrite) {
        configuration.set(OVERWRITE_SET, String.valueOf(overwrite));
    }

    public static void setTempStoreLocations(Configuration configuration, String[] tempLocations) throws IOException {
        if (tempLocations != null && tempLocations.length > 0) {
            configuration.set(TEMP_STORE_LOCATIONS, ObjectSerializationUtil.convertObjectToString(tempLocations));
        }
    }

    private static String[] getTempStoreLocations(TaskAttemptContext taskAttemptContext) throws IOException {
        String encodedString = taskAttemptContext.getConfiguration().get(TEMP_STORE_LOCATIONS);
        if (encodedString != null) {
            return (String[])ObjectSerializationUtil.convertStringToObject(encodedString);
        }
        return new String[]{System.getProperty("java.io.tmpdir") + "/" + System.nanoTime() + "_" + taskAttemptContext.getTaskAttemptID().toString()};
    }

    public synchronized OutputCommitter getOutputCommitter(TaskAttemptContext context) throws IOException {
        if (this.committer == null) {
            Path output = CarbonTableOutputFormat.getOutputPath((JobContext)context);
            this.committer = new CarbonOutputCommitter(output, context);
        }
        return this.committer;
    }

    public RecordWriter<NullWritable, StringArrayWritable> getRecordWriter(TaskAttemptContext taskAttemptContext) throws IOException {
        final CarbonLoadModel loadModel = CarbonTableOutputFormat.getLoadModel(taskAttemptContext.getConfiguration());
        loadModel.setTaskNo(taskAttemptContext.getConfiguration().get("carbon.outputformat.taskno", String.valueOf(System.nanoTime())));
        final String[] tempStoreLocations = CarbonTableOutputFormat.getTempStoreLocations(taskAttemptContext);
        final CarbonOutputIteratorWrapper iteratorWrapper = new CarbonOutputIteratorWrapper();
        final DataLoadExecutor dataLoadExecutor = new DataLoadExecutor();
        ExecutorService executorService = Executors.newFixedThreadPool(1, (ThreadFactory)new CarbonThreadFactory("CarbonRecordWriter:" + loadModel.getTableName()));
        Future<?> future = executorService.submit(new Thread(){

            @Override
            public void run() {
                try {
                    dataLoadExecutor.execute(loadModel, tempStoreLocations, new CarbonIterator[]{iteratorWrapper});
                }
                catch (Exception e) {
                    dataLoadExecutor.close();
                    TableProcessingOperations.deleteLocalDataLoadFolderLocation((CarbonLoadModel)loadModel, (boolean)false, (boolean)false);
                    throw new RuntimeException(e);
                }
            }
        });
        return new CarbonRecordWriter(iteratorWrapper, dataLoadExecutor, loadModel, future, executorService);
    }

    public static CarbonLoadModel getLoadModel(Configuration conf) throws IOException {
        String encodedString = conf.get(LOAD_MODEL);
        if (encodedString != null) {
            CarbonLoadModel model = (CarbonLoadModel)ObjectSerializationUtil.convertStringToObject(encodedString);
            return model;
        }
        CarbonLoadModel model = new CarbonLoadModel();
        CarbonProperties carbonProperty = CarbonProperties.getInstance();
        model.setDatabaseName(CarbonTableOutputFormat.getDatabaseName(conf));
        model.setTableName(CarbonTableOutputFormat.getTableName(conf));
        model.setCarbonDataLoadSchema(new CarbonDataLoadSchema(CarbonTableOutputFormat.getCarbonTable(conf)));
        model.setTablePath(CarbonTableOutputFormat.getTablePath(conf));
        CarbonTableOutputFormat.setFileHeader(conf, model);
        model.setSerializationNullFormat(conf.get(SERIALIZATION_NULL_FORMAT, "\\N"));
        model.setBadRecordsLoggerEnable(conf.get(BAD_RECORDS_LOGGER_ENABLE, carbonProperty.getProperty("carbon.options.bad.records.logger.enable", CarbonLoadOptionConstants.CARBON_OPTIONS_BAD_RECORDS_LOGGER_ENABLE_DEFAULT)));
        model.setBadRecordsAction(conf.get(BAD_RECORDS_LOGGER_ACTION, carbonProperty.getProperty("carbon.bad.records.action", "FAIL")));
        model.setIsEmptyDataBadRecord(conf.get(IS_EMPTY_DATA_BAD_RECORD, carbonProperty.getProperty("carbon.options.is.empty.data.bad.record", "false")));
        model.setSkipEmptyLine(conf.get(SKIP_EMPTY_LINE, carbonProperty.getProperty("carbon.options.is.empty.data.bad.record")));
        String complexDelim = conf.get(COMPLEX_DELIMITERS, "\\$,\\:");
        String[] split = complexDelim.split(",");
        model.setComplexDelimiterLevel1(split[0]);
        if (split.length > 1) {
            model.setComplexDelimiterLevel1(split[1]);
        }
        model.setDateFormat(conf.get(DATE_FORMAT, carbonProperty.getProperty("carbon.options.dateformat", "")));
        model.setTimestampformat(conf.get(TIMESTAMP_FORMAT, carbonProperty.getProperty("carbon.options.timestampformat", "")));
        model.setGlobalSortPartitions(conf.get(GLOBAL_SORT_PARTITIONS, carbonProperty.getProperty("carbon.options.global.sort.partitions", null)));
        model.setBatchSortSizeInMb(conf.get(BATCH_SORT_SIZE_INMB, carbonProperty.getProperty("carbon.options.batch.sort.size.inmb", carbonProperty.getProperty("carbon.load.batch.sort.size.inmb", "0"))));
        model.setBadRecordsLocation(conf.get(BAD_RECORD_PATH, carbonProperty.getProperty("carbon.options.bad.record.path", carbonProperty.getProperty("carbon.badRecords.location", ""))));
        model.setUseOnePass(conf.getBoolean(IS_ONE_PASS_LOAD, Boolean.parseBoolean(carbonProperty.getProperty("carbon.options.single.pass", "false"))));
        return model;
    }

    private static void setFileHeader(Configuration configuration, CarbonLoadModel model) throws IOException {
        StructType inputSchema = CarbonTableOutputFormat.getInputSchema(configuration);
        if (inputSchema == null || inputSchema.getFields().size() == 0) {
            throw new UnsupportedOperationException("Input schema must be set");
        }
        List fields = inputSchema.getFields();
        StringBuilder builder = new StringBuilder();
        String[] columns = new String[fields.size()];
        int i = 0;
        for (StructField field : fields) {
            builder.append(field.getFieldName());
            builder.append(",");
            columns[i++] = field.getFieldName();
        }
        String header = builder.toString();
        model.setCsvHeader(header.substring(0, header.length() - 1));
        model.setCsvHeaderColumns(columns);
    }

    public static class CarbonRecordWriter
    extends RecordWriter<NullWritable, StringArrayWritable> {
        private CarbonOutputIteratorWrapper iteratorWrapper;
        private DataLoadExecutor dataLoadExecutor;
        private CarbonLoadModel loadModel;
        private ExecutorService executorService;
        private Future future;

        public CarbonRecordWriter(CarbonOutputIteratorWrapper iteratorWrapper, DataLoadExecutor dataLoadExecutor, CarbonLoadModel loadModel, Future future, ExecutorService executorService) {
            this.iteratorWrapper = iteratorWrapper;
            this.dataLoadExecutor = dataLoadExecutor;
            this.loadModel = loadModel;
            this.executorService = executorService;
            this.future = future;
        }

        public void write(NullWritable aVoid, StringArrayWritable strings) throws InterruptedException {
            this.iteratorWrapper.write(strings.get());
        }

        public void close(TaskAttemptContext taskAttemptContext) throws InterruptedException {
            this.iteratorWrapper.closeWriter();
            try {
                this.future.get();
            }
            catch (ExecutionException e) {
                LOG.error((Object)"Error while loading data", (Throwable)e);
                throw new InterruptedException(e.getMessage());
            }
            finally {
                this.executorService.shutdownNow();
                this.dataLoadExecutor.close();
                TableProcessingOperations.deleteLocalDataLoadFolderLocation((CarbonLoadModel)this.loadModel, (boolean)false, (boolean)false);
            }
            LOG.info((Object)("Closed partition writer task " + taskAttemptContext.getTaskAttemptID()));
        }

        public CarbonLoadModel getLoadModel() {
            return this.loadModel;
        }
    }
}

