/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.hadoop.api;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.carbondata.core.datamap.DataMapStoreManager;
import org.apache.carbondata.core.datamap.TableDataMap;
import org.apache.carbondata.core.datastore.filesystem.CarbonFile;
import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.carbondata.core.exception.InvalidConfigurationException;
import org.apache.carbondata.core.indexstore.ExtendedBlocklet;
import org.apache.carbondata.core.indexstore.blockletindex.BlockletDataMapFactory;
import org.apache.carbondata.core.metadata.AbsoluteTableIdentifier;
import org.apache.carbondata.core.metadata.ColumnarFormatVersion;
import org.apache.carbondata.core.metadata.schema.PartitionInfo;
import org.apache.carbondata.core.metadata.schema.partition.PartitionType;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.metadata.schema.table.TableInfo;
import org.apache.carbondata.core.mutate.CarbonUpdateUtil;
import org.apache.carbondata.core.mutate.SegmentUpdateDetails;
import org.apache.carbondata.core.mutate.UpdateVO;
import org.apache.carbondata.core.mutate.data.BlockMappingVO;
import org.apache.carbondata.core.reader.CarbonIndexFileReader;
import org.apache.carbondata.core.scan.expression.Expression;
import org.apache.carbondata.core.scan.filter.FilterExpressionProcessor;
import org.apache.carbondata.core.scan.filter.SingleTableProvider;
import org.apache.carbondata.core.scan.filter.TableProvider;
import org.apache.carbondata.core.scan.filter.resolver.FilterResolverIntf;
import org.apache.carbondata.core.scan.model.CarbonQueryPlan;
import org.apache.carbondata.core.scan.model.QueryModel;
import org.apache.carbondata.core.stats.QueryStatistic;
import org.apache.carbondata.core.stats.QueryStatisticsRecorder;
import org.apache.carbondata.core.statusmanager.FileFormat;
import org.apache.carbondata.core.statusmanager.SegmentStatus;
import org.apache.carbondata.core.statusmanager.SegmentStatusManager;
import org.apache.carbondata.core.statusmanager.SegmentUpdateStatusManager;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.carbondata.core.util.CarbonTimeStatisticsFactory;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.core.util.DataTypeConverter;
import org.apache.carbondata.core.util.DataTypeConverterImpl;
import org.apache.carbondata.core.util.path.CarbonStorePath;
import org.apache.carbondata.core.util.path.CarbonTablePath;
import org.apache.carbondata.format.BlockIndex;
import org.apache.carbondata.hadoop.CarbonInputSplit;
import org.apache.carbondata.hadoop.CarbonMultiBlockSplit;
import org.apache.carbondata.hadoop.CarbonProjection;
import org.apache.carbondata.hadoop.CarbonRecordReader;
import org.apache.carbondata.hadoop.api.DataMapJob;
import org.apache.carbondata.hadoop.api.DistributableDataMapFormat;
import org.apache.carbondata.hadoop.readsupport.CarbonReadSupport;
import org.apache.carbondata.hadoop.readsupport.impl.DictionaryDecodeReadSupport;
import org.apache.carbondata.hadoop.util.CarbonInputFormatUtil;
import org.apache.carbondata.hadoop.util.ObjectSerializationUtil;
import org.apache.carbondata.hadoop.util.SchemaReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.hadoop.mapreduce.security.TokenCache;
import org.apache.hadoop.security.Credentials;

public class CarbonTableInputFormat<T>
extends FileInputFormat<Void, T> {
    public static final String INPUT_SEGMENT_NUMBERS = "mapreduce.input.carboninputformat.segmentnumbers";
    public static final String VALIDATE_INPUT_SEGMENT_IDs = "mapreduce.input.carboninputformat.validsegments";
    public static final String INPUT_FILES = "mapreduce.input.carboninputformat.files";
    public static final String ALTER_PARTITION_ID = "mapreduce.input.carboninputformat.partitionid";
    private static final Log LOG = LogFactory.getLog(CarbonTableInputFormat.class);
    private static final String FILTER_PREDICATE = "mapreduce.input.carboninputformat.filter.predicate";
    private static final String COLUMN_PROJECTION = "mapreduce.input.carboninputformat.projection";
    private static final String TABLE_INFO = "mapreduce.input.carboninputformat.tableinfo";
    private static final String CARBON_READ_SUPPORT = "mapreduce.input.carboninputformat.readsupport";
    private static final String CARBON_CONVERTER = "mapreduce.input.carboninputformat.converter";
    private static final String DATA_MAP_DSTR = "mapreduce.input.carboninputformat.datamapdstr";
    public static final String DATABASE_NAME = "mapreduce.input.carboninputformat.databaseName";
    public static final String TABLE_NAME = "mapreduce.input.carboninputformat.tableName";
    public static final String PARTITIONS_TO_PRUNE = "mapreduce.input.carboninputformat.partitions.to.prune";
    public static final String UPADTE_T = "mapreduce.input.carboninputformat.partitions.to.prune";
    private CarbonTable carbonTable;

    public static void setTableInfo(Configuration configuration, TableInfo tableInfo) throws IOException {
        if (null != tableInfo) {
            configuration.set(TABLE_INFO, CarbonUtil.encodeToString((byte[])tableInfo.serialize()));
        }
    }

    private static TableInfo getTableInfo(Configuration configuration) throws IOException {
        String tableInfoStr = configuration.get(TABLE_INFO);
        if (tableInfoStr == null) {
            return null;
        }
        TableInfo output = new TableInfo();
        output.readFields((DataInput)new DataInputStream(new ByteArrayInputStream(CarbonUtil.decodeStringToBytes((String)tableInfoStr))));
        return output;
    }

    private CarbonTable getOrCreateCarbonTable(Configuration configuration) throws IOException {
        if (this.carbonTable == null) {
            TableInfo tableInfo = CarbonTableInputFormat.getTableInfo(configuration);
            CarbonTable carbonTable = tableInfo != null ? CarbonTable.buildFromTableInfo((TableInfo)tableInfo) : SchemaReader.readCarbonTableFromStore(this.getAbsoluteTableIdentifier(configuration));
            this.carbonTable = carbonTable;
            return carbonTable;
        }
        return this.carbonTable;
    }

    public static void setTablePath(Configuration configuration, String tablePath) {
        configuration.set("mapreduce.input.fileinputformat.inputdir", tablePath);
    }

    public static void setPartitionIdList(Configuration configuration, List<String> partitionIds) {
        configuration.set(ALTER_PARTITION_ID, partitionIds.toString());
    }

    public static void setDataMapJob(Configuration configuration, DataMapJob dataMapJob) throws IOException {
        if (dataMapJob != null) {
            String toString = ObjectSerializationUtil.convertObjectToString(dataMapJob);
            configuration.set(DATA_MAP_DSTR, toString);
        }
    }

    private static DataMapJob getDataMapJob(Configuration configuration) throws IOException {
        String jobString = configuration.get(DATA_MAP_DSTR);
        if (jobString != null) {
            return (DataMapJob)ObjectSerializationUtil.convertStringToObject(jobString);
        }
        return null;
    }

    public static void setFilterPredicates(Configuration configuration, Expression filterExpression) {
        if (filterExpression == null) {
            return;
        }
        try {
            String filterString = ObjectSerializationUtil.convertObjectToString(filterExpression);
            configuration.set(FILTER_PREDICATE, filterString);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while setting filter expression to Job", e);
        }
    }

    public static void setColumnProjection(Configuration configuration, CarbonProjection projection) {
        if (projection == null || projection.isEmpty()) {
            return;
        }
        String[] allColumns = projection.getAllColumns();
        StringBuilder builder = new StringBuilder();
        for (String column : allColumns) {
            builder.append(column).append(",");
        }
        String columnString = builder.toString();
        columnString = columnString.substring(0, columnString.length() - 1);
        configuration.set(COLUMN_PROJECTION, columnString);
    }

    public static String getColumnProjection(Configuration configuration) {
        return configuration.get(COLUMN_PROJECTION);
    }

    public static void setCarbonReadSupport(Configuration configuration, Class<? extends CarbonReadSupport> readSupportClass) {
        if (readSupportClass != null) {
            configuration.set(CARBON_READ_SUPPORT, readSupportClass.getName());
        }
    }

    private static CarbonTablePath getTablePath(AbsoluteTableIdentifier absIdentifier) {
        return CarbonStorePath.getCarbonTablePath((AbsoluteTableIdentifier)absIdentifier);
    }

    public static void setSegmentsToAccess(Configuration configuration, List<String> validSegments) {
        configuration.set(INPUT_SEGMENT_NUMBERS, CarbonUtil.convertToString(validSegments));
    }

    public static void setQuerySegment(Configuration conf, AbsoluteTableIdentifier identifier) {
        String dbName = identifier.getCarbonTableIdentifier().getDatabaseName().toLowerCase();
        String tbName = identifier.getCarbonTableIdentifier().getTableName().toLowerCase();
        String segmentNumbersFromProperty = CarbonProperties.getInstance().getProperty("carbon.input.segments." + dbName + "." + tbName, "*");
        if (!segmentNumbersFromProperty.trim().equals("*")) {
            CarbonTableInputFormat.setSegmentsToAccess(conf, Arrays.asList(segmentNumbersFromProperty.split(",")));
        }
    }

    public static void setValidateSegmentsToAccess(Configuration configuration, Boolean validate) {
        configuration.set(VALIDATE_INPUT_SEGMENT_IDs, validate.toString());
    }

    public static boolean getValidateSegmentsToAccess(Configuration configuration) {
        return configuration.get(VALIDATE_INPUT_SEGMENT_IDs, "true").equalsIgnoreCase("true");
    }

    public static void setPartitionsToPrune(Configuration configuration, List<String> partitions) {
        if (partitions == null) {
            return;
        }
        try {
            String partitionString = ObjectSerializationUtil.convertObjectToString(partitions);
            configuration.set("mapreduce.input.carboninputformat.partitions.to.prune", partitionString);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while setting patition information to Job", e);
        }
    }

    public static List<String> getPartitionsToPrune(Configuration configuration) throws IOException {
        String partitionString = configuration.get("mapreduce.input.carboninputformat.partitions.to.prune");
        if (partitionString != null) {
            return (List)ObjectSerializationUtil.convertStringToObject(partitionString);
        }
        return null;
    }

    public AbsoluteTableIdentifier getAbsoluteTableIdentifier(Configuration configuration) throws IOException {
        String tablePath = configuration.get("mapreduce.input.fileinputformat.inputdir", "");
        try {
            return AbsoluteTableIdentifier.from((String)tablePath, (String)CarbonTableInputFormat.getDatabaseName(configuration), (String)CarbonTableInputFormat.getTableName(configuration));
        }
        catch (InvalidConfigurationException e) {
            throw new IOException(e);
        }
    }

    public List<InputSplit> getSplits(JobContext job) throws IOException {
        List<InputSplit> splitsOfStreaming;
        AbsoluteTableIdentifier identifier = this.getAbsoluteTableIdentifier(job.getConfiguration());
        SegmentUpdateStatusManager updateStatusManager = new SegmentUpdateStatusManager(identifier);
        CarbonTable carbonTable = this.getOrCreateCarbonTable(job.getConfiguration());
        if (null == carbonTable) {
            throw new IOException("Missing/Corrupt schema file for table.");
        }
        TableDataMap blockletMap = DataMapStoreManager.getInstance().getDataMap(identifier, "clustered.btree.blocklet", BlockletDataMapFactory.class.getName());
        ArrayList<String> invalidSegments = new ArrayList<String>();
        ArrayList<UpdateVO> invalidTimestampsList = new ArrayList<UpdateVO>();
        List streamSegments = null;
        if (CarbonTableInputFormat.getValidateSegmentsToAccess(job.getConfiguration())) {
            SegmentStatusManager segmentStatusManager = new SegmentStatusManager(identifier);
            SegmentStatusManager.ValidAndInvalidSegmentsInfo segments = segmentStatusManager.getValidAndInvalidSegments();
            SegmentUpdateDetails[] validSegments = segments.getValidSegments();
            streamSegments = segments.getStreamSegments();
            if (validSegments.size() == 0) {
                return this.getSplitsOfStreaming(job, identifier, streamSegments);
            }
            List<String> filteredSegmentToAccess = this.getFilteredSegment(job, (List<String>)validSegments);
            if (filteredSegmentToAccess.size() == 0) {
                return new ArrayList<InputSplit>(0);
            }
            CarbonTableInputFormat.setSegmentsToAccess(job.getConfiguration(), filteredSegmentToAccess);
            invalidSegments.addAll(segments.getInvalidSegments());
            for (String invalidSegmentId : invalidSegments) {
                invalidTimestampsList.add(updateStatusManager.getInvalidTimestampRange(invalidSegmentId));
            }
            if (invalidSegments.size() > 0) {
                blockletMap.clear(invalidSegments);
            }
        }
        List<String> filteredSegmentToAccess = Arrays.asList(this.getSegmentsToAccess(job));
        ArrayList<String> toBeCleanedSegments = new ArrayList<String>();
        for (SegmentUpdateDetails segmentUpdateDetail : updateStatusManager.getUpdateStatusDetails()) {
            boolean refreshNeeded = DataMapStoreManager.getInstance().getTableSegmentRefresher(identifier).isRefreshNeeded(segmentUpdateDetail.getSegmentName(), updateStatusManager);
            if (!refreshNeeded) continue;
            toBeCleanedSegments.add(segmentUpdateDetail.getSegmentName());
        }
        for (String segment : filteredSegmentToAccess) {
            if (!DataMapStoreManager.getInstance().getTableSegmentRefresher(identifier).isRefreshNeeded(segment)) continue;
            toBeCleanedSegments.add(segment);
        }
        blockletMap.clear(toBeCleanedSegments);
        Expression filter = this.getFilterPredicates(job.getConfiguration());
        SingleTableProvider tableProvider = new SingleTableProvider(carbonTable);
        PartitionInfo partitionInfo = carbonTable.getPartitionInfo(carbonTable.getTableName());
        CarbonInputFormatUtil.processFilterExpression(filter, carbonTable, null, null);
        BitSet matchedPartitions = null;
        if (partitionInfo != null && partitionInfo.getPartitionType() != PartitionType.NATIVE_HIVE && (matchedPartitions = this.setMatchedPartitions(null, filter, partitionInfo, null)) != null) {
            if (matchedPartitions.cardinality() == 0) {
                return new ArrayList<InputSplit>();
            }
            if (matchedPartitions.cardinality() == partitionInfo.getNumPartitions()) {
                matchedPartitions = null;
            }
        }
        FilterResolverIntf filterInterface = CarbonInputFormatUtil.resolveFilter(filter, carbonTable.getAbsoluteTableIdentifier(), (TableProvider)tableProvider);
        List<InputSplit> splits = this.getSplits(job, filterInterface, filteredSegmentToAccess, matchedPartitions, partitionInfo, null);
        if (invalidSegments.size() > 0) {
            for (InputSplit split : splits) {
                ((CarbonInputSplit)split).setInvalidSegments(invalidSegments);
                ((CarbonInputSplit)split).setInvalidTimestampRange(invalidTimestampsList);
            }
        }
        if (!(splitsOfStreaming = this.getSplitsOfStreaming(job, identifier, streamSegments)).isEmpty()) {
            splits.addAll(splitsOfStreaming);
        }
        return splits;
    }

    private List<String> getFilteredSegment(JobContext job, List<String> validSegments) {
        String[] segmentsToAccess = this.getSegmentsToAccess(job);
        HashSet<String> segmentToAccessSet = new HashSet<String>(Arrays.asList(segmentsToAccess));
        ArrayList<String> filteredSegmentToAccess = new ArrayList<String>();
        if (segmentsToAccess.length == 0 || segmentsToAccess[0].equalsIgnoreCase("*")) {
            filteredSegmentToAccess.addAll(validSegments);
        } else {
            for (String validSegment : validSegments) {
                if (!segmentToAccessSet.contains(validSegment)) continue;
                filteredSegmentToAccess.add(validSegment);
            }
            if (!filteredSegmentToAccess.containsAll(segmentToAccessSet)) {
                ArrayList<String> filteredSegmentToAccessTemp = new ArrayList<String>(filteredSegmentToAccess);
                filteredSegmentToAccessTemp.removeAll(segmentToAccessSet);
                LOG.info((Object)("Segments ignored are : " + Arrays.toString(filteredSegmentToAccessTemp.toArray())));
            }
        }
        return filteredSegmentToAccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<InputSplit> getSplitsOfStreaming(JobContext job, AbsoluteTableIdentifier identifier, List<String> streamSegments) throws IOException {
        ArrayList<InputSplit> splits = new ArrayList<InputSplit>();
        if (streamSegments != null && !streamSegments.isEmpty()) {
            CarbonTablePath tablePath = CarbonStorePath.getCarbonTablePath((AbsoluteTableIdentifier)identifier);
            long minSize = Math.max(this.getFormatMinSplitSize(), CarbonTableInputFormat.getMinSplitSize((JobContext)job));
            long maxSize = CarbonTableInputFormat.getMaxSplitSize((JobContext)job);
            for (String segmentId : streamSegments) {
                FileFactory.FileType fileType;
                String segmentDir = tablePath.getSegmentDir("0", segmentId);
                if (!FileFactory.isFileExist((String)segmentDir, (FileFactory.FileType)(fileType = FileFactory.getFileType((String)segmentDir)))) continue;
                String indexName = CarbonTablePath.getCarbonStreamIndexFileName();
                String indexPath = segmentDir + File.separator + indexName;
                CarbonFile index = FileFactory.getCarbonFile((String)indexPath, (FileFactory.FileType)fileType);
                if (!index.exists()) continue;
                CarbonIndexFileReader indexReader = new CarbonIndexFileReader();
                try {
                    indexReader.openThriftReader(indexPath);
                    while (indexReader.hasNext()) {
                        BlockIndex blockIndex = indexReader.readBlockIndexInfo();
                        String filePath = segmentDir + File.separator + blockIndex.getFile_name();
                        Path path = new Path(filePath);
                        long length = blockIndex.getFile_size();
                        if (length != 0L) {
                            int blkIndex;
                            FileSystem fs = FileFactory.getFileSystem((Path)path);
                            FileStatus file = fs.getFileStatus(path);
                            BlockLocation[] blkLocations = fs.getFileBlockLocations(path, 0L, length);
                            long blockSize = file.getBlockSize();
                            long splitSize = this.computeSplitSize(blockSize, minSize, maxSize);
                            long bytesRemaining = length;
                            while ((double)bytesRemaining / (double)splitSize > 1.1) {
                                blkIndex = this.getBlockIndex(blkLocations, length - bytesRemaining);
                                splits.add((InputSplit)this.makeSplit(segmentId, path, length - bytesRemaining, splitSize, blkLocations[blkIndex].getHosts(), blkLocations[blkIndex].getCachedHosts(), FileFormat.ROW_V1));
                                bytesRemaining -= splitSize;
                            }
                            if (bytesRemaining == 0L) continue;
                            blkIndex = this.getBlockIndex(blkLocations, length - bytesRemaining);
                            splits.add((InputSplit)this.makeSplit(segmentId, path, length - bytesRemaining, bytesRemaining, blkLocations[blkIndex].getHosts(), blkLocations[blkIndex].getCachedHosts(), FileFormat.ROW_V1));
                            continue;
                        }
                        splits.add((InputSplit)this.makeSplit(segmentId, path, 0L, length, new String[0], FileFormat.ROW_V1));
                    }
                }
                finally {
                    indexReader.closeThriftReader();
                }
            }
        }
        return splits;
    }

    protected FileSplit makeSplit(String segmentId, Path file, long start, long length, String[] hosts, FileFormat fileFormat) {
        return new CarbonInputSplit(segmentId, file, start, length, hosts, fileFormat);
    }

    protected FileSplit makeSplit(String segmentId, Path file, long start, long length, String[] hosts, String[] inMemoryHosts, FileFormat fileFormat) {
        return new CarbonInputSplit(segmentId, file, start, length, hosts, inMemoryHosts, fileFormat);
    }

    public List<InputSplit> getSplitsOfOneSegment(JobContext job, String targetSegment, List<Integer> oldPartitionIdList, PartitionInfo partitionInfo) throws IOException {
        AbsoluteTableIdentifier identifier = this.getAbsoluteTableIdentifier(job.getConfiguration());
        ArrayList<String> invalidSegments = new ArrayList<String>();
        ArrayList<UpdateVO> invalidTimestampsList = new ArrayList<UpdateVO>();
        ArrayList<String> segmentList = new ArrayList<String>();
        segmentList.add(targetSegment);
        CarbonTableInputFormat.setSegmentsToAccess(job.getConfiguration(), segmentList);
        try {
            Expression filter = this.getFilterPredicates(job.getConfiguration());
            CarbonTable carbonTable = this.getOrCreateCarbonTable(job.getConfiguration());
            if (null == carbonTable) {
                throw new IOException("Missing/Corrupt schema file for table.");
            }
            CarbonInputFormatUtil.processFilterExpression(filter, carbonTable, null, null);
            SingleTableProvider tableProvider = new SingleTableProvider(carbonTable);
            String partitionIds = job.getConfiguration().get(ALTER_PARTITION_ID);
            BitSet matchedPartitions = null;
            if (partitionInfo != null && (matchedPartitions = this.setMatchedPartitions(partitionIds, filter, partitionInfo, oldPartitionIdList)) != null) {
                if (matchedPartitions.cardinality() == 0) {
                    return new ArrayList<InputSplit>();
                }
                if (matchedPartitions.cardinality() == partitionInfo.getNumPartitions()) {
                    matchedPartitions = null;
                }
            }
            FilterResolverIntf filterInterface = CarbonInputFormatUtil.resolveFilter(filter, identifier, (TableProvider)tableProvider);
            List<InputSplit> splits = this.getSplits(job, filterInterface, segmentList, matchedPartitions, partitionInfo, oldPartitionIdList);
            if (invalidSegments.size() > 0) {
                for (InputSplit split : splits) {
                    ((CarbonInputSplit)split).setInvalidSegments(invalidSegments);
                    ((CarbonInputSplit)split).setInvalidTimestampRange(invalidTimestampsList);
                }
            }
            return splits;
        }
        catch (IOException e) {
            throw new RuntimeException("Can't get splits of the target segment ", e);
        }
    }

    private BitSet setMatchedPartitions(String partitionIds, Expression filter, PartitionInfo partitionInfo, List<Integer> oldPartitionIdList) {
        BitSet matchedPartitions = null;
        if (null != partitionIds) {
            String[] partList = partitionIds.replace("[", "").replace("]", "").split(",");
            matchedPartitions = new BitSet(Integer.parseInt(partList[0].trim()));
            for (String partitionId : partList) {
                Integer index = oldPartitionIdList.indexOf(Integer.parseInt(partitionId.trim()));
                matchedPartitions.set(index);
            }
        } else if (null != filter) {
            matchedPartitions = new FilterExpressionProcessor().getFilteredPartitions(filter, partitionInfo);
        }
        return matchedPartitions;
    }

    private List<InputSplit> getSplits(JobContext job, FilterResolverIntf filterResolver, List<String> validSegments, BitSet matchedPartitions, PartitionInfo partitionInfo, List<Integer> oldPartitionIdList) throws IOException {
        LinkedList<InputSplit> result = new LinkedList<InputSplit>();
        UpdateVO invalidBlockVOForSegmentId = null;
        Boolean isIUDTable = false;
        AbsoluteTableIdentifier absoluteTableIdentifier = this.getOrCreateCarbonTable(job.getConfiguration()).getAbsoluteTableIdentifier();
        SegmentUpdateStatusManager updateStatusManager = new SegmentUpdateStatusManager(absoluteTableIdentifier);
        isIUDTable = updateStatusManager.getUpdateStatusDetails().length != 0;
        List<CarbonInputSplit> dataBlocksOfSegment = this.getDataBlocksOfSegment(job, absoluteTableIdentifier, filterResolver, matchedPartitions, validSegments, partitionInfo, oldPartitionIdList);
        for (CarbonInputSplit inputSplit : dataBlocksOfSegment) {
            if (isIUDTable.booleanValue()) {
                invalidBlockVOForSegmentId = updateStatusManager.getInvalidTimestampRange(inputSplit.getSegmentId());
            }
            String[] deleteDeltaFilePath = null;
            if (isIUDTable.booleanValue()) {
                if (CarbonUtil.isInvalidTableBlock((String)inputSplit.getSegmentId(), (String)inputSplit.getPath().toString(), (UpdateVO)invalidBlockVOForSegmentId, (SegmentUpdateStatusManager)updateStatusManager)) continue;
                try {
                    deleteDeltaFilePath = updateStatusManager.getDeleteDeltaFilePath(inputSplit.getPath().toString());
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }
            inputSplit.setDeleteDeltaFiles(deleteDeltaFilePath);
            result.add((InputSplit)inputSplit);
        }
        return result;
    }

    protected Expression getFilterPredicates(Configuration configuration) {
        try {
            String filterExprString = configuration.get(FILTER_PREDICATE);
            if (filterExprString == null) {
                return null;
            }
            Object filter = ObjectSerializationUtil.convertStringToObject(filterExprString);
            return (Expression)filter;
        }
        catch (IOException e) {
            throw new RuntimeException("Error while reading filter expression", e);
        }
    }

    private List<CarbonInputSplit> getDataBlocksOfSegment(JobContext job, AbsoluteTableIdentifier absoluteTableIdentifier, FilterResolverIntf resolver, BitSet matchedPartitions, List<String> segmentIds, PartitionInfo partitionInfo, List<Integer> oldPartitionIdList) throws IOException {
        List<ExtendedBlocklet> prunedBlocklets;
        QueryStatisticsRecorder recorder = CarbonTimeStatisticsFactory.createDriverRecorder();
        QueryStatistic statistic = new QueryStatistic();
        TokenCache.obtainTokensForNamenodes((Credentials)job.getCredentials(), (Path[])new Path[]{new Path(absoluteTableIdentifier.getTablePath())}, (Configuration)job.getConfiguration());
        TableDataMap blockletMap = DataMapStoreManager.getInstance().getDataMap(absoluteTableIdentifier, "clustered.btree.blocklet", BlockletDataMapFactory.class.getName());
        DataMapJob dataMapJob = CarbonTableInputFormat.getDataMapJob(job.getConfiguration());
        List<String> partitionsToPrune = CarbonTableInputFormat.getPartitionsToPrune(job.getConfiguration());
        if (dataMapJob != null) {
            DistributableDataMapFormat datamapDstr = new DistributableDataMapFormat(absoluteTableIdentifier, "clustered.btree.blocklet", segmentIds, partitionsToPrune, BlockletDataMapFactory.class.getName());
            prunedBlocklets = dataMapJob.execute(datamapDstr, resolver);
        } else {
            prunedBlocklets = blockletMap.prune(segmentIds, resolver, partitionsToPrune);
        }
        ArrayList<CarbonInputSplit> resultFilterredBlocks = new ArrayList<CarbonInputSplit>();
        int partitionIndex = 0;
        List partitionIdList = new ArrayList();
        if (partitionInfo != null && partitionInfo.getPartitionType() != PartitionType.NATIVE_HIVE) {
            partitionIdList = partitionInfo.getPartitionIds();
        }
        for (ExtendedBlocklet blocklet : prunedBlocklets) {
            CarbonInputSplit inputSplit;
            long partitionId = CarbonTablePath.DataFileUtil.getTaskIdFromTaskNo((String)CarbonTablePath.DataFileUtil.getTaskNo((String)blocklet.getPath()));
            if (partitionInfo != null && partitionInfo.getPartitionType() != PartitionType.NATIVE_HIVE) {
                partitionIndex = oldPartitionIdList != null ? oldPartitionIdList.indexOf((int)partitionId) : partitionIdList.indexOf((int)partitionId);
            }
            if (partitionIndex == -1 || matchedPartitions != null && !matchedPartitions.get(partitionIndex) || (inputSplit = this.convertToCarbonInputSplit(blocklet)) == null) continue;
            resultFilterredBlocks.add(inputSplit);
        }
        statistic.addStatistics("Time taken to load the Block(s) In Driver Side with Block count ", System.currentTimeMillis());
        recorder.recordStatisticsForDriver(statistic, job.getConfiguration().get("query.id"));
        return resultFilterredBlocks;
    }

    private CarbonInputSplit convertToCarbonInputSplit(ExtendedBlocklet blocklet) throws IOException {
        CarbonInputSplit split = CarbonInputSplit.from(blocklet.getSegmentId(), blocklet.getBlockletId(), new FileSplit(new Path(blocklet.getPath()), 0L, blocklet.getLength(), blocklet.getLocations()), ColumnarFormatVersion.valueOf((short)blocklet.getDetailInfo().getVersionNumber()));
        split.setDetailInfo(blocklet.getDetailInfo());
        return split;
    }

    public RecordReader<Void, T> createRecordReader(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        Configuration configuration = taskAttemptContext.getConfiguration();
        QueryModel queryModel = this.getQueryModel(inputSplit, taskAttemptContext);
        CarbonReadSupport<T> readSupport = this.getReadSupportClass(configuration);
        return new CarbonRecordReader<T>(queryModel, readSupport);
    }

    public QueryModel getQueryModel(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException {
        Configuration configuration = taskAttemptContext.getConfiguration();
        CarbonTable carbonTable = this.getOrCreateCarbonTable(configuration);
        SingleTableProvider tableProvider = new SingleTableProvider(carbonTable);
        AbsoluteTableIdentifier identifier = carbonTable.getAbsoluteTableIdentifier();
        String projection = CarbonTableInputFormat.getColumnProjection(configuration);
        CarbonQueryPlan queryPlan = CarbonInputFormatUtil.createQueryPlan(carbonTable, projection);
        QueryModel queryModel = QueryModel.createModel((AbsoluteTableIdentifier)identifier, (CarbonQueryPlan)queryPlan, (CarbonTable)carbonTable, (DataTypeConverter)CarbonTableInputFormat.getDataTypeConverter(configuration));
        Expression filter = this.getFilterPredicates(configuration);
        boolean[] isFilterDimensions = new boolean[carbonTable.getDimensionOrdinalMax()];
        boolean[] isFilterMeasures = new boolean[carbonTable.getAllMeasures().size()];
        CarbonInputFormatUtil.processFilterExpression(filter, carbonTable, isFilterDimensions, isFilterMeasures);
        queryModel.setIsFilterDimensions(isFilterDimensions);
        queryModel.setIsFilterMeasures(isFilterMeasures);
        FilterResolverIntf filterIntf = CarbonInputFormatUtil.resolveFilter(filter, carbonTable.getAbsoluteTableIdentifier(), (TableProvider)tableProvider);
        queryModel.setFilterExpressionResolverTree(filterIntf);
        if (inputSplit instanceof CarbonMultiBlockSplit) {
            List<UpdateVO> invalidTimestampRangeList;
            CarbonMultiBlockSplit split = (CarbonMultiBlockSplit)inputSplit;
            List<String> invalidSegments = split.getAllSplits().get(0).getInvalidSegments();
            if (invalidSegments.size() > 0) {
                queryModel.setInvalidSegmentIds(invalidSegments);
            }
            if (null != (invalidTimestampRangeList = split.getAllSplits().get(0).getInvalidTimestampRange()) && invalidTimestampRangeList.size() > 0) {
                queryModel.setInvalidBlockForSegmentId(invalidTimestampRangeList);
            }
        }
        return queryModel;
    }

    public CarbonReadSupport<T> getReadSupportClass(Configuration configuration) {
        String readSupportClass = configuration.get(CARBON_READ_SUPPORT);
        CarbonReadSupport readSupport = null;
        if (readSupportClass != null) {
            try {
                Class<?> myClass = Class.forName(readSupportClass);
                Constructor<?> constructor = myClass.getConstructors()[0];
                Object object = constructor.newInstance(new Object[0]);
                if (object instanceof CarbonReadSupport) {
                    readSupport = (CarbonReadSupport)object;
                }
            }
            catch (ClassNotFoundException ex) {
                LOG.error((Object)("Class " + readSupportClass + "not found"), (Throwable)ex);
            }
            catch (Exception ex) {
                LOG.error((Object)("Error while creating " + readSupportClass), (Throwable)ex);
            }
        } else {
            readSupport = new DictionaryDecodeReadSupport();
        }
        return readSupport;
    }

    protected boolean isSplitable(JobContext context, Path filename) {
        try {
            FileSystem fileSystem = filename.getFileSystem(context.getConfiguration());
            if (fileSystem instanceof LocalFileSystem) {
                return false;
            }
        }
        catch (Exception e) {
            return true;
        }
        return true;
    }

    private String getUpdateExtension() {
        return "update";
    }

    public String[] getSegmentsToAccess(JobContext job) {
        String segmentString = job.getConfiguration().get(INPUT_SEGMENT_NUMBERS, "");
        if (segmentString.trim().isEmpty()) {
            return new String[0];
        }
        return segmentString.split(",");
    }

    public BlockMappingVO getBlockRowCount(Job job, AbsoluteTableIdentifier identifier, List<String> partitions) throws IOException {
        TableDataMap blockletMap = DataMapStoreManager.getInstance().getDataMap(identifier, "clustered.btree.blocklet", BlockletDataMapFactory.class.getName());
        SegmentUpdateStatusManager updateStatusManager = new SegmentUpdateStatusManager(identifier);
        SegmentStatusManager.ValidAndInvalidSegmentsInfo allSegments = new SegmentStatusManager(identifier).getValidAndInvalidSegments();
        HashMap<String, Long> blockRowCountMapping = new HashMap<String, Long>();
        HashMap<String, Long> segmentAndBlockCountMapping = new HashMap<String, Long>();
        List<String> filteredSegment = this.getFilteredSegment((JobContext)job, allSegments.getValidSegments());
        List blocklets = blockletMap.prune(filteredSegment, null, partitions);
        for (ExtendedBlocklet blocklet : blocklets) {
            String blockName = blocklet.getPath();
            blockName = CarbonTablePath.getCarbonDataFileName((String)blockName);
            blockName = blockName + CarbonTablePath.getCarbonDataExtension();
            long rowCount = blocklet.getDetailInfo().getRowCount();
            String key = CarbonUpdateUtil.getSegmentBlockNameKey((String)blocklet.getSegmentId(), (String)blockName);
            SegmentUpdateDetails details = updateStatusManager.getDetailsForABlock(key);
            if (null != details && CarbonUpdateUtil.isBlockInvalid((SegmentStatus)details.getSegmentStatus())) continue;
            Long blockCount = (Long)blockRowCountMapping.get(key);
            if (blockCount == null) {
                blockCount = 0L;
                Long count = (Long)segmentAndBlockCountMapping.get(blocklet.getSegmentId());
                if (count == null) {
                    count = 0L;
                }
                segmentAndBlockCountMapping.put(blocklet.getSegmentId(), count + 1L);
            }
            blockCount = blockCount + rowCount;
            blockRowCountMapping.put(key, blockCount);
        }
        return new BlockMappingVO(blockRowCountMapping, segmentAndBlockCountMapping);
    }

    public static void setDataTypeConverter(Configuration configuration, DataTypeConverter converter) throws IOException {
        if (null != converter) {
            configuration.set(CARBON_CONVERTER, ObjectSerializationUtil.convertObjectToString(converter));
        }
    }

    public static DataTypeConverter getDataTypeConverter(Configuration configuration) throws IOException {
        String converter = configuration.get(CARBON_CONVERTER);
        if (converter == null) {
            return new DataTypeConverterImpl();
        }
        return (DataTypeConverter)ObjectSerializationUtil.convertStringToObject(converter);
    }

    public static void setDatabaseName(Configuration configuration, String databaseName) {
        if (null != databaseName) {
            configuration.set(DATABASE_NAME, databaseName);
        }
    }

    public static String getDatabaseName(Configuration configuration) throws InvalidConfigurationException {
        String databseName = configuration.get(DATABASE_NAME);
        if (null == databseName) {
            throw new InvalidConfigurationException("Database name is not set.");
        }
        return databseName;
    }

    public static void setTableName(Configuration configuration, String tableName) {
        if (null != tableName) {
            configuration.set(TABLE_NAME, tableName);
        }
    }

    public static String getTableName(Configuration configuration) throws InvalidConfigurationException {
        String tableName = configuration.get(TABLE_NAME);
        if (tableName == null) {
            throw new InvalidConfigurationException("Table name is not set");
        }
        return tableName;
    }
}

