/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.hadoop.api;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.carbondata.common.logging.LogService;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.metadata.PartitionMapFileStore;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.mutate.CarbonUpdateUtil;
import org.apache.carbondata.core.statusmanager.LoadMetadataDetails;
import org.apache.carbondata.core.statusmanager.SegmentStatus;
import org.apache.carbondata.core.statusmanager.SegmentStatusManager;
import org.apache.carbondata.core.util.CarbonSessionInfo;
import org.apache.carbondata.core.util.ThreadLocalSessionInfo;
import org.apache.carbondata.core.util.path.CarbonTablePath;
import org.apache.carbondata.events.Event;
import org.apache.carbondata.events.OperationContext;
import org.apache.carbondata.events.OperationListenerBus;
import org.apache.carbondata.hadoop.api.CarbonTableOutputFormat;
import org.apache.carbondata.processing.loading.events.LoadEvents;
import org.apache.carbondata.processing.loading.model.CarbonLoadModel;
import org.apache.carbondata.processing.util.CarbonLoaderUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputCommitter;

public class CarbonOutputCommitter
extends FileOutputCommitter {
    private static final LogService LOGGER = LogServiceFactory.getLogService((String)CarbonOutputCommitter.class.getName());

    public CarbonOutputCommitter(Path outputPath, TaskAttemptContext context) throws IOException {
        super(outputPath, context);
    }

    public void setupJob(JobContext context) throws IOException {
        super.setupJob(context);
        boolean overwriteSet = CarbonTableOutputFormat.isOverwriteSet(context.getConfiguration());
        CarbonLoadModel loadModel = CarbonTableOutputFormat.getLoadModel(context.getConfiguration());
        CarbonLoaderUtil.readAndUpdateLoadProgressInTableMeta((CarbonLoadModel)loadModel, (boolean)overwriteSet);
        CarbonLoaderUtil.checkAndCreateCarbonDataLocation((String)loadModel.getSegmentId(), (CarbonTable)loadModel.getCarbonDataLoadSchema().getCarbonTable());
        CarbonTableOutputFormat.setLoadModel(context.getConfiguration(), loadModel);
    }

    public void setupTask(TaskAttemptContext context) throws IOException {
        super.setupTask(context);
    }

    public void commitJob(JobContext context) throws IOException {
        try {
            super.commitJob(context);
        }
        catch (IOException e) {
            LOGGER.warn(e.getMessage());
        }
        boolean overwriteSet = CarbonTableOutputFormat.isOverwriteSet(context.getConfiguration());
        CarbonLoadModel loadModel = CarbonTableOutputFormat.getLoadModel(context.getConfiguration());
        LoadMetadataDetails newMetaEntry = loadModel.getCurrentLoadMetadataDetail();
        String segmentPath = CarbonTablePath.getSegmentPath((String)loadModel.getTablePath(), (String)loadModel.getSegmentId());
        new PartitionMapFileStore().mergePartitionMapFiles(segmentPath, loadModel.getFactTimeStamp() + "");
        CarbonLoaderUtil.populateNewLoadMetaEntry((LoadMetadataDetails)newMetaEntry, (SegmentStatus)SegmentStatus.SUCCESS, (long)loadModel.getFactTimeStamp(), (boolean)true);
        CarbonTable carbonTable = loadModel.getCarbonDataLoadSchema().getCarbonTable();
        long segmentSize = CarbonLoaderUtil.addDataIndexSizeIntoMetaEntry((LoadMetadataDetails)newMetaEntry, (String)loadModel.getSegmentId(), (CarbonTable)carbonTable);
        if (segmentSize > 0L || overwriteSet) {
            Object operationContext = this.getOperationContext();
            if (operationContext != null) {
                LoadEvents.LoadTablePreStatusUpdateEvent event = new LoadEvents.LoadTablePreStatusUpdateEvent(carbonTable.getCarbonTableIdentifier(), loadModel);
                LoadEvents.LoadTablePostStatusUpdateEvent postStatusUpdateEvent = new LoadEvents.LoadTablePostStatusUpdateEvent(loadModel);
                try {
                    OperationListenerBus.getInstance().fireEvent((Event)event, (OperationContext)operationContext);
                    OperationListenerBus.getInstance().fireEvent((Event)postStatusUpdateEvent, (OperationContext)operationContext);
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }
            CarbonLoaderUtil.recordNewLoadMetadata((LoadMetadataDetails)newMetaEntry, (CarbonLoadModel)loadModel, (boolean)false, (boolean)overwriteSet);
            if (operationContext != null) {
                LoadEvents.LoadTableMergePartitionEvent loadTableMergePartitionEvent = new LoadEvents.LoadTableMergePartitionEvent(segmentPath);
                try {
                    OperationListenerBus.getInstance().fireEvent((Event)loadTableMergePartitionEvent, (OperationContext)operationContext);
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }
            String updateTime = context.getConfiguration().get("mapreduce.carbontable.update.timestamp", null);
            String segmentsToBeDeleted = context.getConfiguration().get("mapreduce.carbontable.segments.to.be.removed", "");
            List<String> segmentDeleteList = Arrays.asList(segmentsToBeDeleted.split(","));
            if (updateTime != null) {
                HashSet segmentSet = new HashSet(new SegmentStatusManager(carbonTable.getAbsoluteTableIdentifier()).getValidAndInvalidSegments().getValidSegments());
                CarbonUpdateUtil.updateTableMetadataStatus(segmentSet, (CarbonTable)carbonTable, (String)updateTime, (boolean)true, segmentDeleteList);
            }
        } else {
            CarbonLoaderUtil.updateTableStatusForFailure((CarbonLoadModel)loadModel);
        }
    }

    private Object getOperationContext() {
        CarbonSessionInfo carbonSessionInfo = ThreadLocalSessionInfo.getCarbonSessionInfo();
        if (carbonSessionInfo != null) {
            return carbonSessionInfo.getThreadParams().getExtraInfo("partition.operationcontext");
        }
        return null;
    }

    public void abortJob(JobContext context, JobStatus.State state) throws IOException {
        super.abortJob(context, state);
        CarbonLoadModel loadModel = CarbonTableOutputFormat.getLoadModel(context.getConfiguration());
        CarbonLoaderUtil.updateTableStatusForFailure((CarbonLoadModel)loadModel);
        LOGGER.error("Loading failed with job status : " + state);
    }
}

