/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.hadoop;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.carbondata.core.cache.Cache;

public class CacheAccessClient<K, V> {
    private Set<K> segmentSet = new HashSet<K>(16);
    private Cache<K, V> cache;

    public CacheAccessClient(Cache<K, V> cache) {
        this.cache = cache;
    }

    public V getIfPresent(K key) {
        Object value = this.cache.getIfPresent(key);
        if (value != null) {
            this.segmentSet.add(key);
        }
        return (V)value;
    }

    public V get(K key) throws IOException {
        Object value = this.cache.get(key);
        if (value != null) {
            this.segmentSet.add(key);
        }
        return (V)value;
    }

    public void close() {
        ArrayList<K> segmentArrayList = new ArrayList<K>(this.segmentSet.size());
        segmentArrayList.addAll(this.segmentSet);
        this.cache.clearAccessCount(segmentArrayList);
        this.cache = null;
    }

    public void invalidateAll(List<K> keys) {
        for (K key : keys) {
            this.cache.invalidate(key);
        }
    }

    public void clearAccessCount(List<K> segmentList) {
        this.cache.clearAccessCount(segmentList);
        this.segmentSet.removeAll(segmentList);
    }
}

