/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.hadoop.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ObjectSerializationUtil {
    private static final Log LOG = LogFactory.getLog(ObjectSerializationUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String convertObjectToString(Object obj) throws IOException {
        ByteArrayOutputStream baos = null;
        GZIPOutputStream gos = null;
        ObjectOutputStream oos = null;
        try {
            baos = new ByteArrayOutputStream();
            gos = new GZIPOutputStream(baos);
            oos = new ObjectOutputStream(gos);
            oos.writeObject(obj);
        }
        finally {
            try {
                if (oos != null) {
                    oos.close();
                }
                if (gos != null) {
                    gos.close();
                }
                if (baos != null) {
                    baos.close();
                }
            }
            catch (IOException e) {
                LOG.error((Object)e);
            }
        }
        return ObjectSerializationUtil.encodeToString(baos.toByteArray());
    }

    public static String encodeToString(byte[] bytes) throws UnsupportedEncodingException {
        return new String(Base64.encodeBase64((byte[])bytes), "UTF-8");
    }

    public static Object convertStringToObject(String objectString) throws IOException {
        if (objectString == null) {
            return null;
        }
        byte[] bytes = ObjectSerializationUtil.decodeStringToBytes(objectString);
        ByteArrayInputStream bais = null;
        GZIPInputStream gis = null;
        ObjectInputStream ois = null;
        try {
            bais = new ByteArrayInputStream(bytes);
            gis = new GZIPInputStream(bais);
            ois = new ObjectInputStream(gis);
            Object object = ois.readObject();
            return object;
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Could not read object", e);
        }
        finally {
            try {
                if (ois != null) {
                    ois.close();
                }
                if (gis != null) {
                    gis.close();
                }
                if (bais != null) {
                    bais.close();
                }
            }
            catch (IOException e) {
                LOG.error((Object)e);
            }
        }
    }

    public static byte[] decodeStringToBytes(String objectString) throws UnsupportedEncodingException {
        return Base64.decodeBase64((byte[])objectString.getBytes("UTF-8"));
    }
}

