/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.hadoop.api;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.carbondata.core.datamap.DataMapStoreManager;
import org.apache.carbondata.core.datamap.TableDataMap;
import org.apache.carbondata.core.indexstore.Blocklet;
import org.apache.carbondata.core.indexstore.blockletindex.BlockletDataMapFactory;
import org.apache.carbondata.core.keygenerator.KeyGenException;
import org.apache.carbondata.core.metadata.AbsoluteTableIdentifier;
import org.apache.carbondata.core.metadata.ColumnarFormatVersion;
import org.apache.carbondata.core.metadata.schema.PartitionInfo;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.metadata.schema.table.TableInfo;
import org.apache.carbondata.core.mutate.CarbonUpdateUtil;
import org.apache.carbondata.core.mutate.SegmentUpdateDetails;
import org.apache.carbondata.core.mutate.UpdateVO;
import org.apache.carbondata.core.mutate.data.BlockMappingVO;
import org.apache.carbondata.core.scan.expression.Expression;
import org.apache.carbondata.core.scan.filter.FilterExpressionProcessor;
import org.apache.carbondata.core.scan.filter.SingleTableProvider;
import org.apache.carbondata.core.scan.filter.TableProvider;
import org.apache.carbondata.core.scan.filter.resolver.FilterResolverIntf;
import org.apache.carbondata.core.scan.model.CarbonQueryPlan;
import org.apache.carbondata.core.scan.model.QueryModel;
import org.apache.carbondata.core.stats.QueryStatistic;
import org.apache.carbondata.core.stats.QueryStatisticsRecorder;
import org.apache.carbondata.core.statusmanager.SegmentStatusManager;
import org.apache.carbondata.core.statusmanager.SegmentUpdateStatusManager;
import org.apache.carbondata.core.util.CarbonTimeStatisticsFactory;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.core.util.DataTypeConverter;
import org.apache.carbondata.core.util.DataTypeConverterImpl;
import org.apache.carbondata.core.util.path.CarbonStorePath;
import org.apache.carbondata.core.util.path.CarbonTablePath;
import org.apache.carbondata.hadoop.CarbonInputSplit;
import org.apache.carbondata.hadoop.CarbonMultiBlockSplit;
import org.apache.carbondata.hadoop.CarbonProjection;
import org.apache.carbondata.hadoop.CarbonRecordReader;
import org.apache.carbondata.hadoop.api.DataMapJob;
import org.apache.carbondata.hadoop.api.DistributableDataMapFormat;
import org.apache.carbondata.hadoop.readsupport.CarbonReadSupport;
import org.apache.carbondata.hadoop.readsupport.impl.DictionaryDecodeReadSupport;
import org.apache.carbondata.hadoop.util.CarbonInputFormatUtil;
import org.apache.carbondata.hadoop.util.ObjectSerializationUtil;
import org.apache.carbondata.hadoop.util.SchemaReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.InvalidPathException;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.hadoop.mapreduce.security.TokenCache;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.util.StringUtils;

public class CarbonTableInputFormat<T>
extends FileInputFormat<Void, T> {
    public static final String INPUT_SEGMENT_NUMBERS = "mapreduce.input.carboninputformat.segmentnumbers";
    public static final String INPUT_FILES = "mapreduce.input.carboninputformat.files";
    public static final String ALTER_PARTITION_ID = "mapreduce.input.carboninputformat.partitionid";
    private static final Log LOG = LogFactory.getLog(CarbonTableInputFormat.class);
    private static final String FILTER_PREDICATE = "mapreduce.input.carboninputformat.filter.predicate";
    private static final String COLUMN_PROJECTION = "mapreduce.input.carboninputformat.projection";
    private static final String TABLE_INFO = "mapreduce.input.carboninputformat.tableinfo";
    private static final String CARBON_READ_SUPPORT = "mapreduce.input.carboninputformat.readsupport";
    private static final String CARBON_CONVERTER = "mapreduce.input.carboninputformat.converter";
    private static final String DATA_MAP_DSTR = "mapreduce.input.carboninputformat.datamapdstr";
    private CarbonTable carbonTable;

    public static void setTableInfo(Configuration configuration, TableInfo tableInfo) throws IOException {
        if (null != tableInfo) {
            configuration.set(TABLE_INFO, ObjectSerializationUtil.encodeToString(tableInfo.serialize()));
        }
    }

    private TableInfo getTableInfo(Configuration configuration) throws IOException {
        String tableInfoStr = configuration.get(TABLE_INFO);
        if (tableInfoStr == null) {
            return null;
        }
        TableInfo output = new TableInfo();
        output.readFields((DataInput)new DataInputStream(new ByteArrayInputStream(ObjectSerializationUtil.decodeStringToBytes(tableInfoStr))));
        return output;
    }

    private CarbonTable getOrCreateCarbonTable(Configuration configuration) throws IOException {
        if (this.carbonTable == null) {
            TableInfo tableInfo = this.getTableInfo(configuration);
            CarbonTable carbonTable = tableInfo != null ? CarbonTable.buildFromTableInfo((TableInfo)tableInfo) : SchemaReader.readCarbonTableFromStore(this.getAbsoluteTableIdentifier(configuration));
            this.carbonTable = carbonTable;
            return carbonTable;
        }
        return this.carbonTable;
    }

    public static void setTablePath(Configuration configuration, String tablePath) throws IOException {
        configuration.set("mapreduce.input.fileinputformat.inputdir", tablePath);
    }

    public static void setPartitionIdList(Configuration configuration, List<String> partitionIds) {
        configuration.set(ALTER_PARTITION_ID, partitionIds.toString());
    }

    public static void setDataMapJob(Configuration configuration, DataMapJob dataMapJob) throws IOException {
        if (dataMapJob != null) {
            String toString = ObjectSerializationUtil.convertObjectToString(dataMapJob);
            configuration.set(DATA_MAP_DSTR, toString);
        }
    }

    private static DataMapJob getDataMapJob(Configuration configuration) throws IOException {
        String jobString = configuration.get(DATA_MAP_DSTR);
        if (jobString != null) {
            DataMapJob dataMapJob = (DataMapJob)ObjectSerializationUtil.convertStringToObject(jobString);
            return dataMapJob;
        }
        return null;
    }

    public static void setFilterPredicates(Configuration configuration, Expression filterExpression) {
        if (filterExpression == null) {
            return;
        }
        try {
            String filterString = ObjectSerializationUtil.convertObjectToString(filterExpression);
            configuration.set(FILTER_PREDICATE, filterString);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while setting filter expression to Job", e);
        }
    }

    public static void setColumnProjection(Configuration configuration, CarbonProjection projection) {
        if (projection == null || projection.isEmpty()) {
            return;
        }
        String[] allColumns = projection.getAllColumns();
        StringBuilder builder = new StringBuilder();
        for (String column : allColumns) {
            builder.append(column).append(",");
        }
        String columnString = builder.toString();
        columnString = columnString.substring(0, columnString.length() - 1);
        configuration.set(COLUMN_PROJECTION, columnString);
    }

    public static String getColumnProjection(Configuration configuration) {
        return configuration.get(COLUMN_PROJECTION);
    }

    public static void setCarbonReadSupport(Configuration configuration, Class<? extends CarbonReadSupport> readSupportClass) {
        if (readSupportClass != null) {
            configuration.set(CARBON_READ_SUPPORT, readSupportClass.getName());
        }
    }

    private static CarbonTablePath getTablePath(AbsoluteTableIdentifier absIdentifier) {
        return CarbonStorePath.getCarbonTablePath((AbsoluteTableIdentifier)absIdentifier);
    }

    public static void setSegmentsToAccess(Configuration configuration, List<String> validSegments) {
        configuration.set(INPUT_SEGMENT_NUMBERS, CarbonUtil.getSegmentString(validSegments));
    }

    public static void setFilesToAccess(Configuration configuration, List<String> validFiles) {
        configuration.set(INPUT_FILES, CarbonUtil.getSegmentString(validFiles));
    }

    private AbsoluteTableIdentifier getAbsoluteTableIdentifier(Configuration configuration) throws IOException {
        String dirs = configuration.get("mapreduce.input.fileinputformat.inputdir", "");
        String[] inputPaths = StringUtils.split((String)dirs);
        if (inputPaths.length == 0) {
            throw new InvalidPathException("No input paths specified in job");
        }
        return AbsoluteTableIdentifier.fromTablePath((String)inputPaths[0]);
    }

    public List<InputSplit> getSplits(JobContext job) throws IOException {
        AbsoluteTableIdentifier identifier = this.getAbsoluteTableIdentifier(job.getConfiguration());
        TableDataMap blockletMap = DataMapStoreManager.getInstance().getDataMap(identifier, "clustered.btree.blocklet", BlockletDataMapFactory.class.getName());
        ArrayList<String> invalidSegments = new ArrayList<String>();
        ArrayList<UpdateVO> invalidTimestampsList = new ArrayList<UpdateVO>();
        List validSegments = Arrays.asList(this.getSegmentsToAccess(job));
        if (validSegments.size() == 0) {
            SegmentStatusManager segmentStatusManager = new SegmentStatusManager(identifier);
            SegmentStatusManager.ValidAndInvalidSegmentsInfo segments = segmentStatusManager.getValidAndInvalidSegments();
            SegmentUpdateStatusManager updateStatusManager = new SegmentUpdateStatusManager(identifier);
            validSegments = segments.getValidSegments();
            if (validSegments.size() == 0) {
                return new ArrayList<InputSplit>(0);
            }
            invalidSegments.addAll(segments.getInvalidSegments());
            for (String invalidSegmentId : invalidSegments) {
                invalidTimestampsList.add(updateStatusManager.getInvalidTimestampRange(invalidSegmentId));
            }
            if (invalidSegments.size() > 0) {
                blockletMap.clear(invalidSegments);
            }
        }
        Expression filter = this.getFilterPredicates(job.getConfiguration());
        CarbonTable carbonTable = this.getOrCreateCarbonTable(job.getConfiguration());
        SingleTableProvider tableProvider = new SingleTableProvider(carbonTable);
        if (null == carbonTable) {
            throw new IOException("Missing/Corrupt schema file for table.");
        }
        PartitionInfo partitionInfo = carbonTable.getPartitionInfo(carbonTable.getFactTableName());
        CarbonInputFormatUtil.processFilterExpression(filter, carbonTable);
        BitSet matchedPartitions = null;
        if (partitionInfo != null && (matchedPartitions = this.setMatchedPartitions(null, filter, partitionInfo, null)) != null) {
            if (matchedPartitions.cardinality() == 0) {
                return new ArrayList<InputSplit>();
            }
            if (matchedPartitions.cardinality() == partitionInfo.getNumPartitions()) {
                matchedPartitions = null;
            }
        }
        FilterResolverIntf filterInterface = CarbonInputFormatUtil.resolveFilter(filter, carbonTable.getAbsoluteTableIdentifier(), (TableProvider)tableProvider);
        List<InputSplit> splits = this.getSplits(job, filterInterface, validSegments, matchedPartitions, partitionInfo, null);
        if (invalidSegments.size() > 0) {
            for (InputSplit split : splits) {
                ((CarbonInputSplit)split).setInvalidSegments(invalidSegments);
                ((CarbonInputSplit)split).setInvalidTimestampRange(invalidTimestampsList);
            }
        }
        return splits;
    }

    public List<InputSplit> getSplitsOfOneSegment(JobContext job, String targetSegment, List<Integer> oldPartitionIdList, PartitionInfo partitionInfo) throws IOException {
        AbsoluteTableIdentifier identifier = this.getAbsoluteTableIdentifier(job.getConfiguration());
        ArrayList<String> invalidSegments = new ArrayList<String>();
        ArrayList<UpdateVO> invalidTimestampsList = new ArrayList<UpdateVO>();
        ArrayList<String> segmentList = new ArrayList<String>();
        segmentList.add(targetSegment);
        CarbonTableInputFormat.setSegmentsToAccess(job.getConfiguration(), segmentList);
        try {
            Expression filter = this.getFilterPredicates(job.getConfiguration());
            CarbonTable carbonTable = this.getOrCreateCarbonTable(job.getConfiguration());
            if (null == carbonTable) {
                throw new IOException("Missing/Corrupt schema file for table.");
            }
            CarbonInputFormatUtil.processFilterExpression(filter, carbonTable);
            SingleTableProvider tableProvider = new SingleTableProvider(carbonTable);
            String partitionIds = job.getConfiguration().get(ALTER_PARTITION_ID);
            BitSet matchedPartitions = null;
            if (partitionInfo != null && (matchedPartitions = this.setMatchedPartitions(partitionIds, filter, partitionInfo, oldPartitionIdList)) != null) {
                if (matchedPartitions.cardinality() == 0) {
                    return new ArrayList<InputSplit>();
                }
                if (matchedPartitions.cardinality() == partitionInfo.getNumPartitions()) {
                    matchedPartitions = null;
                }
            }
            FilterResolverIntf filterInterface = CarbonInputFormatUtil.resolveFilter(filter, identifier, (TableProvider)tableProvider);
            List<InputSplit> splits = this.getSplits(job, filterInterface, segmentList, matchedPartitions, partitionInfo, oldPartitionIdList);
            if (invalidSegments.size() > 0) {
                for (InputSplit split : splits) {
                    ((CarbonInputSplit)split).setInvalidSegments(invalidSegments);
                    ((CarbonInputSplit)split).setInvalidTimestampRange(invalidTimestampsList);
                }
            }
            return splits;
        }
        catch (IOException e) {
            throw new RuntimeException("Can't get splits of the target segment ", e);
        }
    }

    private BitSet setMatchedPartitions(String partitionIds, Expression filter, PartitionInfo partitionInfo, List<Integer> oldPartitionIdList) {
        BitSet matchedPartitions = null;
        if (null != partitionIds) {
            String[] partList = partitionIds.replace("[", "").replace("]", "").split(",");
            matchedPartitions = new BitSet(Integer.parseInt(partList[0].trim()));
            for (String partitionId : partList) {
                Integer index = oldPartitionIdList.indexOf(Integer.parseInt(partitionId.trim()));
                matchedPartitions.set(index);
            }
        } else if (null != filter) {
            matchedPartitions = new FilterExpressionProcessor().getFilteredPartitions(filter, partitionInfo);
        }
        return matchedPartitions;
    }

    private List<InputSplit> getSplits(JobContext job, FilterResolverIntf filterResolver, List<String> validSegments, BitSet matchedPartitions, PartitionInfo partitionInfo, List<Integer> oldPartitionIdList) throws IOException {
        LinkedList<InputSplit> result = new LinkedList<InputSplit>();
        UpdateVO invalidBlockVOForSegmentId = null;
        Boolean isIUDTable = false;
        AbsoluteTableIdentifier absoluteTableIdentifier = this.getOrCreateCarbonTable(job.getConfiguration()).getAbsoluteTableIdentifier();
        SegmentUpdateStatusManager updateStatusManager = new SegmentUpdateStatusManager(absoluteTableIdentifier);
        isIUDTable = updateStatusManager.getUpdateStatusDetails().length != 0;
        List<CarbonInputSplit> dataBlocksOfSegment = this.getDataBlocksOfSegment(job, absoluteTableIdentifier, filterResolver, matchedPartitions, validSegments, partitionInfo, oldPartitionIdList);
        for (CarbonInputSplit inputSplit : dataBlocksOfSegment) {
            if (isIUDTable.booleanValue()) {
                invalidBlockVOForSegmentId = updateStatusManager.getInvalidTimestampRange(inputSplit.getSegmentId());
            }
            String[] deleteDeltaFilePath = null;
            if (isIUDTable.booleanValue()) {
                if (CarbonUtil.isInvalidTableBlock((String)inputSplit.getSegmentId(), (String)inputSplit.getPath().toString(), (UpdateVO)invalidBlockVOForSegmentId, (SegmentUpdateStatusManager)updateStatusManager)) continue;
                try {
                    deleteDeltaFilePath = updateStatusManager.getDeleteDeltaFilePath(inputSplit.getPath().toString());
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }
            inputSplit.setDeleteDeltaFiles(deleteDeltaFilePath);
            result.add((InputSplit)inputSplit);
        }
        return result;
    }

    protected Expression getFilterPredicates(Configuration configuration) {
        try {
            String filterExprString = configuration.get(FILTER_PREDICATE);
            if (filterExprString == null) {
                return null;
            }
            Object filter = ObjectSerializationUtil.convertStringToObject(filterExprString);
            return (Expression)filter;
        }
        catch (IOException e) {
            throw new RuntimeException("Error while reading filter expression", e);
        }
    }

    private List<CarbonInputSplit> getDataBlocksOfSegment(JobContext job, AbsoluteTableIdentifier absoluteTableIdentifier, FilterResolverIntf resolver, BitSet matchedPartitions, List<String> segmentIds, PartitionInfo partitionInfo, List<Integer> oldPartitionIdList) throws IOException {
        List<Blocklet> prunedBlocklets;
        QueryStatisticsRecorder recorder = CarbonTimeStatisticsFactory.createDriverRecorder();
        QueryStatistic statistic = new QueryStatistic();
        TokenCache.obtainTokensForNamenodes((Credentials)job.getCredentials(), (Path[])new Path[]{new Path(absoluteTableIdentifier.getTablePath())}, (Configuration)job.getConfiguration());
        TableDataMap blockletMap = DataMapStoreManager.getInstance().getDataMap(absoluteTableIdentifier, "clustered.btree.blocklet", BlockletDataMapFactory.class.getName());
        DataMapJob dataMapJob = CarbonTableInputFormat.getDataMapJob(job.getConfiguration());
        if (dataMapJob != null) {
            DistributableDataMapFormat datamapDstr = new DistributableDataMapFormat(absoluteTableIdentifier, "clustered.btree.blocklet", segmentIds, BlockletDataMapFactory.class.getName());
            prunedBlocklets = dataMapJob.execute(datamapDstr, resolver);
        } else {
            prunedBlocklets = blockletMap.prune(segmentIds, resolver);
        }
        ArrayList<CarbonInputSplit> resultFilterredBlocks = new ArrayList<CarbonInputSplit>();
        int partitionIndex = 0;
        List partitionIdList = new ArrayList();
        if (partitionInfo != null) {
            partitionIdList = partitionInfo.getPartitionIds();
        }
        for (Blocklet blocklet : prunedBlocklets) {
            int partitionId = CarbonTablePath.DataFileUtil.getTaskIdFromTaskNo((String)CarbonTablePath.DataFileUtil.getTaskNo((String)blocklet.getPath().toString()));
            if (partitionInfo != null) {
                partitionIndex = oldPartitionIdList != null ? oldPartitionIdList.indexOf(partitionId) : partitionIdList.indexOf(partitionId);
            }
            if (partitionIndex == -1 || matchedPartitions != null && !matchedPartitions.get(partitionIndex)) continue;
            resultFilterredBlocks.add(this.convertToCarbonInputSplit(blocklet));
        }
        statistic.addStatistics("Time taken to load the Block(s) In Driver Side with Block count ", System.currentTimeMillis());
        recorder.recordStatisticsForDriver(statistic, job.getConfiguration().get("query.id"));
        return resultFilterredBlocks;
    }

    private CarbonInputSplit convertToCarbonInputSplit(Blocklet blocklet) throws IOException {
        blocklet.updateLocations();
        CarbonInputSplit split = CarbonInputSplit.from(blocklet.getSegmentId(), new FileSplit(new Path(blocklet.getPath()), 0L, blocklet.getLength(), blocklet.getLocations()), ColumnarFormatVersion.valueOf((short)blocklet.getDetailInfo().getVersionNumber()));
        split.setDetailInfo(blocklet.getDetailInfo());
        return split;
    }

    public RecordReader<Void, T> createRecordReader(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        Configuration configuration = taskAttemptContext.getConfiguration();
        QueryModel queryModel = this.getQueryModel(inputSplit, taskAttemptContext);
        CarbonReadSupport<T> readSupport = this.getReadSupportClass(configuration);
        return new CarbonRecordReader<T>(queryModel, readSupport);
    }

    public QueryModel getQueryModel(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException {
        Configuration configuration = taskAttemptContext.getConfiguration();
        CarbonTable carbonTable = this.getOrCreateCarbonTable(configuration);
        SingleTableProvider tableProvider = new SingleTableProvider(carbonTable);
        AbsoluteTableIdentifier identifier = carbonTable.getAbsoluteTableIdentifier();
        String projection = CarbonTableInputFormat.getColumnProjection(configuration);
        CarbonQueryPlan queryPlan = CarbonInputFormatUtil.createQueryPlan(carbonTable, projection);
        QueryModel queryModel = QueryModel.createModel((AbsoluteTableIdentifier)identifier, (CarbonQueryPlan)queryPlan, (CarbonTable)carbonTable, (DataTypeConverter)CarbonTableInputFormat.getDataTypeConverter(configuration));
        Expression filter = this.getFilterPredicates(configuration);
        CarbonInputFormatUtil.processFilterExpression(filter, carbonTable);
        FilterResolverIntf filterIntf = CarbonInputFormatUtil.resolveFilter(filter, carbonTable.getAbsoluteTableIdentifier(), (TableProvider)tableProvider);
        queryModel.setFilterExpressionResolverTree(filterIntf);
        if (inputSplit instanceof CarbonMultiBlockSplit) {
            List<UpdateVO> invalidTimestampRangeList;
            CarbonMultiBlockSplit split = (CarbonMultiBlockSplit)inputSplit;
            List<String> invalidSegments = split.getAllSplits().get(0).getInvalidSegments();
            if (invalidSegments.size() > 0) {
                queryModel.setInvalidSegmentIds(invalidSegments);
            }
            if (null != (invalidTimestampRangeList = split.getAllSplits().get(0).getInvalidTimestampRange()) && invalidTimestampRangeList.size() > 0) {
                queryModel.setInvalidBlockForSegmentId(invalidTimestampRangeList);
            }
        }
        return queryModel;
    }

    public CarbonReadSupport<T> getReadSupportClass(Configuration configuration) {
        String readSupportClass = configuration.get(CARBON_READ_SUPPORT);
        CarbonReadSupport readSupport = null;
        if (readSupportClass != null) {
            try {
                Class<?> myClass = Class.forName(readSupportClass);
                Constructor<?> constructor = myClass.getConstructors()[0];
                Object object = constructor.newInstance(new Object[0]);
                if (object instanceof CarbonReadSupport) {
                    readSupport = (CarbonReadSupport)object;
                }
            }
            catch (ClassNotFoundException ex) {
                LOG.error((Object)("Class " + readSupportClass + "not found"), (Throwable)ex);
            }
            catch (Exception ex) {
                LOG.error((Object)("Error while creating " + readSupportClass), (Throwable)ex);
            }
        } else {
            readSupport = new DictionaryDecodeReadSupport();
        }
        return readSupport;
    }

    protected boolean isSplitable(JobContext context, Path filename) {
        try {
            FileSystem fileSystem = filename.getFileSystem(context.getConfiguration());
            if (fileSystem instanceof LocalFileSystem) {
                return false;
            }
        }
        catch (Exception e) {
            return true;
        }
        return true;
    }

    private String getUpdateExtension() {
        return "update";
    }

    private String[] getSegmentsToAccess(JobContext job) {
        String segmentString = job.getConfiguration().get(INPUT_SEGMENT_NUMBERS, "");
        if (segmentString.trim().isEmpty()) {
            return new String[0];
        }
        return segmentString.split(",");
    }

    public BlockMappingVO getBlockRowCount(JobContext job, AbsoluteTableIdentifier identifier) throws IOException, KeyGenException {
        TableDataMap blockletMap = DataMapStoreManager.getInstance().getDataMap(identifier, "clustered.btree.blocklet", BlockletDataMapFactory.class.getName());
        SegmentUpdateStatusManager updateStatusManager = new SegmentUpdateStatusManager(identifier);
        SegmentStatusManager.ValidAndInvalidSegmentsInfo validAndInvalidSegments = new SegmentStatusManager(identifier).getValidAndInvalidSegments();
        HashMap<String, Long> blockRowCountMapping = new HashMap<String, Long>(16);
        HashMap<String, Long> segmentAndBlockCountMapping = new HashMap<String, Long>(16);
        List blocklets = blockletMap.prune(validAndInvalidSegments.getValidSegments(), null);
        for (Blocklet blocklet : blocklets) {
            String blockName = blocklet.getPath().toString();
            blockName = CarbonTablePath.getCarbonDataFileName((String)blockName);
            blockName = blockName + CarbonTablePath.getCarbonDataExtension();
            long rowCount = blocklet.getDetailInfo().getRowCount();
            String key = CarbonUpdateUtil.getSegmentBlockNameKey((String)blocklet.getSegmentId(), (String)blockName);
            SegmentUpdateDetails details = updateStatusManager.getDetailsForABlock(key);
            if (null != details && CarbonUpdateUtil.isBlockInvalid((String)details.getStatus())) continue;
            Long blockCount = (Long)blockRowCountMapping.get(key);
            if (blockCount == null) {
                blockCount = 0L;
                Long count = (Long)segmentAndBlockCountMapping.get(blocklet.getSegmentId());
                if (count == null) {
                    count = 0L;
                }
                segmentAndBlockCountMapping.put(blocklet.getSegmentId(), count + 1L);
            }
            blockCount = blockCount + rowCount;
            blockRowCountMapping.put(key, blockCount);
        }
        return new BlockMappingVO(blockRowCountMapping, segmentAndBlockCountMapping);
    }

    public static void setDataTypeConverter(Configuration configuration, DataTypeConverter converter) throws IOException {
        if (null != converter) {
            configuration.set(CARBON_CONVERTER, ObjectSerializationUtil.convertObjectToString(converter));
        }
    }

    public static DataTypeConverter getDataTypeConverter(Configuration configuration) throws IOException {
        String converter = configuration.get(CARBON_CONVERTER);
        if (converter == null) {
            return new DataTypeConverterImpl();
        }
        return (DataTypeConverter)ObjectSerializationUtil.convertStringToObject(converter);
    }
}

