/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.hadoop.util;

import java.io.IOException;
import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.carbondata.core.metadata.AbsoluteTableIdentifier;
import org.apache.carbondata.core.metadata.CarbonMetadata;
import org.apache.carbondata.core.metadata.converter.ThriftWrapperSchemaConverterImpl;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.reader.ThriftReader;
import org.apache.carbondata.core.util.path.CarbonStorePath;
import org.apache.carbondata.core.util.path.CarbonTablePath;
import org.apache.carbondata.format.TableInfo;
import org.apache.thrift.TBase;

public class SchemaReader {
    public static CarbonTable readCarbonTableFromStore(AbsoluteTableIdentifier identifier) throws IOException {
        CarbonTablePath carbonTablePath = CarbonStorePath.getCarbonTablePath((AbsoluteTableIdentifier)identifier);
        String schemaFilePath = carbonTablePath.getSchemaFilePath();
        if (FileFactory.isFileExist((String)schemaFilePath, (FileFactory.FileType)FileFactory.FileType.LOCAL) || FileFactory.isFileExist((String)schemaFilePath, (FileFactory.FileType)FileFactory.FileType.HDFS) || FileFactory.isFileExist((String)schemaFilePath, (FileFactory.FileType)FileFactory.FileType.VIEWFS)) {
            String tableName = identifier.getCarbonTableIdentifier().getTableName();
            ThriftReader.TBaseCreator createTBase = new ThriftReader.TBaseCreator(){

                public TBase create() {
                    return new TableInfo();
                }
            };
            ThriftReader thriftReader = new ThriftReader(carbonTablePath.getSchemaFilePath(), createTBase);
            thriftReader.open();
            TableInfo tableInfo = (TableInfo)thriftReader.read();
            thriftReader.close();
            ThriftWrapperSchemaConverterImpl schemaConverter = new ThriftWrapperSchemaConverterImpl();
            org.apache.carbondata.core.metadata.schema.table.TableInfo wrapperTableInfo = schemaConverter.fromExternalToWrapperTableInfo(tableInfo, identifier.getCarbonTableIdentifier().getDatabaseName(), tableName, identifier.getStorePath());
            wrapperTableInfo.setMetaDataFilepath(CarbonTablePath.getFolderContainingFile((String)schemaFilePath));
            CarbonMetadata.getInstance().loadTableMetadata(wrapperTableInfo);
            return CarbonMetadata.getInstance().getCarbonTable(identifier.getCarbonTableIdentifier().getTableUniqueName());
        }
        throw new IOException("File does not exist: " + schemaFilePath);
    }
}

