/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.hadoop.util;

import java.io.IOException;
import java.util.List;
import org.apache.carbondata.core.metadata.AbsoluteTableIdentifier;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonDimension;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonMeasure;
import org.apache.carbondata.core.scan.expression.Expression;
import org.apache.carbondata.core.scan.filter.FilterExpressionProcessor;
import org.apache.carbondata.core.scan.filter.intf.FilterOptimizer;
import org.apache.carbondata.core.scan.filter.intf.FilterOptimizerBasic;
import org.apache.carbondata.core.scan.filter.optimizer.RangeFilterOptmizer;
import org.apache.carbondata.core.scan.filter.resolver.FilterResolverIntf;
import org.apache.carbondata.core.scan.model.CarbonQueryPlan;
import org.apache.carbondata.core.scan.model.QueryDimension;
import org.apache.carbondata.core.scan.model.QueryMeasure;
import org.apache.carbondata.core.scan.model.QueryModel;
import org.apache.carbondata.hadoop.CarbonInputFormat;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;

public class CarbonInputFormatUtil {
    public static CarbonQueryPlan createQueryPlan(CarbonTable carbonTable, String columnString) {
        String[] columns = null;
        if (columnString != null) {
            columns = columnString.split(",");
        }
        String factTableName = carbonTable.getFactTableName();
        CarbonQueryPlan plan = new CarbonQueryPlan(carbonTable.getDatabaseName(), factTableName);
        int i = 0;
        if (columns != null) {
            for (String column : columns) {
                CarbonDimension dimensionByName = carbonTable.getDimensionByName(factTableName, column);
                if (dimensionByName != null) {
                    CarbonInputFormatUtil.addQueryDimension(plan, i, dimensionByName);
                    ++i;
                    continue;
                }
                CarbonMeasure measure = carbonTable.getMeasureByName(factTableName, column);
                if (measure == null) {
                    throw new RuntimeException(column + " column not found in the table " + factTableName);
                }
                CarbonInputFormatUtil.addQueryMeasure(plan, i, measure);
                ++i;
            }
        }
        plan.setQueryId(System.nanoTime() + "");
        return plan;
    }

    public static <V> CarbonInputFormat<V> createCarbonInputFormat(AbsoluteTableIdentifier identifier, Job job) throws IOException {
        CarbonInputFormat carbonInputFormat = new CarbonInputFormat();
        FileInputFormat.addInputPath((Job)job, (Path)new Path(identifier.getTablePath()));
        return carbonInputFormat;
    }

    private static void addQueryMeasure(CarbonQueryPlan plan, int order, CarbonMeasure measure) {
        QueryMeasure queryMeasure = new QueryMeasure(measure.getColName());
        queryMeasure.setQueryOrder(order);
        queryMeasure.setMeasure(measure);
        plan.addMeasure(queryMeasure);
    }

    private static void addQueryDimension(CarbonQueryPlan plan, int order, CarbonDimension dimension) {
        QueryDimension queryDimension = new QueryDimension(dimension.getColName());
        queryDimension.setQueryOrder(order);
        queryDimension.setDimension(dimension);
        plan.addDimension(queryDimension);
    }

    public static void processFilterExpression(Expression filterExpression, CarbonTable carbonTable) {
        List dimensions = carbonTable.getDimensionByTableName(carbonTable.getFactTableName());
        List measures = carbonTable.getMeasureByTableName(carbonTable.getFactTableName());
        QueryModel.processFilterExpression((Expression)filterExpression, (List)dimensions, (List)measures);
        if (null != filterExpression) {
            RangeFilterOptmizer rangeFilterOptimizer = new RangeFilterOptmizer((FilterOptimizer)new FilterOptimizerBasic(), filterExpression);
            rangeFilterOptimizer.optimizeFilter();
        }
    }

    public static FilterResolverIntf resolveFilter(Expression filterExpression, AbsoluteTableIdentifier absoluteTableIdentifier) {
        try {
            FilterExpressionProcessor filterExpressionProcessor = new FilterExpressionProcessor();
            return filterExpressionProcessor.getFilterResolver(filterExpression, absoluteTableIdentifier);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while resolving filter expression", e);
        }
    }
}

