/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.hadoop.internal.index.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.carbondata.core.datastore.DataRefNode;
import org.apache.carbondata.core.datastore.IndexKey;
import org.apache.carbondata.core.datastore.SegmentTaskIndexStore;
import org.apache.carbondata.core.datastore.TableSegmentUniqueIdentifier;
import org.apache.carbondata.core.datastore.block.AbstractIndex;
import org.apache.carbondata.core.datastore.block.BlockletInfos;
import org.apache.carbondata.core.datastore.block.SegmentProperties;
import org.apache.carbondata.core.datastore.block.SegmentTaskIndexWrapper;
import org.apache.carbondata.core.datastore.block.TableBlockInfo;
import org.apache.carbondata.core.datastore.impl.btree.BTreeDataRefNodeFinder;
import org.apache.carbondata.core.datastore.impl.btree.BlockBTreeLeafNode;
import org.apache.carbondata.core.keygenerator.KeyGenException;
import org.apache.carbondata.core.metadata.AbsoluteTableIdentifier;
import org.apache.carbondata.core.scan.filter.FilterExpressionProcessor;
import org.apache.carbondata.core.scan.filter.FilterUtil;
import org.apache.carbondata.core.scan.filter.resolver.FilterResolverIntf;
import org.apache.carbondata.core.stats.QueryStatistic;
import org.apache.carbondata.core.stats.QueryStatisticsRecorder;
import org.apache.carbondata.core.util.CarbonTimeStatisticsFactory;
import org.apache.carbondata.hadoop.CacheClient;
import org.apache.carbondata.hadoop.CarbonInputSplit;
import org.apache.carbondata.hadoop.internal.index.Block;
import org.apache.carbondata.hadoop.internal.index.Index;
import org.apache.carbondata.hadoop.internal.segment.Segment;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;

class InMemoryBTreeIndex
implements Index {
    private static final Log LOG = LogFactory.getLog(InMemoryBTreeIndex.class);
    private Segment segment;

    InMemoryBTreeIndex(Segment segment) {
        this.segment = segment;
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public List<Block> filter(JobContext job, FilterResolverIntf filter) throws IOException {
        LinkedList<Block> result = new LinkedList<Block>();
        FilterExpressionProcessor filterExpressionProcessor = new FilterExpressionProcessor();
        AbsoluteTableIdentifier identifier = null;
        List<DataRefNode> dataRefNodes = this.getDataBlocksOfSegment(job, filterExpressionProcessor, identifier, filter);
        for (DataRefNode dataRefNode : dataRefNodes) {
            BlockBTreeLeafNode leafNode = (BlockBTreeLeafNode)dataRefNode;
            TableBlockInfo tableBlockInfo = leafNode.getTableBlockInfo();
            result.add(new CarbonInputSplit(this.segment.getId(), new Path(tableBlockInfo.getFilePath()), tableBlockInfo.getBlockOffset(), tableBlockInfo.getBlockLength(), tableBlockInfo.getLocations(), tableBlockInfo.getBlockletInfos().getNoOfBlockLets(), tableBlockInfo.getVersion(), null));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<SegmentTaskIndexStore.TaskBucketHolder, AbstractIndex> getSegmentAbstractIndexs(JobContext job, AbsoluteTableIdentifier identifier) throws IOException {
        Map segmentIndexMap = null;
        CacheClient cacheClient = new CacheClient(identifier.getStorePath());
        TableSegmentUniqueIdentifier segmentUniqueIdentifier = new TableSegmentUniqueIdentifier(identifier, this.segment.getId());
        try {
            SegmentTaskIndexWrapper segmentTaskIndexWrapper = cacheClient.getSegmentAccessClient().getIfPresent(segmentUniqueIdentifier);
            if (null != segmentTaskIndexWrapper) {
                segmentIndexMap = segmentTaskIndexWrapper.getTaskIdToTableSegmentMap();
            }
            if (segmentIndexMap == null) {
                List<TableBlockInfo> tableBlockInfoList = this.getTableBlockInfo(job);
                HashMap<String, List<TableBlockInfo>> segmentToTableBlocksInfos = new HashMap<String, List<TableBlockInfo>>();
                segmentToTableBlocksInfos.put(this.segment.getId(), tableBlockInfoList);
                segmentUniqueIdentifier.setSegmentToTableBlocksInfos(segmentToTableBlocksInfos);
                segmentTaskIndexWrapper = cacheClient.getSegmentAccessClient().get(segmentUniqueIdentifier);
                segmentIndexMap = segmentTaskIndexWrapper.getTaskIdToTableSegmentMap();
            }
        }
        finally {
            cacheClient.close();
        }
        return segmentIndexMap;
    }

    private List<TableBlockInfo> getTableBlockInfo(JobContext job) throws IOException {
        ArrayList<TableBlockInfo> tableBlockInfoList = new ArrayList<TableBlockInfo>();
        for (InputSplit inputSplit : this.segment.getAllSplits(job)) {
            CarbonInputSplit carbonInputSplit = (CarbonInputSplit)inputSplit;
            BlockletInfos blockletInfos = new BlockletInfos(carbonInputSplit.getNumberOfBlocklets(), 0, carbonInputSplit.getNumberOfBlocklets());
            tableBlockInfoList.add(new TableBlockInfo(carbonInputSplit.getPath().toString(), carbonInputSplit.getStart(), this.segment.getId(), carbonInputSplit.getLocations(), carbonInputSplit.getLength(), blockletInfos, carbonInputSplit.getVersion(), carbonInputSplit.getDeleteDeltaFiles()));
        }
        return tableBlockInfoList;
    }

    private List<DataRefNode> getDataBlocksOfSegment(JobContext job, FilterExpressionProcessor filterExpressionProcessor, AbsoluteTableIdentifier identifier, FilterResolverIntf resolver) throws IOException {
        QueryStatisticsRecorder recorder = CarbonTimeStatisticsFactory.createDriverRecorder();
        QueryStatistic statistic = new QueryStatistic();
        Map<SegmentTaskIndexStore.TaskBucketHolder, AbstractIndex> segmentIndexMap = this.getSegmentAbstractIndexs(job, identifier);
        LinkedList<DataRefNode> resultFilterredBlocks = new LinkedList<DataRefNode>();
        for (AbstractIndex abstractIndex : segmentIndexMap.values()) {
            List filterredBlocks = null;
            filterredBlocks = null == resolver ? this.getDataBlocksOfIndex(abstractIndex) : filterExpressionProcessor.getFilterredBlocks(abstractIndex.getDataRefNode(), resolver, abstractIndex, identifier);
            resultFilterredBlocks.addAll(filterredBlocks);
        }
        statistic.addStatistics("Time taken to load the Block(s) In Driver Side with Block count ", System.currentTimeMillis());
        recorder.recordStatistics(statistic);
        recorder.logStatistics();
        return resultFilterredBlocks;
    }

    private List<DataRefNode> getDataBlocksOfIndex(AbstractIndex abstractIndex) {
        LinkedList<DataRefNode> blocks = new LinkedList<DataRefNode>();
        SegmentProperties segmentProperties = abstractIndex.getSegmentProperties();
        try {
            IndexKey startIndexKey = FilterUtil.prepareDefaultStartIndexKey((SegmentProperties)segmentProperties);
            IndexKey endIndexKey = FilterUtil.prepareDefaultEndIndexKey((SegmentProperties)segmentProperties);
            BTreeDataRefNodeFinder blockFinder = new BTreeDataRefNodeFinder(segmentProperties.getEachDimColumnValueSize());
            DataRefNode endBlock = blockFinder.findLastDataBlock(abstractIndex.getDataRefNode(), endIndexKey);
            for (DataRefNode startBlock = blockFinder.findFirstDataBlock(abstractIndex.getDataRefNode(), startIndexKey); startBlock != endBlock; startBlock = startBlock.getNextDataRefNode()) {
                blocks.add(startBlock);
            }
            blocks.add(endBlock);
        }
        catch (KeyGenException e) {
            LOG.error((Object)"Could not generate start key", (Throwable)e);
        }
        return blocks;
    }
}

