/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.hadoop.api;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.carbondata.core.scan.expression.Expression;
import org.apache.carbondata.core.scan.filter.resolver.FilterResolverIntf;
import org.apache.carbondata.hadoop.CarbonProjection;
import org.apache.carbondata.hadoop.internal.CarbonInputSplit;
import org.apache.carbondata.hadoop.internal.segment.Segment;
import org.apache.carbondata.hadoop.internal.segment.SegmentManager;
import org.apache.carbondata.hadoop.internal.segment.SegmentManagerFactory;
import org.apache.carbondata.hadoop.util.CarbonInputFormatUtil;
import org.apache.carbondata.hadoop.util.ObjectSerializationUtil;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;

public class CarbonTableInputFormat<T>
extends FileInputFormat<Void, T> {
    private static final String FILTER_PREDICATE = "mapreduce.input.carboninputformat.filter.predicate";
    private SegmentManager segmentManager = SegmentManagerFactory.getGlobalSegmentManager();

    public RecordReader<Void, T> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        switch (((CarbonInputSplit)split).formatType()) {
            case COLUMNAR: {
                break;
            }
            default: {
                throw new RuntimeException("Unsupported format type");
            }
        }
        return null;
    }

    public List<InputSplit> getSplits(JobContext job) throws IOException {
        LinkedList<InputSplit> output = new LinkedList<InputSplit>();
        Expression filter = this.getFilter(job.getConfiguration());
        Segment[] segments = this.segmentManager.getAllValidSegments();
        FilterResolverIntf filterResolver = CarbonInputFormatUtil.resolveFilter(filter, null);
        for (Segment segment : segments) {
            List<InputSplit> splits = segment.getSplits(job, filterResolver);
            output.addAll(splits);
        }
        return output;
    }

    public void setTablePath(Configuration conf, String tablePath) {
    }

    public String getTablePath(Configuration conf) {
        return null;
    }

    public void setProjection(Configuration conf, CarbonProjection projection) {
    }

    public CarbonProjection getProjection(Configuration conf) {
        return null;
    }

    public void setFilter(Configuration conf, Expression filter) {
        try {
            String filterString = ObjectSerializationUtil.convertObjectToString(filter);
            conf.set(FILTER_PREDICATE, filterString);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while setting filter expression to Job", e);
        }
    }

    public Expression getFilter(Configuration conf) {
        Object filter;
        String filterExprString = conf.get(FILTER_PREDICATE);
        if (filterExprString == null) {
            return null;
        }
        try {
            filter = ObjectSerializationUtil.convertStringToObject(filterExprString);
        }
        catch (IOException e) {
            throw new RuntimeException("Error while reading filter expression", e);
        }
        assert (filter instanceof Expression);
        return (Expression)filter;
    }

    public void selectIndex(Configuration conf) {
    }
}

