/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.hadoop;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.carbondata.core.metadata.AbsoluteTableIdentifier;
import org.apache.carbondata.hadoop.CarbonInputSplit;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputSplit;

public class CarbonMultiBlockSplit
extends InputSplit
implements Writable {
    private List<CarbonInputSplit> splitList;
    private String[] locations;

    public CarbonMultiBlockSplit() {
        this.splitList = null;
        this.locations = null;
    }

    public CarbonMultiBlockSplit(AbsoluteTableIdentifier identifier, List<CarbonInputSplit> splitList, String[] locations) throws IOException {
        this.splitList = splitList;
        this.locations = locations;
    }

    public List<CarbonInputSplit> getAllSplits() {
        return this.splitList;
    }

    public long getLength() throws IOException, InterruptedException {
        long total = 0L;
        for (InputSplit inputSplit : this.splitList) {
            total += inputSplit.getLength();
        }
        return total;
    }

    public String[] getLocations() throws IOException, InterruptedException {
        return this.locations;
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.splitList.size());
        for (CarbonInputSplit split : this.splitList) {
            split.write(out);
        }
        out.writeInt(this.locations.length);
        for (int i = 0; i < this.locations.length; ++i) {
            out.writeUTF(this.locations[i]);
        }
    }

    public void readFields(DataInput in) throws IOException {
        int numSplit = in.readInt();
        this.splitList = new ArrayList<CarbonInputSplit>(numSplit);
        for (int i = 0; i < numSplit; ++i) {
            CarbonInputSplit split = new CarbonInputSplit();
            split.readFields(in);
            this.splitList.add(split);
        }
        int len = in.readInt();
        this.locations = new String[len];
        for (int i = 0; i < len; ++i) {
            this.locations[i] = in.readUTF();
        }
    }
}

