/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.hadoop.util;

import java.util.List;
import org.apache.carbondata.core.carbon.AbsoluteTableIdentifier;
import org.apache.carbondata.core.carbon.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.carbon.metadata.schema.table.column.CarbonDimension;
import org.apache.carbondata.core.carbon.metadata.schema.table.column.CarbonMeasure;
import org.apache.carbondata.scan.expression.Expression;
import org.apache.carbondata.scan.filter.FilterExpressionProcessor;
import org.apache.carbondata.scan.filter.resolver.FilterResolverIntf;
import org.apache.carbondata.scan.model.CarbonQueryPlan;
import org.apache.carbondata.scan.model.QueryDimension;
import org.apache.carbondata.scan.model.QueryMeasure;
import org.apache.carbondata.scan.model.QueryModel;

public class CarbonInputFormatUtil {
    public static CarbonQueryPlan createQueryPlan(CarbonTable carbonTable, String columnString) {
        String[] columns = null;
        if (columnString != null) {
            columns = columnString.split(",");
        }
        String factTableName = carbonTable.getFactTableName();
        CarbonQueryPlan plan = new CarbonQueryPlan(carbonTable.getDatabaseName(), factTableName);
        int i = 0;
        List tableMsrs = carbonTable.getMeasureByTableName(factTableName);
        List tableDims = carbonTable.getDimensionByTableName(factTableName);
        if (columns == null) {
            for (CarbonDimension dimension : tableDims) {
                CarbonInputFormatUtil.addQueryDimension(plan, i, dimension);
                ++i;
            }
            for (CarbonMeasure measure : tableMsrs) {
                CarbonInputFormatUtil.addQueryMeasure(plan, i, measure);
                ++i;
            }
        } else {
            for (String column : columns) {
                CarbonDimension dimensionByName = carbonTable.getDimensionByName(factTableName, column);
                if (dimensionByName != null) {
                    CarbonInputFormatUtil.addQueryDimension(plan, i, dimensionByName);
                    ++i;
                    continue;
                }
                CarbonMeasure measure = carbonTable.getMeasureByName(factTableName, column);
                if (measure == null) {
                    throw new RuntimeException(column + " column not found in the table " + factTableName);
                }
                CarbonInputFormatUtil.addQueryMeasure(plan, i, measure);
                ++i;
            }
        }
        plan.setLimit(-1);
        plan.setQueryId(System.nanoTime() + "");
        return plan;
    }

    private static void addQueryMeasure(CarbonQueryPlan plan, int order, CarbonMeasure measure) {
        QueryMeasure queryMeasure = new QueryMeasure(measure.getColName());
        queryMeasure.setQueryOrder(order);
        queryMeasure.setMeasure(measure);
        plan.addMeasure(queryMeasure);
    }

    private static void addQueryDimension(CarbonQueryPlan plan, int order, CarbonDimension dimension) {
        QueryDimension queryDimension = new QueryDimension(dimension.getColName());
        queryDimension.setQueryOrder(order);
        queryDimension.setDimension(dimension);
        plan.addDimension(queryDimension);
    }

    public static void processFilterExpression(Expression filterExpression, CarbonTable carbonTable) {
        List dimensions = carbonTable.getDimensionByTableName(carbonTable.getFactTableName());
        List measures = carbonTable.getMeasureByTableName(carbonTable.getFactTableName());
        QueryModel.processFilterExpression((Expression)filterExpression, (List)dimensions, (List)measures);
    }

    public static FilterResolverIntf resolveFilter(Expression filterExpression, AbsoluteTableIdentifier absoluteTableIdentifier) {
        try {
            FilterExpressionProcessor filterExpressionProcessor = new FilterExpressionProcessor();
            return filterExpressionProcessor.getFilterResolver(filterExpression, absoluteTableIdentifier);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while resolving filter expression", e);
        }
    }

    public static String processPath(String path) {
        if (path != null && path.startsWith("file:")) {
            return path.substring(5, path.length());
        }
        return path;
    }
}

