/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.hadoop;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.carbondata.common.CarbonIterator;
import org.apache.carbondata.core.cache.dictionary.Dictionary;
import org.apache.carbondata.core.carbon.datastore.block.BlockletInfos;
import org.apache.carbondata.core.carbon.datastore.block.TableBlockInfo;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.hadoop.CarbonInputSplit;
import org.apache.carbondata.hadoop.readsupport.CarbonReadSupport;
import org.apache.carbondata.scan.executor.QueryExecutorFactory;
import org.apache.carbondata.scan.executor.exception.QueryExecutionException;
import org.apache.carbondata.scan.model.QueryModel;
import org.apache.carbondata.scan.result.iterator.ChunkRowIterator;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class CarbonRecordReader<T>
extends RecordReader<Void, T> {
    private QueryModel queryModel;
    private CarbonReadSupport<T> readSupport;
    private CarbonIterator<Object[]> carbonIterator;

    public CarbonRecordReader(QueryModel queryModel, CarbonReadSupport<T> readSupport) {
        this.queryModel = queryModel;
        this.readSupport = readSupport;
    }

    public void initialize(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        CarbonInputSplit carbonInputSplit = (CarbonInputSplit)split;
        ArrayList<TableBlockInfo> tableBlockInfoList = new ArrayList<TableBlockInfo>();
        BlockletInfos blockletInfos = new BlockletInfos(carbonInputSplit.getNumberOfBlocklets(), 0, carbonInputSplit.getNumberOfBlocklets());
        tableBlockInfoList.add(new TableBlockInfo(carbonInputSplit.getPath().toString(), carbonInputSplit.getStart(), carbonInputSplit.getSegmentId(), carbonInputSplit.getLocations(), carbonInputSplit.getLength(), blockletInfos));
        this.queryModel.setTableBlockInfos(tableBlockInfoList);
        this.readSupport.intialize(this.queryModel.getProjectionColumns(), this.queryModel.getAbsoluteTableIdentifier());
        try {
            this.carbonIterator = new ChunkRowIterator(QueryExecutorFactory.getQueryExecutor((QueryModel)this.queryModel).execute(this.queryModel));
        }
        catch (QueryExecutionException e) {
            throw new InterruptedException(e.getMessage());
        }
    }

    public boolean nextKeyValue() {
        return this.carbonIterator.hasNext();
    }

    public Void getCurrentKey() throws IOException, InterruptedException {
        return null;
    }

    public T getCurrentValue() throws IOException, InterruptedException {
        return this.readSupport.readRow((Object[])this.carbonIterator.next());
    }

    public float getProgress() throws IOException, InterruptedException {
        return 0.0f;
    }

    public void close() throws IOException {
        Map columnToDictionaryMapping = this.queryModel.getColumnToDictionaryMapping();
        if (null != columnToDictionaryMapping) {
            for (Map.Entry entry : columnToDictionaryMapping.entrySet()) {
                CarbonUtil.clearDictionaryCache((Dictionary)((Dictionary)entry.getValue()));
            }
        }
        this.readSupport.close();
    }
}

