/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.hadoop;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;

public class CarbonInputSplit
extends FileSplit
implements Serializable,
Writable {
    private static final long serialVersionUID = 3520344046772190207L;
    private String segmentId;
    private int numberOfBlocklets = 0;

    public CarbonInputSplit() {
        super(null, 0L, 0L, new String[0]);
    }

    public CarbonInputSplit(String segmentId, Path path, long start, long length, String[] locations) {
        super(path, start, length, locations);
        this.segmentId = segmentId;
    }

    public CarbonInputSplit(String segmentId, Path path, long start, long length, String[] locations, int numberOfBlocklets) {
        this(segmentId, path, start, length, locations);
        this.numberOfBlocklets = numberOfBlocklets;
    }

    public static CarbonInputSplit from(String segmentId, FileSplit split) throws IOException {
        return new CarbonInputSplit(segmentId, split.getPath(), split.getStart(), split.getLength(), split.getLocations());
    }

    public String getSegmentId() {
        return this.segmentId;
    }

    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.segmentId = in.readUTF();
    }

    public void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeUTF(this.segmentId);
    }

    public int getNumberOfBlocklets() {
        return this.numberOfBlocklets;
    }
}

