/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.hadoop.util;

import java.io.IOException;
import org.apache.carbondata.core.carbon.CarbonTableIdentifier;
import org.apache.carbondata.core.carbon.metadata.CarbonMetadata;
import org.apache.carbondata.core.carbon.metadata.converter.ThriftWrapperSchemaConverterImpl;
import org.apache.carbondata.core.carbon.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.carbon.metadata.schema.table.TableInfo;
import org.apache.carbondata.core.carbon.path.CarbonTablePath;
import org.apache.carbondata.core.datastorage.store.impl.FileFactory;
import org.apache.carbondata.core.reader.ThriftReader;
import org.apache.thrift.TBase;

public class SchemaReader {
    public CarbonTable readCarbonTableFromStore(CarbonTablePath carbonTablePath, CarbonTableIdentifier tableIdentifier, String storePath) throws IOException {
        String schemaFilePath = carbonTablePath.getSchemaFilePath();
        if (FileFactory.isFileExist((String)schemaFilePath, (FileFactory.FileType)FileFactory.FileType.HDFS) || FileFactory.isFileExist((String)schemaFilePath, (FileFactory.FileType)FileFactory.FileType.VIEWFS)) {
            String tableName = tableIdentifier.getTableName();
            ThriftReader.TBaseCreator createTBase = new ThriftReader.TBaseCreator(){

                public TBase create() {
                    return new org.apache.carbondata.format.TableInfo();
                }
            };
            ThriftReader thriftReader = new ThriftReader(carbonTablePath.getSchemaFilePath(), createTBase);
            thriftReader.open();
            org.apache.carbondata.format.TableInfo tableInfo = (org.apache.carbondata.format.TableInfo)thriftReader.read();
            thriftReader.close();
            ThriftWrapperSchemaConverterImpl schemaConverter = new ThriftWrapperSchemaConverterImpl();
            TableInfo wrapperTableInfo = schemaConverter.fromExternalToWrapperTableInfo(tableInfo, tableIdentifier.getDatabaseName(), tableName, storePath);
            wrapperTableInfo.setMetaDataFilepath(CarbonTablePath.getFolderContainingFile((String)schemaFilePath));
            CarbonMetadata.getInstance().loadTableMetadata(wrapperTableInfo);
            return CarbonMetadata.getInstance().getCarbonTable(tableIdentifier.getTableUniqueName());
        }
        return null;
    }
}

