/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.hadoop.readsupport.impl;

import org.apache.carbondata.core.cache.Cache;
import org.apache.carbondata.core.cache.CacheProvider;
import org.apache.carbondata.core.cache.CacheType;
import org.apache.carbondata.core.cache.dictionary.Dictionary;
import org.apache.carbondata.core.cache.dictionary.DictionaryColumnUniqueIdentifier;
import org.apache.carbondata.core.carbon.AbsoluteTableIdentifier;
import org.apache.carbondata.core.carbon.metadata.datatype.DataType;
import org.apache.carbondata.core.carbon.metadata.encoder.Encoding;
import org.apache.carbondata.core.carbon.metadata.schema.table.column.CarbonColumn;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.core.util.CarbonUtilException;
import org.apache.carbondata.hadoop.readsupport.CarbonReadSupport;

public abstract class AbstractDictionaryDecodedReadSupport<T>
implements CarbonReadSupport<T> {
    protected Dictionary[] dictionaries;
    protected DataType[] dataTypes;
    protected CarbonColumn[] carbonColumns;

    @Override
    public void intialize(CarbonColumn[] carbonColumns, AbsoluteTableIdentifier absoluteTableIdentifier) {
        this.carbonColumns = carbonColumns;
        this.dictionaries = new Dictionary[carbonColumns.length];
        this.dataTypes = new DataType[carbonColumns.length];
        for (int i = 0; i < carbonColumns.length; ++i) {
            if (!carbonColumns[i].hasEncoding(Encoding.DICTIONARY) || carbonColumns[i].hasEncoding(Encoding.DIRECT_DICTIONARY)) continue;
            CacheProvider cacheProvider = CacheProvider.getInstance();
            Cache forwardDictionaryCache = cacheProvider.createCache(CacheType.FORWARD_DICTIONARY, absoluteTableIdentifier.getStorePath());
            try {
                this.dataTypes[i] = carbonColumns[i].getDataType();
                this.dictionaries[i] = (Dictionary)forwardDictionaryCache.get((Object)new DictionaryColumnUniqueIdentifier(absoluteTableIdentifier.getCarbonTableIdentifier(), carbonColumns[i].getColumnIdentifier(), this.dataTypes[i]));
                continue;
            }
            catch (CarbonUtilException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void close() {
        for (int i = 0; i < this.dictionaries.length; ++i) {
            CarbonUtil.clearDictionaryCache((Dictionary)this.dictionaries[i]);
        }
    }
}

