/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.hadoop;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapreduce.InputSplit;

public class CarbonRawDataInputSplit
extends InputSplit
implements Writable {
    long length;
    String[] locations;

    public CarbonRawDataInputSplit(long length, String[] locations) {
        this.length = length;
        this.locations = locations;
    }

    public static CarbonRawDataInputSplit from(FileSplit split) throws IOException {
        return new CarbonRawDataInputSplit(split.getLength(), split.getLocations());
    }

    public long getLength() throws IOException, InterruptedException {
        return this.length;
    }

    public String[] getLocations() throws IOException, InterruptedException {
        return this.locations;
    }

    public void write(DataOutput out) throws IOException {
        out.writeLong(this.length);
        out.writeLong(this.locations.length);
    }

    public void readFields(DataInput in) throws IOException {
    }
}

