/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.examples.util;

import java.io.DataOutputStream;
import org.apache.carbondata.core.datastorage.store.filesystem.CarbonFile;
import org.apache.carbondata.core.datastorage.store.impl.FileFactory;
import org.apache.carbondata.examples.util.AllDictionaryUtil$;
import org.apache.carbondata.examples.util.AllDictionaryUtil$$anonfun$1$;
import org.apache.spark.Logging;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

public final class AllDictionaryUtil$
implements Logging {
    public static final AllDictionaryUtil$ MODULE$;
    private transient Logger org$apache$spark$Logging$$log_;

    static {
        new AllDictionaryUtil$();
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void extractDictionary(SparkContext sc, String srcData, String outputPath, String fileHeader, String dictCol) {
        String[] fileHeaderArr = fileHeader.split(",");
        boolean[] isDictCol = new boolean[fileHeaderArr.length];
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), fileHeaderArr.length).foreach$mVc$sp((Function1)new Serializable(dictCol, fileHeaderArr, isDictCol){
            public static final long serialVersionUID = 0L;
            private final String dictCol$1;
            private final String[] fileHeaderArr$1;
            private final boolean[] isDictCol$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.isDictCol$1[i] = this.dictCol$1.contains(new StringBuilder().append((Object)"|").append((Object)this.fileHeaderArr$1[i]).append((Object)"|").toString());
            }
            {
                this.dictCol$1 = dictCol$1;
                this.fileHeaderArr$1 = fileHeaderArr$1;
                this.isDictCol$1 = isDictCol$1;
            }
        });
        RDD dictionaryRdd = RDD$.MODULE$.rddToPairRDDFunctions(sc.textFile(srcData, sc.textFile$default$2()).flatMap((Function1)new Serializable(isDictCol){
            public static final long serialVersionUID = 0L;
            public final boolean[] isDictCol$1;

            /*
             * WARNING - void declaration
             */
            public final ArrayBuffer<Tuple2<Object, String>> apply(String x) {
                void var3_3;
                String[] tokens = x.split(",");
                ArrayBuffer result = new ArrayBuffer();
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.isDictCol$1.length).foreach((Function1)new Serializable(this, x, tokens, result){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.1 $outer;
                    public final String x$1;
                    private final String[] tokens$1;
                    private final ArrayBuffer result$1;

                    /*
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    public final Object apply(int i) {
                        BoxedUnit boxedUnit;
                        if (!this.$outer.isDictCol$1[i]) {
                            boxedUnit = BoxedUnit.UNIT;
                            return boxedUnit;
                        }
                        try {
                            boxedUnit = this.result$1.$plus$eq((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)i), (Object)this.tokens$1[i]));
                            return boxedUnit;
                        }
                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                            AllDictionaryUtil$.MODULE$.logError((Function0<String>)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ anonfun$1$$anonfun$apply$1 $outer;

                                public final String apply() {
                                    return new StringBuilder().append((Object)"Read a bad record: ").append((Object)this.$outer.x$1).toString();
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                }
                            });
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        return boxedUnit;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.x$1 = x$1;
                        this.tokens$1 = tokens$1;
                        this.result$1 = result$1;
                    }
                });
                return var3_3;
            }
            {
                this.isDictCol$1 = isDictCol$1;
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(String.class), (Ordering)Ordering.Int$.MODULE$).groupByKey().flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * WARNING - void declaration
             */
            public final HashSet<Tuple2<Object, String>> apply(Tuple2<Object, Iterable<String>> x) {
                void var2_2;
                HashSet distinctValues = new HashSet();
                ((IterableLike)x._2()).foreach((Function1)new Serializable(this, x, distinctValues){
                    public static final long serialVersionUID = 0L;
                    private final Tuple2 x$2;
                    private final HashSet distinctValues$1;

                    public final boolean apply(String value) {
                        return this.distinctValues$1.add((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)this.x$2._1$mcI$sp()), (Object)value));
                    }
                    {
                        this.x$2 = x$2;
                        this.distinctValues$1 = distinctValues$1;
                    }
                });
                return var2_2;
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        String[] dictionaryValues = (String[])dictionaryRdd.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<Object, String> x) {
                return new StringBuilder().append(x._1$mcI$sp()).append((Object)",").append(x._2()).toString();
            }
        }, ClassTag$.MODULE$.apply(String.class)).collect();
        this.saveToFile(dictionaryValues, outputPath);
    }

    public void cleanDictionary(String outputPath) {
        try {
            FileFactory.FileType fileType = FileFactory.getFileType((String)outputPath);
            CarbonFile file = FileFactory.getCarbonFile((String)outputPath, (FileFactory.FileType)fileType);
            if (file.exists()) {
                file.delete();
            }
        }
        catch (Exception exception) {
            this.logError((Function0<String>)new Serializable(exception){
                public static final long serialVersionUID = 0L;
                private final Exception ex$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"Clean dictionary catching exception:").append((Object)this.ex$1).toString();
                }
                {
                    this.ex$1 = ex$1;
                }
            });
        }
    }

    /*
     * Loose catch block
     */
    public void saveToFile(String[] contents, String outputPath) {
        block12: {
            ObjectRef writer = new ObjectRef(null);
            FileFactory.FileType fileType = FileFactory.getFileType((String)outputPath);
            CarbonFile file = FileFactory.getCarbonFile((String)outputPath, (FileFactory.FileType)fileType);
            Object object = file.exists() ? BoxedUnit.UNIT : BoxesRunTime.boxToBoolean((boolean)file.createNewFile());
            writer.elem = FileFactory.getDataOutputStream((String)outputPath, (FileFactory.FileType)fileType);
            Predef$.MODULE$.refArrayOps((Object[])contents).foreach((Function1)new Serializable(writer){
                public static final long serialVersionUID = 0L;
                private final ObjectRef writer$1;

                public final void apply(String content) {
                    ((DataOutputStream)this.writer$1.elem).writeBytes(new StringBuilder().append((Object)content).append((Object)"\n").toString());
                }
                {
                    this.writer$1 = writer$1;
                }
            });
            if ((DataOutputStream)writer.elem == null) break block12;
            ((DataOutputStream)writer.elem).close();
            catch (Exception exception) {
                try {
                    this.logError((Function0<String>)new Serializable(exception){
                        public static final long serialVersionUID = 0L;
                        private final Exception ex$2;

                        public final String apply() {
                            return new StringBuilder().append((Object)"Save dictionary to file catching exception:").append((Object)this.ex$2).toString();
                        }
                        {
                            this.ex$2 = ex$2;
                        }
                    });
                }
                catch (Throwable throwable) {
                    if ((DataOutputStream)writer.elem != null) {
                        try {
                            ((DataOutputStream)writer.elem).close();
                        }
                        catch (Exception exception2) {
                            this.logError((Function0<String>)new Serializable(exception2){
                                public static final long serialVersionUID = 0L;
                                private final Exception ex$3;

                                public final String apply() {
                                    return new StringBuilder().append((Object)"Close output stream catching exception:").append((Object)this.ex$3).toString();
                                }
                                {
                                    this.ex$3 = ex$3;
                                }
                            });
                        }
                    }
                    throw throwable;
                }
            }
            if ((DataOutputStream)writer.elem != null) {
                try {
                    ((DataOutputStream)writer.elem).close();
                }
                catch (Exception exception) {
                    this.logError((Function0<String>)new /* invalid duplicate definition of identical inner class */);
                }
            }
            break block12;
            catch (Exception exception) {
                this.logError((Function0<String>)new /* invalid duplicate definition of identical inner class */);
            }
        }
    }

    private AllDictionaryUtil$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
    }
}

