/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.examples;

import org.apache.carbondata.examples.Query;
import org.apache.carbondata.examples.QueryResult;
import org.apache.carbondata.examples.QueryRunner;
import org.apache.carbondata.examples.TableGenerator;
import org.apache.carbondata.examples.TableTemplate;
import org.apache.carbondata.examples.util.InitForExamples$;
import org.apache.spark.sql.CarbonContext;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.SQLContext;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.ObjectRef;

public final class PerfTest$ {
    public static final PerfTest$ MODULE$;
    private final Seq<String> olap;
    private final Seq<String> point;
    private final Seq<String> filter;
    private final Seq<String> scan;

    static {
        new PerfTest$();
    }

    private Seq<String> olap() {
        return this.olap;
    }

    private Seq<String> point() {
        return this.point;
    }

    private Seq<String> filter() {
        return this.filter;
    }

    private Seq<String> scan() {
        return this.scan;
    }

    public void main(String[] args) {
        CarbonContext cc = InitForExamples$.MODULE$.createCarbonContext("PerfTest");
        ObjectRef workload = new ObjectRef((Object)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)));
        ((IterableLike)this.olap().zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(workload){
            public static final long serialVersionUID = 0L;
            private final ObjectRef workload$1;

            public final void apply(Tuple2<String, Object> x) {
                this.workload$1.elem = (Seq)((Seq)this.workload$1.elem).$colon$plus((Object)new Query("OLAP Query", x._2$mcI$sp(), (String)x._1()), Seq$.MODULE$.canBuildFrom());
            }
            {
                this.workload$1 = workload$1;
            }
        });
        ((IterableLike)this.point().zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(workload){
            public static final long serialVersionUID = 0L;
            private final ObjectRef workload$1;

            public final void apply(Tuple2<String, Object> x) {
                this.workload$1.elem = (Seq)((Seq)this.workload$1.elem).$colon$plus((Object)new Query("Point Query", x._2$mcI$sp(), (String)x._1()), Seq$.MODULE$.canBuildFrom());
            }
            {
                this.workload$1 = workload$1;
            }
        });
        ((IterableLike)this.filter().zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(workload){
            public static final long serialVersionUID = 0L;
            private final ObjectRef workload$1;

            public final void apply(Tuple2<String, Object> x) {
                this.workload$1.elem = (Seq)((Seq)this.workload$1.elem).$colon$plus((Object)new Query("Filter Query", x._2$mcI$sp(), (String)x._1()), Seq$.MODULE$.canBuildFrom());
            }
            {
                this.workload$1 = workload$1;
            }
        });
        ((IterableLike)this.scan().zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(workload){
            public static final long serialVersionUID = 0L;
            private final ObjectRef workload$1;

            public final void apply(Tuple2<String, Object> x) {
                this.workload$1.elem = (Seq)((Seq)this.workload$1.elem).$colon$plus((Object)new Query("Scan Query", x._2$mcI$sp(), (String)x._1()), Seq$.MODULE$.canBuildFrom());
            }
            {
                this.workload$1 = workload$1;
            }
        });
        int rows = 3000000;
        Seq dimension = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcII.sp(1, 1000), new Tuple2.mcII.sp(1, 100), new Tuple2.mcII.sp(1, 50), new Tuple2.mcII.sp(2, 10)}));
        int measure = 5;
        TableTemplate template = new TableTemplate((Seq<Tuple2<Object, Object>>)dimension, measure);
        DataFrame df = new TableGenerator((SQLContext)cc).genDataFrame(template, rows);
        Predef$.MODULE$.println((Object)"generate data completed");
        Seq datasource = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"parquet", "orc", "carbon"}));
        QueryRunner runner = new QueryRunner((SQLContext)cc, df, (Seq<String>)datasource);
        Seq<QueryResult> results = runner.loadData();
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"load performance: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)results.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply(QueryResult x$3) {
                return x$3.avgTime() / 1000000L;
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString(", ")})));
        DoubleRef parquetTime = new DoubleRef(0.0);
        DoubleRef orcTime = new DoubleRef(0.0);
        DoubleRef carbonTime = new DoubleRef(0.0);
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"query id: ", ", result in millisecond"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{datasource.mkString(", ")})));
        ((Seq)workload.elem).foreach((Function1)new Serializable(runner, parquetTime, orcTime, carbonTime){
            public static final long serialVersionUID = 0L;
            private final QueryRunner runner$1;
            private final DoubleRef parquetTime$1;
            private final DoubleRef orcTime$1;
            private final DoubleRef carbonTime$1;

            public final void apply(Query query) {
                Predef$.MODULE$.print((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", ": "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{query.queryType(), BoxesRunTime.boxToInteger((int)query.queryNo())})));
                Seq<QueryResult> results = this.runner$1.run(query, 4);
                Predef$.MODULE$.print((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)results.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply(QueryResult x$4) {
                        return x$4.avgTime() / 1000000L;
                    }
                }, Seq$.MODULE$.canBuildFrom())).mkString(", ")})));
                Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[sql: ", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{query.sqlString().replace('\n', ' ')})));
                this.parquetTime$1.elem += (double)((QueryResult)results.apply(0)).avgTime();
                this.orcTime$1.elem += (double)((QueryResult)results.apply(1)).avgTime();
                this.carbonTime$1.elem += (double)((QueryResult)results.apply(2)).avgTime();
            }
            {
                this.runner$1 = runner$1;
                this.parquetTime$1 = parquetTime$1;
                this.orcTime$1 = orcTime$1;
                this.carbonTime$1 = carbonTime$1;
            }
        });
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Total time: ", ", ", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)(parquetTime.elem / (double)1000000)), BoxesRunTime.boxToDouble((double)(orcTime.elem / (double)1000000))}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = 1 : ", " : ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)(carbonTime.elem / (double)1000000)), BoxesRunTime.boxToDouble((double)(parquetTime.elem / orcTime.elem)), BoxesRunTime.boxToDouble((double)(parquetTime.elem / carbonTime.elem))}))).toString());
        runner.shutDown();
    }

    public String makeTableName(String datasource) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "_perftest_table"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{datasource}));
    }

    public String savePath(String datasource) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/target/perftest/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{InitForExamples$.MODULE$.currentPath(), datasource}));
    }

    public long withTime(Function0<BoxedUnit> body) {
        long start = System.nanoTime();
        body.apply$mcV$sp();
        return System.nanoTime() - start;
    }

    private PerfTest$() {
        MODULE$ = this;
        this.olap = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringOps(Predef$.MODULE$.augmentString("SELECT c3, c4, sum(c8) FROM tableName\n      |WHERE c1 = 'P1_23' and c2 = 'P2_43'\n      |GROUP BY c3, c4")).stripMargin(), new StringOps(Predef$.MODULE$.augmentString("SELECT c2, c3, sum(c9) FROM tableName\n      |WHERE c1 = 'P1_432' and c4 = 'P4_3' and c5 = 'P5_2'\n      |GROUP by c2, c3 ")).stripMargin(), new StringOps(Predef$.MODULE$.augmentString("SELECT c2, count(distinct c1), sum(c8) FROM tableName\n      |WHERE c3=\"P3_4\" and c5=\"P5_4\"\n      |GROUP BY c2 ")).stripMargin(), new StringOps(Predef$.MODULE$.augmentString("SELECT c2, c5, count(distinct c1), sum(c7) FROM tableName\n      |WHERE c4=\"P4_4\" and c5=\"P5_7\" and c8>4\n      |GROUP BY c2, c5 ")).stripMargin()}));
        this.point = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringOps(Predef$.MODULE$.augmentString("SELECT c4 FROM tableName\n      |WHERE c1=\"P1_43\" ")).stripMargin(), new StringOps(Predef$.MODULE$.augmentString("SELECT c3 FROM tableName\n      |WHERE c1=\"P1_542\" and c2=\"P2_23\" ")).stripMargin(), new StringOps(Predef$.MODULE$.augmentString("SELECT c3, c5 FROM tableName\n      |WHERE c1=\"P1_52\" and c7=4")).stripMargin(), new StringOps(Predef$.MODULE$.augmentString("SELECT c4, c9 FROM tableName\n      |WHERE c1=\"P1_43\" and c8<3")).stripMargin()}));
        this.filter = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringOps(Predef$.MODULE$.augmentString("SELECT * FROM tableName\n      |WHERE c2=\"P2_43\" ")).stripMargin(), new StringOps(Predef$.MODULE$.augmentString("SELECT * FROM tableName\n      |WHERE c3=\"P3_3\"  ")).stripMargin(), new StringOps(Predef$.MODULE$.augmentString("SELECT * FROM tableName\n      |WHERE c2=\"P2_32\" and c3=\"P3_23\" ")).stripMargin(), new StringOps(Predef$.MODULE$.augmentString("SELECT * FROM tableName\n      |WHERE c3=\"P3_28\" and c4=\"P4_3\" ")).stripMargin()}));
        this.scan = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringOps(Predef$.MODULE$.augmentString("SELECT sum(c7), sum(c8), avg(c9), max(c10) FROM tableName ")).stripMargin(), new StringOps(Predef$.MODULE$.augmentString("SELECT sum(c7) FROM tableName\n      |WHERE c2=\"P2_32\" ")).stripMargin(), new StringOps(Predef$.MODULE$.augmentString("SELECT sum(c7), sum(c8), sum(9), sum(c10) FROM tableName\n      |WHERE c4=\"P4_4\" ")).stripMargin(), new StringOps(Predef$.MODULE$.augmentString("SELECT sum(c7), sum(c8), sum(9), sum(c10) FROM tableName\n      |WHERE c2=\"P2_75\" and c6<5 ")).stripMargin()}));
    }
}

