/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.examples;

import org.apache.carbondata.core.cache.dictionary.Dictionary;
import org.apache.carbondata.core.cache.dictionary.DictionaryColumnUniqueIdentifier;
import org.apache.carbondata.core.carbon.CarbonTableIdentifier;
import org.apache.carbondata.core.carbon.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.carbon.metadata.schema.table.column.CarbonDimension;
import org.apache.carbondata.core.carbon.path.CarbonStorePath;
import org.apache.carbondata.core.carbon.path.CarbonTablePath;
import org.apache.carbondata.examples.util.InitForExamples$;
import org.apache.carbondata.spark.load.CarbonLoaderUtil;
import org.apache.spark.sql.CarbonContext;
import org.apache.spark.sql.CarbonEnv$;
import org.apache.spark.sql.CarbonRelation;
import org.apache.spark.sql.SQLContext;
import scala.Array$;
import scala.Function1;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;

public final class GenerateDictionaryExample$ {
    public static final GenerateDictionaryExample$ MODULE$;

    static {
        new GenerateDictionaryExample$();
    }

    public void main(String[] args) {
        CarbonContext cc = InitForExamples$.MODULE$.createCarbonContext("GenerateDictionaryExample");
        String factFilePath = new StringBuilder().append((Object)InitForExamples$.MODULE$.currentPath()).append((Object)"/src/main/resources/factSample.csv").toString();
        CarbonTablePath carbonTablePath = CarbonStorePath.getCarbonTablePath((String)InitForExamples$.MODULE$.storeLocation(), (CarbonTableIdentifier)new CarbonTableIdentifier("default", "dictSample", "1"));
        String dictFolderPath = carbonTablePath.getMetadataDirectoryPath();
        cc.sql("DROP TABLE IF EXISTS dictSample");
        cc.sql("\n           CREATE TABLE IF NOT EXISTS dictSample(id Int, name String, city String, salary Int)\n           STORED BY 'org.apache.carbondata.format'\n           ");
        cc.sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           LOAD DATA LOCAL INPATH '", "' INTO TABLE dictSample\n           "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{factFilePath})));
        CarbonTableIdentifier tableIdentifier = new CarbonTableIdentifier("default", "dictSample", "1");
        this.printDictionary(cc, tableIdentifier, dictFolderPath);
    }

    public void printDictionary(CarbonContext cc, CarbonTableIdentifier carbonTableIdentifier, String dictFolderPath) {
        String dataBaseName = carbonTableIdentifier.getDatabaseName();
        String tableName = carbonTableIdentifier.getTableName();
        CarbonRelation carbonRelation = (CarbonRelation)CarbonEnv$.MODULE$.getInstance((SQLContext)cc).carbonCatalog().lookupRelation1(Option$.MODULE$.apply((Object)dataBaseName), tableName, (SQLContext)cc);
        CarbonTable carbonTable = carbonRelation.tableMeta().carbonTable();
        CarbonDimension[] dimensions = (CarbonDimension[])Predef$.MODULE$.refArrayOps(carbonTable.getDimensionByTableName(tableName.toLowerCase()).toArray()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final CarbonDimension apply(Object x$1) {
                return (CarbonDimension)x$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(CarbonDimension.class)));
        Predef$.MODULE$.println((Object)"**********************************************************************************");
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"table:", " in "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"database:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dataBaseName}))).toString());
        Predef$.MODULE$.refArrayOps((Object[])dimensions).foreach((Function1)new Serializable(cc, carbonTableIdentifier){
            public static final long serialVersionUID = 0L;
            private final CarbonContext cc$1;
            private final CarbonTableIdentifier carbonTableIdentifier$1;

            public final void apply(CarbonDimension dimension) {
                Predef$.MODULE$.println((Object)"**********************************************************************************");
                Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"dictionary of dimension: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dimension.getColName()})));
                Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Key\\t\\t\\tValue"})).s((Seq)Nil$.MODULE$));
                DictionaryColumnUniqueIdentifier columnIdentifier = new DictionaryColumnUniqueIdentifier(this.carbonTableIdentifier$1, dimension.getColumnIdentifier(), dimension.getDataType());
                Dictionary dict = CarbonLoaderUtil.getDictionary((DictionaryColumnUniqueIdentifier)columnIdentifier, (String)this.cc$1.storePath());
                int index = 1;
                String distinctValue = dict.getDictionaryValueForKey(index);
                while (distinctValue != null) {
                    Predef$.MODULE$.println((Object)new StringBuilder().append(index).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\t\\t\\t"})).s((Seq)Nil$.MODULE$)).append((Object)distinctValue).toString());
                    distinctValue = dict.getDictionaryValueForKey(++index);
                }
                return;
            }
            {
                this.cc$1 = cc$1;
                this.carbonTableIdentifier$1 = carbonTableIdentifier$1;
            }
        });
        Predef$.MODULE$.println((Object)"**********************************************************************************");
    }

    private GenerateDictionaryExample$() {
        MODULE$ = this;
    }
}

