/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.examples;

import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.carbondata.examples.util.AllDictionaryUtil$;
import org.apache.carbondata.examples.util.InitForExamples$;
import org.apache.spark.sql.CarbonContext;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;

public final class AllDictionaryExample$ {
    public static final AllDictionaryExample$ MODULE$;

    static {
        new AllDictionaryExample$();
    }

    public void main(String[] args) {
        CarbonContext cc = InitForExamples$.MODULE$.createCarbonContext("CarbonExample");
        String testData = new StringBuilder().append((Object)InitForExamples$.MODULE$.currentPath()).append((Object)"/src/main/resources/datawithoutheader.csv").toString();
        String csvHeader = "id,date,country,name,phonetype,serialname,salary";
        String dictCol = "|date|country|name|phonetype|serialname|";
        String allDictFile = new StringBuilder().append((Object)InitForExamples$.MODULE$.currentPath()).append((Object)"/src/main/resources/datawithoutheader.dictionary").toString();
        AllDictionaryUtil$.MODULE$.extractDictionary(cc.sparkContext(), testData, allDictFile, csvHeader, dictCol);
        CarbonProperties.getInstance().addProperty("carbon.timestamp.format", "yyyy/mm/dd");
        cc.sql("DROP TABLE IF EXISTS t3");
        cc.sql("\n           CREATE TABLE IF NOT EXISTS t3\n           (ID Int, date Timestamp, country String,\n           name String, phonetype String, serialname String, salary Int)\n           STORED BY 'org.apache.carbondata.format'\n           ");
        cc.sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           LOAD DATA LOCAL INPATH '", "' into table t3\n           options('FILEHEADER'='id,date,country,name,phonetype,serialname,salary',\n           'ALL_DICTIONARY_PATH'='", "')\n           "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{testData, allDictFile})));
        cc.sql("\n           SELECT * FROM t3\n           ").show();
        cc.sql("DROP TABLE IF EXISTS t3");
        AllDictionaryUtil$.MODULE$.cleanDictionary(allDictFile);
    }

    private AllDictionaryExample$() {
        MODULE$ = this;
    }
}

