/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.common.logging;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.carbondata.common.logging.impl.AuditLevel;
import org.apache.carbondata.common.logging.impl.StatisticLevel;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class LogService
extends Logger {
    private static String hostName;
    private static String username;

    protected LogService(String name) {
        super(name);
        try {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            hostName = "localhost";
        }
        try {
            username = UserGroupInformation.getCurrentUser().getShortUserName();
        }
        catch (IOException e) {
            username = "unknown";
        }
    }

    public void debug(String message) {
        super.debug((Object)message);
    }

    public void info(String message) {
        super.info((Object)message);
    }

    public void warn(String message) {
        super.warn((Object)message);
    }

    public void error(String message) {
        super.error((Object)message);
    }

    public void error(Throwable throwable) {
        super.error((Object)throwable);
    }

    public void error(Throwable throwable, String message) {
        super.error((Object)message, throwable);
    }

    public void audit(String message) {
        String threadid = Thread.currentThread().getId() + "";
        super.log((Priority)AuditLevel.AUDIT, (Object)("[" + hostName + "][" + username + "][Thread-" + threadid + "]" + message));
    }

    public void statistic(String message) {
        super.log((Priority)StatisticLevel.STATISTIC, (Object)message);
    }

    public boolean isDebugEnabled() {
        return super.isDebugEnabled();
    }

    public boolean isWarnEnabled() {
        return super.isEnabledFor((Priority)Level.WARN);
    }

    public boolean isInfoEnabled() {
        return super.isInfoEnabled();
    }
}

