/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.common;

import java.util.Objects;
import org.apache.carbondata.common.annotations.InterfaceAudience;

@InterfaceAudience.Internal
public class Strings {
    public static String mkString(String[] strings, String delimiter) {
        Objects.requireNonNull(strings);
        Objects.requireNonNull(delimiter);
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < strings.length; ++i) {
            builder.append(strings[i]);
            if (i == strings.length - 1) continue;
            builder.append(delimiter);
        }
        return builder.toString();
    }

    public static String formatSize(float size) {
        long KB = 1024L;
        long MB = KB << 10;
        long GB = MB << 10;
        long TB = GB << 10;
        if (size < 0.0f) {
            return "NA";
        }
        if (size >= 0.0f && size < (float)KB) {
            return String.format("%sB", Float.valueOf(size));
        }
        if (size >= (float)KB && size < (float)MB) {
            return String.format("%.2fKB", Float.valueOf(size / (float)KB));
        }
        if (size >= (float)MB && size < (float)GB) {
            return String.format("%.2fMB", Float.valueOf(size / (float)MB));
        }
        if (size >= (float)GB && size < (float)TB) {
            return String.format("%.2fGB", Float.valueOf(size / (float)GB));
        }
        return String.format("%.2fTB", Float.valueOf(size / (float)TB));
    }
}

