/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.common.logging.impl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Properties;
import org.apache.carbondata.common.logging.LogService;
import org.apache.carbondata.common.logging.impl.AuditLevel;
import org.apache.carbondata.common.logging.impl.FileUtil;
import org.apache.carbondata.common.logging.impl.StatisticLevel;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.log4j.Logger;
import org.apache.log4j.MDC;
import org.apache.log4j.Priority;

public final class StandardLogService
implements LogService {
    private static final String PARTITION_ID = "[partitionID:";
    private static final String CARBON_AUDIT_LOG_PATH = "carbon.auditlog.file.path";
    private static final String AUDIT_LOG_DEFAULT_PATH = "logs/CarbonAudit.log";
    private static final String CARBON_AUDIT_LOG_ROLLING_UP_SIZE = "carbon.auditlog.max.file.size";
    private static final String AUDIT_LOG_DEFAULT_ROLLING_UP_SIZE = "10MB";
    private static final String CARBON_AUDIT_LOG_MAX_BACKUP = "carbon.auditlog.max.backup.files";
    private static final String AUDIT_LOG_DEFAULT_MAX_BACKUP = "10";
    private static final String CARBON_AUDIT_LOG_LEVEL = "carbon.logging.level";
    private static final String AUDIT_LOG_DEFAULT_LEVEL = "INFO";
    private static boolean doLog = true;
    private Logger logger;

    public StandardLogService(String clazzName) {
        String auditLogPath = AUDIT_LOG_DEFAULT_PATH;
        String rollupSize = AUDIT_LOG_DEFAULT_ROLLING_UP_SIZE;
        String maxBackup = AUDIT_LOG_DEFAULT_MAX_BACKUP;
        String logLevel = AUDIT_LOG_DEFAULT_LEVEL;
        Properties props = new Properties();
        Properties carbonProps = FileUtil.getCarbonProperties();
        if (null != carbonProps) {
            if (null != carbonProps.getProperty(CARBON_AUDIT_LOG_PATH)) {
                auditLogPath = carbonProps.getProperty(CARBON_AUDIT_LOG_PATH);
            }
            if (null != carbonProps.getProperty(CARBON_AUDIT_LOG_ROLLING_UP_SIZE)) {
                rollupSize = carbonProps.getProperty(CARBON_AUDIT_LOG_ROLLING_UP_SIZE);
            }
            if (null != carbonProps.getProperty(CARBON_AUDIT_LOG_MAX_BACKUP)) {
                maxBackup = carbonProps.getProperty(CARBON_AUDIT_LOG_MAX_BACKUP);
            }
            if (null != carbonProps.getProperty(CARBON_AUDIT_LOG_LEVEL)) {
                logLevel = carbonProps.getProperty(CARBON_AUDIT_LOG_LEVEL);
            }
        }
        props.setProperty("log4j.rootLogger", logLevel + ",stdout,AUDL");
        props.setProperty("log4j.appender.stdout", "org.apache.log4j.ConsoleAppender");
        props.setProperty("log4j.appender.stdout.layout.ConversionPattern", "%d %-5p [%c] %m%n");
        props.setProperty("log4j.appender.stdout.layout", "org.apache.log4j.PatternLayout");
        props.setProperty("log4j.appender.AUDL", "AuditExtendedRollingFileAppender");
        props.setProperty("log4j.appender.AUDL.File", auditLogPath);
        props.setProperty("log4j.appender.AUDL.threshold", "AUDIT#AuditLevel");
        props.setProperty("log4j.appender.AUDL.layout.ConversionPattern", "%d{yy/MM/dd HH:mm:ss} %p %c{1}: %m%n");
        props.setProperty("log4j.appender.AUDL.layout", "org.apache.log4j.PatternLayout");
        props.setProperty("log4j.appender.AUDL.MaxFileSize", rollupSize);
        props.setProperty("log4j.appender.AUDL.MaxBackupIndex", maxBackup);
        props.setProperty("log4j.logger.com.huawei", logLevel + ",stdout");
        props.setProperty("log4j.logger.com.huawei", logLevel + ",AUDL");
        this.logger = Logger.getLogger((String)clazzName);
    }

    public StandardLogService() {
        this("Carbon");
    }

    public static boolean isDoLog() {
        return doLog;
    }

    public static void setDoLog(boolean doLog) {
        StandardLogService.doLog = doLog;
    }

    public static String getPartitionID(String tableName) {
        return tableName.substring(tableName.lastIndexOf(95) + 1, tableName.length());
    }

    public static void setThreadName(String partitionID, String queryID) {
        StringBuilder b = new StringBuilder(PARTITION_ID);
        b.append(partitionID);
        if (null != queryID) {
            b.append(";queryID:");
            b.append(queryID);
        }
        b.append("]");
        Thread.currentThread().setName(StandardLogService.getThreadName() + b.toString());
    }

    private static String getThreadName() {
        String name = Thread.currentThread().getName();
        int index = name.indexOf(PARTITION_ID);
        name = index > -1 ? name.substring(0, index) : '[' + name + ']';
        return name.trim();
    }

    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    public boolean isWarnEnabled() {
        return this.logger.isEnabledFor((Priority)org.apache.log4j.Level.WARN);
    }

    @Override
    public void debug(String message) {
        if (this.logger.isDebugEnabled()) {
            this.logMessage(Level.DEBUG, null, message);
        }
    }

    @Override
    public void error(String message) {
        this.logMessage(Level.ERROR, null, message);
    }

    @Override
    public void error(Throwable throwable, String message) {
        this.logMessage(Level.ERROR, throwable, message);
    }

    @Override
    public void error(Throwable throwable) {
        this.logMessage(Level.ERROR, throwable, "");
    }

    @Override
    public void info(String message) {
        if (this.logger.isInfoEnabled()) {
            this.logMessage(Level.INFO, null, message);
        }
    }

    private void logMessage(Level logLevel, Throwable throwable, String message) {
        if (doLog) {
            try {
                StringBuilder buff = new StringBuilder(Thread.currentThread().getName());
                buff.append(" ");
                buff.append(message);
                message = buff.toString();
                if (Level.ERROR.toString().equalsIgnoreCase(logLevel.toString())) {
                    this.logErrorMessage(throwable, message);
                } else if (Level.DEBUG.toString().equalsIgnoreCase(logLevel.toString())) {
                    this.logDebugMessage(throwable, message);
                } else if (Level.INFO.toString().equalsIgnoreCase(logLevel.toString())) {
                    this.logInfoMessage(throwable, message);
                } else if (Level.WARN.toString().equalsIgnoreCase(logLevel.toString())) {
                    this.logWarnMessage(throwable, message);
                } else if (Level.AUDIT.toString().equalsIgnoreCase(logLevel.toString())) {
                    this.audit(message);
                } else if (Level.STATISTICS == logLevel) {
                    this.statistic(message);
                }
            }
            catch (Throwable t) {
                this.logger.error((Object)t);
            }
        }
    }

    private void logErrorMessage(Throwable throwable, String message) {
        if (null == throwable) {
            this.logger.error((Object)message);
        } else {
            this.logger.error((Object)message, throwable);
        }
    }

    private void logInfoMessage(Throwable throwable, String message) {
        if (null == throwable) {
            this.logger.info((Object)message);
        } else {
            this.logger.info((Object)message, throwable);
        }
    }

    private void logDebugMessage(Throwable throwable, String message) {
        if (null == throwable) {
            this.logger.debug((Object)message);
        } else {
            this.logger.debug((Object)message, throwable);
        }
    }

    private void logWarnMessage(Throwable throwable, String message) {
        if (null == throwable) {
            this.logger.warn((Object)message);
        } else {
            this.logger.warn((Object)message, throwable);
        }
    }

    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    @Override
    public void warn(String message) {
        if (this.isWarnEnabled()) {
            this.logMessage(Level.WARN, null, message);
        }
    }

    public void setEventProperties(String propertyName, String propertyValue) {
        MDC.put((String)propertyName, (Object)propertyValue);
    }

    @Override
    public void audit(String msg) {
        String hostName = "";
        try {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            hostName = "localhost";
        }
        String username = "unknown";
        String threadid = "unknown";
        try {
            threadid = Thread.currentThread().getId() + "";
            username = UserGroupInformation.getCurrentUser().getShortUserName();
        }
        catch (IOException e) {
            username = "unknown";
        }
        this.logger.log((Priority)AuditLevel.AUDIT, (Object)("[" + hostName + "]" + "[" + username + "]" + "[Thread-" + threadid + "]" + msg));
    }

    @Override
    public void statistic(String message) {
        this.logger.log((Priority)StatisticLevel.STATISTIC, (Object)message);
    }

    static enum Level {
        NONE(0),
        DEBUG(1),
        INFO(2),
        STATISTICS(3),
        ERROR(4),
        AUDIT(5),
        WARN(6);


        private Level(int level) {
        }
    }
}

