/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.common.logging.impl;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import org.apache.log4j.Logger;

public final class FileUtil {
    public static final String CARBON_PROPERTIES_FILE_PATH = "../../../conf/carbon.properties";
    private static final Logger LOG = Logger.getLogger((String)FileUtil.class.getName());
    private static Properties carbonProperties;

    private FileUtil() {
    }

    public static Properties getCarbonProperties() {
        if (null == carbonProperties) {
            FileUtil.loadProperties();
        }
        return carbonProperties;
    }

    public static void close(Closeable stream) {
        if (null != stream) {
            try {
                stream.close();
            }
            catch (IOException e) {
                LOG.error((Object)"Exception while closing the Log stream");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadProperties() {
        String property = System.getProperty("carbon.properties.filepath");
        if (null == property) {
            property = CARBON_PROPERTIES_FILE_PATH;
        }
        File file = new File(property);
        FileInputStream fis = null;
        try {
            if (file.exists()) {
                fis = new FileInputStream(file);
                carbonProperties = new Properties();
                carbonProperties.load(fis);
            }
        }
        catch (FileNotFoundException e) {
            LOG.error((Object)("Could not find carbon properties file in the path " + property));
        }
        catch (IOException e) {
            LOG.error((Object)("Error while reading carbon properties file in the path " + property));
        }
        finally {
            if (null != fis) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    LOG.error((Object)"Error while closing the file stream for carbon.properties");
                }
            }
        }
    }
}

