/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.datamap.bloom;

import java.math.BigDecimal;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;

public class DataConvertUtil {
    public static byte[] getRawBytes(byte[] lvData) {
        byte[] indexValue = new byte[lvData.length - 2];
        System.arraycopy(lvData, 2, indexValue, 0, lvData.length - 2);
        return indexValue;
    }

    public static byte[] getRawBytesForVarchar(byte[] lvData) {
        byte[] indexValue = new byte[lvData.length - 4];
        System.arraycopy(lvData, 4, indexValue, 0, lvData.length - 4);
        return indexValue;
    }

    public static Object getNullValueForMeasure(DataType dataType, int scale) {
        if (dataType == DataTypes.BOOLEAN) {
            return false;
        }
        if (dataType == DataTypes.BYTE) {
            return (byte)0;
        }
        if (dataType == DataTypes.SHORT) {
            return (short)0;
        }
        if (dataType == DataTypes.INT) {
            return 0;
        }
        if (dataType == DataTypes.LONG || dataType == DataTypes.TIMESTAMP) {
            return 0L;
        }
        if (dataType == DataTypes.DOUBLE) {
            return 0.0;
        }
        if (DataTypes.isDecimal((DataType)dataType)) {
            return BigDecimal.valueOf(0L, scale);
        }
        throw new IllegalArgumentException("unsupported data type: " + dataType);
    }
}

