/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.datamap.bloom;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.carbondata.common.annotations.InterfaceAudience;
import org.apache.carbondata.common.exceptions.sql.MalformedDataMapCommandException;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.cache.Cache;
import org.apache.carbondata.core.cache.CacheProvider;
import org.apache.carbondata.core.cache.CacheType;
import org.apache.carbondata.core.datamap.DataMapDistributable;
import org.apache.carbondata.core.datamap.DataMapLevel;
import org.apache.carbondata.core.datamap.DataMapMeta;
import org.apache.carbondata.core.datamap.Segment;
import org.apache.carbondata.core.datamap.dev.DataMapBuilder;
import org.apache.carbondata.core.datamap.dev.DataMapFactory;
import org.apache.carbondata.core.datamap.dev.DataMapWriter;
import org.apache.carbondata.core.datamap.dev.cgdatamap.CoarseGrainDataMap;
import org.apache.carbondata.core.datastore.block.SegmentProperties;
import org.apache.carbondata.core.datastore.filesystem.CarbonFile;
import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.carbondata.core.features.TableOperation;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.metadata.schema.table.DataMapSchema;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonColumn;
import org.apache.carbondata.core.scan.filter.intf.ExpressionType;
import org.apache.carbondata.core.statusmanager.SegmentStatusManager;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.core.util.path.CarbonTablePath;
import org.apache.carbondata.datamap.bloom.BloomCacheKeyValue;
import org.apache.carbondata.datamap.bloom.BloomCoarseGrainDataMap;
import org.apache.carbondata.datamap.bloom.BloomDataMapBuilder;
import org.apache.carbondata.datamap.bloom.BloomDataMapCache;
import org.apache.carbondata.datamap.bloom.BloomDataMapDistributable;
import org.apache.carbondata.datamap.bloom.BloomDataMapModel;
import org.apache.carbondata.datamap.bloom.BloomDataMapWriter;
import org.apache.carbondata.events.Event;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

@InterfaceAudience.Internal
public class BloomCoarseGrainDataMapFactory
extends DataMapFactory<CoarseGrainDataMap> {
    private static final Logger LOGGER = LogServiceFactory.getLogService((String)BloomCoarseGrainDataMapFactory.class.getName());
    private static final String BLOOM_SIZE = "bloom_size";
    private static final int DEFAULT_BLOOM_FILTER_SIZE = 640000;
    private static final String BLOOM_FPP = "bloom_fpp";
    private static final double DEFAULT_BLOOM_FILTER_FPP = 1.0E-5;
    private static final String COMPRESS_BLOOM = "bloom_compress";
    private static final boolean DEFAULT_BLOOM_COMPRESS = true;
    private DataMapMeta dataMapMeta;
    private String dataMapName;
    private int bloomFilterSize;
    private double bloomFilterFpp;
    private boolean bloomCompress;
    private Cache<BloomCacheKeyValue.CacheKey, BloomCacheKeyValue.CacheValue> cache;
    private Map<String, Set<String>> segmentMap = new ConcurrentHashMap<String, Set<String>>();

    public BloomCoarseGrainDataMapFactory(CarbonTable carbonTable, DataMapSchema dataMapSchema) throws MalformedDataMapCommandException {
        super(carbonTable, dataMapSchema);
        Objects.requireNonNull(carbonTable);
        Objects.requireNonNull(dataMapSchema);
        this.dataMapName = dataMapSchema.getDataMapName();
        List indexedColumns = carbonTable.getIndexedColumns(dataMapSchema);
        this.bloomFilterSize = this.validateAndGetBloomFilterSize(dataMapSchema);
        this.bloomFilterFpp = this.validateAndGetBloomFilterFpp(dataMapSchema);
        this.bloomCompress = this.validateAndGetBloomCompress(dataMapSchema);
        ArrayList<ExpressionType> optimizedOperations = new ArrayList<ExpressionType>();
        optimizedOperations.add(ExpressionType.EQUALS);
        optimizedOperations.add(ExpressionType.IN);
        this.dataMapMeta = new DataMapMeta(this.dataMapName, indexedColumns, optimizedOperations);
        LOGGER.info((Object)String.format("DataMap %s works for %s with bloom size %d", this.dataMapName, this.dataMapMeta, this.bloomFilterSize));
        try {
            this.cache = CacheProvider.getInstance().createCache(new CacheType("bloom_cache"), BloomDataMapCache.class.getName());
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw new MalformedDataMapCommandException(e.getMessage());
        }
    }

    private int validateAndGetBloomFilterSize(DataMapSchema dmSchema) throws MalformedDataMapCommandException {
        int bloomFilterSize;
        String bloomFilterSizeStr = (String)dmSchema.getProperties().get(BLOOM_SIZE);
        if (StringUtils.isBlank((CharSequence)bloomFilterSizeStr)) {
            LOGGER.warn((Object)String.format("Bloom filter size is not configured for datamap %s, use default value %d", this.dataMapName, 640000));
            return 640000;
        }
        try {
            bloomFilterSize = Integer.parseInt(bloomFilterSizeStr);
        }
        catch (NumberFormatException e) {
            throw new MalformedDataMapCommandException(String.format("Invalid value of bloom filter size '%s', it should be an integer", bloomFilterSizeStr));
        }
        if (bloomFilterSize <= 0) {
            throw new MalformedDataMapCommandException(String.format("Invalid value of bloom filter size '%s', it should be greater than 0", bloomFilterSizeStr));
        }
        return bloomFilterSize;
    }

    private double validateAndGetBloomFilterFpp(DataMapSchema dmSchema) throws MalformedDataMapCommandException {
        double bloomFilterFpp;
        String bloomFilterFppStr = (String)dmSchema.getProperties().get(BLOOM_FPP);
        if (StringUtils.isBlank((CharSequence)bloomFilterFppStr)) {
            LOGGER.warn((Object)String.format("Bloom filter FPP is not configured for datamap %s, use default value %f", this.dataMapName, 1.0E-5));
            return 1.0E-5;
        }
        try {
            bloomFilterFpp = Double.parseDouble(bloomFilterFppStr);
        }
        catch (NumberFormatException e) {
            throw new MalformedDataMapCommandException(String.format("Invalid value of bloom filter fpp '%s', it should be an numeric", bloomFilterFppStr));
        }
        if (bloomFilterFpp < 0.0 || bloomFilterFpp - 1.0 >= 0.0) {
            throw new MalformedDataMapCommandException(String.format("Invalid value of bloom filter fpp '%s', it should be in range 0~1", bloomFilterFppStr));
        }
        return bloomFilterFpp;
    }

    private boolean validateAndGetBloomCompress(DataMapSchema dmSchema) {
        String bloomCompress = (String)dmSchema.getProperties().get(COMPRESS_BLOOM);
        if (StringUtils.isBlank((CharSequence)bloomCompress)) {
            LOGGER.warn((Object)String.format("Bloom compress is not configured for datamap %s, use default value %b", this.dataMapName, true));
            return true;
        }
        return Boolean.parseBoolean(bloomCompress);
    }

    public DataMapWriter createWriter(Segment segment, String shardName, SegmentProperties segmentProperties) throws IOException {
        LOGGER.info((Object)String.format("Data of BloomCoarseGranDataMap %s for table %s will be written to %s", this.dataMapName, this.getCarbonTable().getTableName(), shardName));
        return new BloomDataMapWriter(this.getCarbonTable().getTablePath(), this.dataMapName, this.dataMapMeta.getIndexedColumns(), segment, shardName, segmentProperties, this.bloomFilterSize, this.bloomFilterFpp, this.bloomCompress);
    }

    public DataMapBuilder createBuilder(Segment segment, String shardName, SegmentProperties segmentProperties) throws IOException {
        return new BloomDataMapBuilder(this.getCarbonTable().getTablePath(), this.dataMapName, this.dataMapMeta.getIndexedColumns(), segment, shardName, segmentProperties, this.bloomFilterSize, this.bloomFilterFpp, this.bloomCompress);
    }

    public static Set<String> getAllShardPaths(String tablePath, String segmentId, String dataMapName) {
        String dataMapStorePath = CarbonTablePath.getDataMapStorePath((String)tablePath, (String)segmentId, (String)dataMapName);
        CarbonFile[] carbonFiles = FileFactory.getCarbonFile((String)dataMapStorePath).listFiles();
        HashSet<String> shardPaths = new HashSet<String>();
        boolean mergeShardInprogress = false;
        CarbonFile mergeShardFile = null;
        for (CarbonFile carbonFile : carbonFiles) {
            if (carbonFile.getName().equals("mergeShard")) {
                mergeShardFile = carbonFile;
                continue;
            }
            if (carbonFile.getName().equals("mergeShard.inprogress")) {
                mergeShardInprogress = true;
                continue;
            }
            if (!carbonFile.isDirectory()) continue;
            shardPaths.add(FileFactory.getPath((String)carbonFile.getAbsolutePath()).toString());
        }
        if (mergeShardFile != null && !mergeShardInprogress) {
            shardPaths.clear();
            shardPaths.add(FileFactory.getPath((String)mergeShardFile.getAbsolutePath()).toString());
        }
        return shardPaths;
    }

    public List<CoarseGrainDataMap> getDataMaps(Segment segment) throws IOException {
        ArrayList<CoarseGrainDataMap> dataMaps = new ArrayList<CoarseGrainDataMap>();
        try {
            Set<String> shardPaths = this.segmentMap.get(segment.getSegmentNo());
            if (shardPaths == null) {
                shardPaths = BloomCoarseGrainDataMapFactory.getAllShardPaths(this.getCarbonTable().getTablePath(), segment.getSegmentNo(), this.dataMapName);
                this.segmentMap.put(segment.getSegmentNo(), shardPaths);
            }
            Set filteredShards = segment.getFilteredIndexShardNames();
            for (String shard : shardPaths) {
                if (!shard.endsWith("mergeShard") && !filteredShards.contains(new File(shard).getName())) continue;
                BloomCoarseGrainDataMap bloomDM = new BloomCoarseGrainDataMap();
                bloomDM.init(new BloomDataMapModel(shard, this.cache, segment.getConfiguration()));
                bloomDM.initIndexColumnConverters(this.getCarbonTable(), this.dataMapMeta.getIndexedColumns());
                bloomDM.setFilteredShard(filteredShards);
                dataMaps.add(bloomDM);
            }
        }
        catch (Exception e) {
            throw new IOException("Error occurs while init Bloom DataMap", e);
        }
        return dataMaps;
    }

    public List<CoarseGrainDataMap> getDataMaps(DataMapDistributable distributable) throws IOException {
        ArrayList<CoarseGrainDataMap> dataMaps = new ArrayList<CoarseGrainDataMap>();
        String indexPath = ((BloomDataMapDistributable)distributable).getIndexPath();
        Set<String> filteredShards = ((BloomDataMapDistributable)distributable).getFilteredShards();
        BloomCoarseGrainDataMap bloomDM = new BloomCoarseGrainDataMap();
        bloomDM.init(new BloomDataMapModel(indexPath, this.cache, FileFactory.getConfiguration()));
        bloomDM.initIndexColumnConverters(this.getCarbonTable(), this.dataMapMeta.getIndexedColumns());
        bloomDM.setFilteredShard(filteredShards);
        dataMaps.add(bloomDM);
        return dataMaps;
    }

    public List<DataMapDistributable> toDistributable(Segment segment) {
        ArrayList<DataMapDistributable> dataMapDistributableList = new ArrayList<DataMapDistributable>();
        Set<String> shardPaths = this.segmentMap.get(segment.getSegmentNo());
        if (shardPaths == null) {
            shardPaths = BloomCoarseGrainDataMapFactory.getAllShardPaths(this.getCarbonTable().getTablePath(), segment.getSegmentNo(), this.dataMapName);
            this.segmentMap.put(segment.getSegmentNo(), shardPaths);
        }
        Set filteredShards = segment.getFilteredIndexShardNames();
        for (String shardPath : shardPaths) {
            if (!shardPath.endsWith("mergeShard") && !filteredShards.contains(new File(shardPath).getName())) continue;
            BloomDataMapDistributable bloomDataMapDistributable = new BloomDataMapDistributable(shardPath, filteredShards);
            bloomDataMapDistributable.setSegment(segment);
            bloomDataMapDistributable.setDataMapSchema(this.getDataMapSchema());
            dataMapDistributableList.add(bloomDataMapDistributable);
        }
        return dataMapDistributableList;
    }

    public void fireEvent(Event event) {
    }

    public void clear(String segment) {
        Set<String> shards = this.segmentMap.remove(segment);
        if (shards != null) {
            for (String shard : shards) {
                for (CarbonColumn carbonColumn : this.dataMapMeta.getIndexedColumns()) {
                    this.cache.invalidate((Object)new BloomCacheKeyValue.CacheKey(shard, carbonColumn.getColName()));
                }
            }
        }
    }

    public synchronized void clear() {
        if (this.segmentMap.size() > 0) {
            ArrayList<String> segments = new ArrayList<String>(this.segmentMap.keySet());
            for (String segmentId : segments) {
                this.clear(segmentId);
            }
        }
    }

    public void deleteDatamapData(Segment segment) throws IOException {
        this.deleteSegmentDatamapData(segment.getSegmentNo());
    }

    public void deleteSegmentDatamapData(String segmentId) throws IOException {
        try {
            String datamapPath = CarbonTablePath.getDataMapStorePath((String)this.getCarbonTable().getTablePath(), (String)segmentId, (String)this.dataMapName);
            if (FileFactory.isFileExist((String)datamapPath)) {
                CarbonFile file = FileFactory.getCarbonFile((String)datamapPath, (FileFactory.FileType)FileFactory.getFileType((String)datamapPath));
                CarbonUtil.deleteFoldersAndFilesSilent((CarbonFile[])new CarbonFile[]{file});
            }
            this.clear(segmentId);
        }
        catch (InterruptedException ex) {
            throw new IOException("Failed to delete datamap for segment_" + segmentId);
        }
    }

    public void deleteDatamapData() {
        SegmentStatusManager ssm = new SegmentStatusManager(this.getCarbonTable().getAbsoluteTableIdentifier());
        try {
            List validSegments = ssm.getValidAndInvalidSegments(Boolean.valueOf(this.getCarbonTable().isChildTable())).getValidSegments();
            for (Segment segment : validSegments) {
                this.deleteDatamapData(segment);
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)"drop datamap failed, failed to delete datamap directory");
        }
    }

    public boolean willBecomeStale(TableOperation operation) {
        switch (operation) {
            case ALTER_RENAME: {
                return false;
            }
            case ALTER_DROP: {
                return true;
            }
            case ALTER_ADD_COLUMN: {
                return false;
            }
            case ALTER_CHANGE_DATATYPE: {
                return true;
            }
            case ALTER_COLUMN_RENAME: {
                return true;
            }
            case STREAMING: {
                return false;
            }
            case DELETE: {
                return true;
            }
            case UPDATE: {
                return true;
            }
            case PARTITION: {
                return true;
            }
        }
        return false;
    }

    public boolean isOperationBlocked(TableOperation operation, Object ... targets) {
        switch (operation) {
            case ALTER_DROP: {
                List columnsToDrop = (List)targets[0];
                List indexedColumnNames = this.dataMapMeta.getIndexedColumnNames();
                for (String indexedcolumn : indexedColumnNames) {
                    for (String column : columnsToDrop) {
                        if (!column.equalsIgnoreCase(indexedcolumn)) continue;
                        return true;
                    }
                }
                return false;
            }
            case ALTER_CHANGE_DATATYPE: 
            case ALTER_COLUMN_RENAME: {
                String columnToChangeDatatype = (String)targets[0];
                List indexedColumnNames = this.dataMapMeta.getIndexedColumnNames();
                for (String indexedcolumn : indexedColumnNames) {
                    if (!indexedcolumn.equalsIgnoreCase(columnToChangeDatatype)) continue;
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    public DataMapMeta getMeta() {
        return this.dataMapMeta;
    }

    public DataMapLevel getDataMapLevel() {
        return DataMapLevel.CG;
    }

    public String getCacheSize() {
        long sum = 0L;
        for (Map.Entry<String, Set<String>> entry : this.segmentMap.entrySet()) {
            for (String shardName : entry.getValue()) {
                for (CarbonColumn carbonColumn : this.dataMapMeta.getIndexedColumns()) {
                    BloomCacheKeyValue.CacheValue cacheValue = (BloomCacheKeyValue.CacheValue)this.cache.getIfPresent((Object)new BloomCacheKeyValue.CacheKey(shardName, carbonColumn.getColName()));
                    if (cacheValue == null) continue;
                    sum += cacheValue.getMemorySize();
                }
            }
        }
        return "0:" + sum;
    }
}

