/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.datamap.bloom;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.carbondata.common.annotations.InterfaceAudience;
import org.apache.carbondata.core.datamap.Segment;
import org.apache.carbondata.core.datastore.block.SegmentProperties;
import org.apache.carbondata.core.keygenerator.columnar.ColumnarSplitter;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonColumn;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonDimension;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.core.util.DataTypeUtil;
import org.apache.carbondata.datamap.bloom.AbstractBloomDataMapWriter;
import org.apache.carbondata.datamap.bloom.DataConvertUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;

@InterfaceAudience.Internal
public class BloomDataMapWriter
extends AbstractBloomDataMapWriter {
    private ColumnarSplitter columnarSplitter;
    private Map<String, Integer> indexCol2MdkIdx;

    BloomDataMapWriter(String tablePath, String dataMapName, List<CarbonColumn> indexColumns, Segment segment, String shardName, SegmentProperties segmentProperties, int bloomFilterSize, double bloomFilterFpp, boolean compressBloom) throws IOException {
        super(tablePath, dataMapName, indexColumns, segment, shardName, segmentProperties, bloomFilterSize, bloomFilterFpp, compressBloom);
        this.columnarSplitter = segmentProperties.getFixedLengthKeySplitter();
        this.indexCol2MdkIdx = new HashMap<String, Integer>();
        int idx = 0;
        for (final CarbonDimension dimension : segmentProperties.getDimensions()) {
            if (!dimension.isGlobalDictionaryEncoding() && !dimension.isDirectDictionaryEncoding()) continue;
            boolean isExistInIndex = CollectionUtils.exists(indexColumns, (Predicate)new Predicate(){

                public boolean evaluate(Object object) {
                    return ((CarbonColumn)object).getColName().equalsIgnoreCase(dimension.getColName());
                }
            });
            if (isExistInIndex) {
                this.indexCol2MdkIdx.put(dimension.getColName(), idx);
            }
            ++idx;
        }
    }

    @Override
    protected byte[] convertNonDictionaryValue(int indexColIdx, Object value) {
        if (DataTypes.VARCHAR == ((CarbonColumn)this.indexColumns.get(indexColIdx)).getDataType()) {
            return DataConvertUtil.getRawBytesForVarchar((byte[])value);
        }
        if (DataTypeUtil.isPrimitiveColumn((DataType)((CarbonColumn)this.indexColumns.get(indexColIdx)).getDataType())) {
            return CarbonUtil.getValueAsBytes((DataType)((CarbonColumn)this.indexColumns.get(indexColIdx)).getDataType(), (Object)value);
        }
        return DataConvertUtil.getRawBytes((byte[])value);
    }

    @Override
    protected byte[] convertDictionaryValue(int indexColIdx, Object value) {
        int thisKeyIdx = this.indexCol2MdkIdx.get(((CarbonColumn)this.indexColumns.get(indexColIdx)).getColName());
        int surrogateKey = CarbonUtil.getSurrogateInternal((byte[])((byte[])value), (int)0, (int)this.columnarSplitter.getBlockKeySize()[thisKeyIdx]);
        return CarbonUtil.getValueAsBytes((DataType)DataTypes.INT, (Object)surrogateKey);
    }
}

