/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.datamap.bloom;

import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.carbondata.common.annotations.InterfaceAudience;
import org.apache.carbondata.core.constants.CarbonCommonConstants;
import org.apache.carbondata.core.datamap.Segment;
import org.apache.carbondata.core.datamap.dev.DataMapWriter;
import org.apache.carbondata.core.datastore.block.SegmentProperties;
import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.carbondata.core.datastore.page.ColumnPage;
import org.apache.carbondata.core.datastore.page.encoding.bool.BooleanConvert;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.metadata.encoder.Encoding;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonColumn;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.datamap.bloom.BloomIndexFileStore;
import org.apache.hadoop.util.bloom.CarbonBloomFilter;
import org.apache.hadoop.util.bloom.Key;

@InterfaceAudience.Internal
public abstract class AbstractBloomDataMapWriter
extends DataMapWriter {
    private int bloomFilterSize;
    private double bloomFilterFpp;
    private boolean compressBloom;
    protected int currentBlockletId;
    private List<String> currentDMFiles;
    private List<DataOutputStream> currentDataOutStreams;
    protected List<CarbonBloomFilter> indexBloomFilters;

    AbstractBloomDataMapWriter(String tablePath, String dataMapName, List<CarbonColumn> indexColumns, Segment segment, String shardName, SegmentProperties segmentProperties, int bloomFilterSize, double bloomFilterFpp, boolean compressBloom) throws IOException {
        super(tablePath, dataMapName, indexColumns, segment, shardName);
        this.bloomFilterSize = bloomFilterSize;
        this.bloomFilterFpp = bloomFilterFpp;
        this.compressBloom = compressBloom;
        this.currentDMFiles = new ArrayList<String>(indexColumns.size());
        this.currentDataOutStreams = new ArrayList<DataOutputStream>(indexColumns.size());
        this.indexBloomFilters = new ArrayList<CarbonBloomFilter>(indexColumns.size());
        this.initDataMapFile();
        this.resetBloomFilters();
    }

    public void onBlockStart(String blockId) throws IOException {
    }

    public void onBlockEnd(String blockId) throws IOException {
    }

    public void onBlockletStart(int blockletId) {
    }

    protected void resetBloomFilters() {
        this.indexBloomFilters.clear();
        int[] stats = this.calculateBloomStats();
        for (int i = 0; i < this.indexColumns.size(); ++i) {
            this.indexBloomFilters.add(new CarbonBloomFilter(stats[0], stats[1], 1, this.compressBloom));
        }
    }

    private int[] calculateBloomStats() {
        double sizeinBits = (double)(-this.bloomFilterSize) * Math.log(this.bloomFilterFpp) / Math.pow(Math.log(2.0), 2.0);
        double numberOfHashes = sizeinBits / (double)this.bloomFilterSize * Math.log(2.0);
        int[] stats = new int[]{(int)Math.ceil(sizeinBits), (int)Math.ceil(numberOfHashes)};
        return stats;
    }

    public void onBlockletEnd(int blockletId) {
        this.writeBloomDataMapFile();
        ++this.currentBlockletId;
    }

    public void onPageAdded(int blockletId, int pageId, int pageSize, ColumnPage[] pages) throws IOException {
        for (int rowId = 0; rowId < pageSize; ++rowId) {
            for (int i = 0; i < this.indexColumns.size(); ++i) {
                Object data = pages[i].getData(rowId);
                this.addValue2BloomIndex(i, data);
            }
        }
    }

    protected void addValue2BloomIndex(int indexColIdx, Object value) {
        byte[] indexValue;
        if (((CarbonColumn)this.indexColumns.get(indexColIdx)).isMeasure().booleanValue()) {
            if (((CarbonColumn)this.indexColumns.get(indexColIdx)).getDataType().equals((Object)DataTypes.BOOLEAN)) {
                value = BooleanConvert.boolean2Byte((boolean)((Boolean)value));
            }
            indexValue = CarbonUtil.getValueAsBytes((DataType)((CarbonColumn)this.indexColumns.get(indexColIdx)).getDataType(), (Object)value);
        } else {
            indexValue = ((CarbonColumn)this.indexColumns.get(indexColIdx)).hasEncoding(Encoding.DICTIONARY) || ((CarbonColumn)this.indexColumns.get(indexColIdx)).hasEncoding(Encoding.DIRECT_DICTIONARY) ? this.convertDictionaryValue(indexColIdx, value) : this.convertNonDictionaryValue(indexColIdx, value);
        }
        if (indexValue.length == 0) {
            indexValue = CarbonCommonConstants.MEMBER_DEFAULT_VAL_ARRAY;
        }
        this.indexBloomFilters.get(indexColIdx).add(new Key(indexValue));
    }

    protected abstract byte[] convertDictionaryValue(int var1, Object var2);

    protected abstract byte[] convertNonDictionaryValue(int var1, Object var2);

    private void initDataMapFile() throws IOException {
        if (!FileFactory.isFileExist((String)this.dataMapPath) && !FileFactory.mkdirs((String)this.dataMapPath, (FileFactory.FileType)FileFactory.getFileType((String)this.dataMapPath))) {
            throw new IOException("Failed to create directory " + this.dataMapPath);
        }
        for (int indexColId = 0; indexColId < this.indexColumns.size(); ++indexColId) {
            String dmFile = BloomIndexFileStore.getBloomIndexFile(this.dataMapPath, ((CarbonColumn)this.indexColumns.get(indexColId)).getColName());
            DataOutputStream dataOutStream = null;
            try {
                FileFactory.createNewFile((String)dmFile, (FileFactory.FileType)FileFactory.getFileType((String)dmFile));
                dataOutStream = FileFactory.getDataOutputStream((String)dmFile, (FileFactory.FileType)FileFactory.getFileType((String)dmFile));
            }
            catch (IOException e) {
                CarbonUtil.closeStreams((Closeable[])new Closeable[]{dataOutStream});
                throw new IOException(e);
            }
            this.currentDMFiles.add(dmFile);
            this.currentDataOutStreams.add(dataOutStream);
        }
    }

    protected void writeBloomDataMapFile() {
        try {
            for (int indexColId = 0; indexColId < this.indexColumns.size(); ++indexColId) {
                CarbonBloomFilter bloomFilter = this.indexBloomFilters.get(indexColId);
                bloomFilter.setBlockletNo(this.currentBlockletId);
                bloomFilter.write(this.currentDataOutStreams.get(indexColId));
                this.currentDataOutStreams.get(indexColId).flush();
            }
        }
        catch (Exception e) {
            for (DataOutputStream dataOutputStream : this.currentDataOutStreams) {
                CarbonUtil.closeStreams((Closeable[])new Closeable[]{dataOutputStream});
            }
            throw new RuntimeException(e);
        }
        finally {
            this.resetBloomFilters();
        }
    }

    public void finish() throws IOException {
        if (!this.isWritingFinished()) {
            this.releaseResouce();
            this.setWritingFinished(true);
        }
    }

    protected void releaseResouce() {
        for (int indexColId = 0; indexColId < this.indexColumns.size(); ++indexColId) {
            CarbonUtil.closeStreams((Closeable[])new Closeable[]{this.currentDataOutStreams.get(indexColId)});
        }
    }
}

