/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.datamap.bloom;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.carbondata.common.annotations.InterfaceAudience;
import org.apache.carbondata.core.cache.Cache;
import org.apache.carbondata.core.cache.Cacheable;
import org.apache.carbondata.core.cache.CarbonLRUCache;
import org.apache.carbondata.core.memory.MemoryException;
import org.apache.carbondata.datamap.bloom.BloomCacheKeyValue;
import org.apache.carbondata.datamap.bloom.BloomIndexFileStore;
import org.apache.hadoop.util.bloom.CarbonBloomFilter;

@InterfaceAudience.Internal
public class BloomDataMapCache
implements Cache<BloomCacheKeyValue.CacheKey, BloomCacheKeyValue.CacheValue> {
    private CarbonLRUCache lruCache;

    public BloomDataMapCache(CarbonLRUCache lruCache) {
        this.lruCache = lruCache;
    }

    public BloomCacheKeyValue.CacheValue get(BloomCacheKeyValue.CacheKey key) throws IOException {
        BloomCacheKeyValue.CacheValue cacheValue = this.getIfPresent(key);
        if (cacheValue == null) {
            List<CarbonBloomFilter> bloomFilters = BloomIndexFileStore.loadBloomFilterFromFile(key.getShardPath(), key.getIndexColumn());
            cacheValue = new BloomCacheKeyValue.CacheValue(bloomFilters);
            this.lruCache.put(key.toString(), (Cacheable)cacheValue, cacheValue.getMemorySize());
        }
        return cacheValue;
    }

    public List<BloomCacheKeyValue.CacheValue> getAll(List<BloomCacheKeyValue.CacheKey> keys) throws IOException {
        ArrayList<BloomCacheKeyValue.CacheValue> cacheValues = new ArrayList<BloomCacheKeyValue.CacheValue>();
        for (BloomCacheKeyValue.CacheKey key : keys) {
            BloomCacheKeyValue.CacheValue cacheValue = this.get(key);
            cacheValues.add(cacheValue);
        }
        return cacheValues;
    }

    public BloomCacheKeyValue.CacheValue getIfPresent(BloomCacheKeyValue.CacheKey key) {
        return (BloomCacheKeyValue.CacheValue)this.lruCache.get(key.toString());
    }

    public void invalidate(BloomCacheKeyValue.CacheKey key) {
        this.lruCache.remove(key.toString());
    }

    public void put(BloomCacheKeyValue.CacheKey key, BloomCacheKeyValue.CacheValue value) throws IOException, MemoryException {
    }

    public void clearAccessCount(List<BloomCacheKeyValue.CacheKey> keys) {
    }
}

