/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.datamap.bloom;

import java.io.IOException;
import java.util.List;
import org.apache.carbondata.common.annotations.InterfaceAudience;
import org.apache.carbondata.core.datamap.Segment;
import org.apache.carbondata.core.datamap.dev.DataMapBuilder;
import org.apache.carbondata.core.datastore.block.SegmentProperties;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonColumn;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.core.util.DataTypeUtil;
import org.apache.carbondata.datamap.bloom.AbstractBloomDataMapWriter;

@InterfaceAudience.Internal
public class BloomDataMapBuilder
extends AbstractBloomDataMapWriter
implements DataMapBuilder {
    BloomDataMapBuilder(String tablePath, String dataMapName, List<CarbonColumn> indexColumns, Segment segment, String shardName, SegmentProperties segmentProperties, int bloomFilterSize, double bloomFilterFpp, boolean bloomCompress) throws IOException {
        super(tablePath, dataMapName, indexColumns, segment, shardName, segmentProperties, bloomFilterSize, bloomFilterFpp, bloomCompress);
    }

    public void initialize() throws IOException {
        super.resetBloomFilters();
    }

    public void addRow(int blockletId, int pageId, int rowId, Object[] values) {
        if (this.currentBlockletId != blockletId) {
            super.writeBloomDataMapFile();
            this.currentBlockletId = blockletId;
        }
        for (int i = 0; i < this.indexColumns.size(); ++i) {
            Object data = values[i];
            this.addValue2BloomIndex(i, data);
        }
    }

    @Override
    protected byte[] convertNonDictionaryValue(int indexColIdx, Object value) {
        if (DataTypeUtil.isPrimitiveColumn((DataType)((CarbonColumn)this.indexColumns.get(indexColIdx)).getDataType())) {
            return CarbonUtil.getValueAsBytes((DataType)((CarbonColumn)this.indexColumns.get(indexColIdx)).getDataType(), (Object)value);
        }
        return (byte[])value;
    }

    @Override
    public void finish() throws IOException {
        if (!this.isWritingFinished()) {
            if (this.indexBloomFilters.size() > 0) {
                this.writeBloomDataMapFile();
            }
            this.releaseResouce();
            this.setWritingFinished(true);
        }
    }

    @Override
    protected byte[] convertDictionaryValue(int indexColIdx, Object value) {
        return CarbonUtil.getValueAsBytes((DataType)DataTypes.INT, (Object)value);
    }

    public void close() throws IOException {
        this.releaseResouce();
    }

    public boolean isIndexForCarbonRawBytes() {
        return true;
    }
}

