/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.datamap.bloom;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.apache.carbondata.common.annotations.InterfaceAudience;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.datastore.filesystem.CarbonFile;
import org.apache.carbondata.core.datastore.filesystem.CarbonFileFilter;
import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.bloom.CarbonBloomFilter;
import org.apache.log4j.Logger;

@InterfaceAudience.Internal
public class BloomIndexFileStore {
    private static final Logger LOGGER = LogServiceFactory.getLogService((String)BloomIndexFileStore.class.getName());
    public static final String BLOOM_INDEX_SUFFIX = ".bloomindex";
    public static final String MERGE_BLOOM_INDEX_SUFFIX = ".bloomindexmerge";
    public static final String MERGE_BLOOM_INDEX_SHARD_NAME = "mergeShard";
    public static final String MERGE_INPROGRESS_FILE = "mergeShard.inprogress";

    public static void mergeBloomIndexFile(String dmSegmentPathString, List<String> indexCols) {
        CarbonFile segmentPath = FileFactory.getCarbonFile((String)dmSegmentPathString, (FileFactory.FileType)FileFactory.getFileType((String)dmSegmentPathString));
        CarbonFile[] shardPaths = segmentPath.listFiles(new CarbonFileFilter(){

            public boolean accept(CarbonFile file) {
                return file.isDirectory() && !file.getName().equals(BloomIndexFileStore.MERGE_BLOOM_INDEX_SHARD_NAME);
            }
        });
        String mergeShardPath = dmSegmentPathString + File.separator + MERGE_BLOOM_INDEX_SHARD_NAME;
        String mergeInprogressFile = dmSegmentPathString + File.separator + MERGE_INPROGRESS_FILE;
        try {
            if (FileFactory.isFileExist((String)mergeShardPath)) {
                FileFactory.deleteFile((String)mergeShardPath, (FileFactory.FileType)FileFactory.getFileType((String)mergeShardPath));
            }
            if (!FileFactory.isFileExist((String)mergeInprogressFile)) {
                FileFactory.createNewFile((String)mergeInprogressFile, (FileFactory.FileType)FileFactory.getFileType((String)mergeInprogressFile));
            }
            if (!FileFactory.mkdirs((String)mergeShardPath, (FileFactory.FileType)FileFactory.getFileType((String)mergeShardPath))) {
                throw new RuntimeException("Failed to create directory " + mergeShardPath);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        for (String indexCol : indexCols) {
            String mergeIndexFile = BloomIndexFileStore.getMergeBloomIndexFile(mergeShardPath, indexCol);
            DataInputStream dataInputStream = null;
            DataOutputStream dataOutputStream = null;
            try {
                FileFactory.createNewFile((String)mergeIndexFile, (FileFactory.FileType)FileFactory.getFileType((String)mergeIndexFile));
                dataOutputStream = FileFactory.getDataOutputStream((String)mergeIndexFile, (FileFactory.FileType)FileFactory.getFileType((String)mergeIndexFile));
                for (CarbonFile shardPath : shardPaths) {
                    String bloomIndexFile = BloomIndexFileStore.getBloomIndexFile(shardPath.getCanonicalPath(), indexCol);
                    dataInputStream = FileFactory.getDataInputStream((String)bloomIndexFile, (FileFactory.FileType)FileFactory.getFileType((String)bloomIndexFile));
                    byte[] fileData = new byte[(int)FileFactory.getCarbonFile((String)bloomIndexFile).getSize()];
                    dataInputStream.readFully(fileData);
                    byte[] shardName = shardPath.getName().getBytes(Charset.forName("UTF-8"));
                    dataOutputStream.writeInt(shardName.length);
                    dataOutputStream.write(shardName);
                    dataOutputStream.writeInt(fileData.length);
                    dataOutputStream.write(fileData);
                    CarbonUtil.closeStream((Closeable)dataInputStream);
                }
            }
            catch (IOException e) {
                try {
                    LOGGER.error((Object)("Error occurs while merge bloom index file of column: " + indexCol), (Throwable)e);
                    FileFactory.deleteAllCarbonFilesOfDir((CarbonFile)FileFactory.getCarbonFile((String)mergeShardPath));
                    FileFactory.deleteAllCarbonFilesOfDir((CarbonFile)FileFactory.getCarbonFile((String)mergeInprogressFile));
                    throw new RuntimeException("Error occurs while merge bloom index file of column: " + indexCol, e);
                }
                catch (Throwable throwable) {
                    CarbonUtil.closeStreams((Closeable[])new Closeable[]{dataInputStream, dataOutputStream});
                    throw throwable;
                }
            }
            CarbonUtil.closeStreams((Closeable[])new Closeable[]{dataInputStream, dataOutputStream});
        }
        try {
            FileFactory.deleteFile((String)mergeInprogressFile, (FileFactory.FileType)FileFactory.getFileType((String)mergeInprogressFile));
        }
        catch (IOException e) {
            LOGGER.error((Object)("Error occurs while deleting file " + mergeInprogressFile), (Throwable)e);
            throw new RuntimeException("Error occurs while deleting file " + mergeInprogressFile);
        }
        for (CarbonFile shardpath : shardPaths) {
            FileFactory.deleteAllCarbonFilesOfDir((CarbonFile)shardpath);
        }
    }

    public static List<CarbonBloomFilter> loadBloomFilterFromFile(String shardPath, String colName) {
        if (shardPath.endsWith(MERGE_BLOOM_INDEX_SHARD_NAME)) {
            return BloomIndexFileStore.loadMergeBloomIndex(shardPath, colName);
        }
        return BloomIndexFileStore.loadBloomIndex(shardPath, colName);
    }

    public static List<CarbonBloomFilter> loadBloomIndex(String shardPath, String colName) {
        ArrayList<CarbonBloomFilter> arrayList;
        DataInputStream dataInStream = null;
        ArrayList<CarbonBloomFilter> bloomFilters = new ArrayList<CarbonBloomFilter>();
        try {
            String indexFile = BloomIndexFileStore.getBloomIndexFile(shardPath, colName);
            dataInStream = FileFactory.getDataInputStream((String)indexFile, (FileFactory.FileType)FileFactory.getFileType((String)indexFile));
            while (dataInStream.available() > 0) {
                CarbonBloomFilter bloomFilter = new CarbonBloomFilter();
                bloomFilter.readFields(dataInStream);
                bloomFilter.setShardName(new Path(shardPath).getName());
                bloomFilters.add(bloomFilter);
            }
            LOGGER.info((Object)String.format("Read %d bloom indices from %s", bloomFilters.size(), indexFile));
            arrayList = bloomFilters;
        }
        catch (IOException e) {
            try {
                LOGGER.error((Object)"Error occurs while reading bloom index", (Throwable)e);
                throw new RuntimeException("Error occurs while reading bloom index", e);
            }
            catch (Throwable throwable) {
                CarbonUtil.closeStreams((Closeable[])new Closeable[]{dataInStream});
                throw throwable;
            }
        }
        CarbonUtil.closeStreams((Closeable[])new Closeable[]{dataInStream});
        return arrayList;
    }

    public static List<CarbonBloomFilter> loadMergeBloomIndex(String mergeShardPath, String colName) {
        ArrayList<CarbonBloomFilter> shardNameByteLength2;
        String mergeIndexFile = BloomIndexFileStore.getMergeBloomIndexFile(mergeShardPath, colName);
        DataInputStream mergeIndexInStream = null;
        ArrayList<CarbonBloomFilter> bloomFilters = new ArrayList<CarbonBloomFilter>();
        try {
            mergeIndexInStream = FileFactory.getDataInputStream((String)mergeIndexFile, (FileFactory.FileType)FileFactory.getFileType((String)mergeIndexFile));
            while (mergeIndexInStream.available() > 0) {
                int shardNameByteLength2 = mergeIndexInStream.readInt();
                byte[] shardNameBytes = new byte[shardNameByteLength2];
                mergeIndexInStream.readFully(shardNameBytes);
                String shardName = new String(shardNameBytes, Charset.forName("UTF-8"));
                int indexFileByteLength = mergeIndexInStream.readInt();
                byte[] indexFileBytes = new byte[indexFileByteLength];
                mergeIndexInStream.readFully(indexFileBytes);
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(indexFileBytes);
                DataInputStream indexDataInStream = new DataInputStream(byteArrayInputStream);
                while (indexDataInStream.available() > 0) {
                    CarbonBloomFilter bloomFilter = new CarbonBloomFilter();
                    bloomFilter.readFields(indexDataInStream);
                    bloomFilter.setShardName(shardName);
                    bloomFilters.add(bloomFilter);
                }
            }
            LOGGER.info((Object)String.format("Read %d bloom indices from %s", bloomFilters.size(), mergeIndexFile));
            shardNameByteLength2 = bloomFilters;
        }
        catch (IOException e) {
            try {
                LOGGER.error((Object)"Error occurs while reading merge bloom index", (Throwable)e);
                throw new RuntimeException("Error occurs while reading merge bloom index", e);
            }
            catch (Throwable throwable) {
                CarbonUtil.closeStreams((Closeable[])new Closeable[]{mergeIndexInStream});
                throw throwable;
            }
        }
        CarbonUtil.closeStreams((Closeable[])new Closeable[]{mergeIndexInStream});
        return shardNameByteLength2;
    }

    public static String getBloomIndexFile(String shardPath, String colName) {
        return shardPath.concat(File.separator).concat(colName).concat(BLOOM_INDEX_SUFFIX);
    }

    public static String getMergeBloomIndexFile(String mergeShardPath, String colName) {
        return mergeShardPath.concat(File.separator).concat(colName).concat(MERGE_BLOOM_INDEX_SUFFIX);
    }
}

