/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.datamap.bloom;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.carbondata.common.annotations.InterfaceAudience;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.cache.Cache;
import org.apache.carbondata.core.constants.CarbonCommonConstants;
import org.apache.carbondata.core.datamap.dev.DataMapModel;
import org.apache.carbondata.core.datamap.dev.cgdatamap.CoarseGrainDataMap;
import org.apache.carbondata.core.datastore.block.SegmentProperties;
import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.carbondata.core.datastore.page.encoding.bool.BooleanConvert;
import org.apache.carbondata.core.devapi.DictionaryGenerationException;
import org.apache.carbondata.core.indexstore.Blocklet;
import org.apache.carbondata.core.indexstore.PartitionSpec;
import org.apache.carbondata.core.metadata.AbsoluteTableIdentifier;
import org.apache.carbondata.core.metadata.CarbonMetadata;
import org.apache.carbondata.core.metadata.CarbonTableIdentifier;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.metadata.encoder.Encoding;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.metadata.schema.table.RelationIdentifier;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonColumn;
import org.apache.carbondata.core.scan.expression.ColumnExpression;
import org.apache.carbondata.core.scan.expression.Expression;
import org.apache.carbondata.core.scan.expression.LiteralExpression;
import org.apache.carbondata.core.scan.expression.conditional.EqualToExpression;
import org.apache.carbondata.core.scan.expression.conditional.InExpression;
import org.apache.carbondata.core.scan.expression.conditional.ListExpression;
import org.apache.carbondata.core.scan.expression.logical.AndExpression;
import org.apache.carbondata.core.scan.filter.resolver.FilterResolverIntf;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.core.util.DataTypeUtil;
import org.apache.carbondata.datamap.bloom.BloomCacheKeyValue;
import org.apache.carbondata.datamap.bloom.BloomDataMapModel;
import org.apache.carbondata.datamap.bloom.DataConvertUtil;
import org.apache.carbondata.processing.loading.DataField;
import org.apache.carbondata.processing.loading.converter.BadRecordLogHolder;
import org.apache.carbondata.processing.loading.converter.FieldConverter;
import org.apache.carbondata.processing.loading.converter.impl.FieldEncoderFactory;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.bloom.CarbonBloomFilter;
import org.apache.hadoop.util.bloom.Key;
import org.apache.log4j.Logger;

@InterfaceAudience.Internal
public class BloomCoarseGrainDataMap
extends CoarseGrainDataMap {
    private static final Logger LOGGER = LogServiceFactory.getLogService((String)BloomCoarseGrainDataMap.class.getName());
    private Map<String, CarbonColumn> name2Col;
    private Cache<BloomCacheKeyValue.CacheKey, BloomCacheKeyValue.CacheValue> cache;
    private String shardName;
    private Path indexPath;
    private Set<String> filteredShard;
    private boolean needShardPrune;
    private Map<String, FieldConverter> name2Converters;
    private BadRecordLogHolder badRecordLogHolder;

    public void init(DataMapModel dataMapModel) throws IOException {
        this.indexPath = FileFactory.getPath((String)dataMapModel.getFilePath());
        this.shardName = this.indexPath.getName();
        if (dataMapModel instanceof BloomDataMapModel) {
            BloomDataMapModel model = (BloomDataMapModel)dataMapModel;
            this.cache = model.getCache();
        }
    }

    public void setFilteredShard(Set<String> filteredShard) {
        this.filteredShard = filteredShard;
        this.needShardPrune = filteredShard != null && this.shardName.equals("mergeShard");
    }

    public void initIndexColumnConverters(CarbonTable carbonTable, List<CarbonColumn> indexedColumn) {
        this.name2Col = new HashMap<String, CarbonColumn>(indexedColumn.size());
        for (CarbonColumn col : indexedColumn) {
            this.name2Col.put(col.getColName(), col);
        }
        String parentTablePath = this.getAncestorTablePath(carbonTable);
        try {
            this.name2Converters = new HashMap<String, FieldConverter>(indexedColumn.size());
            AbsoluteTableIdentifier absoluteTableIdentifier = AbsoluteTableIdentifier.from((String)carbonTable.getTablePath(), (CarbonTableIdentifier)carbonTable.getCarbonTableIdentifier());
            String nullFormat = "\\N";
            Map[] localCaches = new Map[indexedColumn.size()];
            for (int i = 0; i < indexedColumn.size(); ++i) {
                localCaches[i] = new ConcurrentHashMap();
                DataField dataField = new DataField(indexedColumn.get(i));
                String dateFormat = CarbonProperties.getInstance().getProperty("carbon.date.format", "yyyy-MM-dd");
                dataField.setDateFormat(dateFormat);
                String tsFormat = CarbonProperties.getInstance().getProperty("carbon.timestamp.format", "yyyy-MM-dd HH:mm:ss");
                dataField.setTimestampFormat(tsFormat);
                FieldConverter fieldConverter = FieldEncoderFactory.getInstance().createFieldEncoder(dataField, absoluteTableIdentifier, i, nullFormat, null, Boolean.valueOf(false), localCaches[i], false, parentTablePath, false);
                this.name2Converters.put(indexedColumn.get(i).getColName(), fieldConverter);
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)"Exception occurs while init index columns", (Throwable)e);
            throw new RuntimeException(e);
        }
        this.badRecordLogHolder = new BadRecordLogHolder();
        this.badRecordLogHolder.setLogged(false);
    }

    private String getAncestorTablePath(CarbonTable currentTable) {
        if (!currentTable.isChildDataMap()) {
            return currentTable.getTablePath();
        }
        RelationIdentifier parentIdentifier = (RelationIdentifier)currentTable.getTableInfo().getParentRelationIdentifiers().get(0);
        CarbonTable parentTable = CarbonMetadata.getInstance().getCarbonTable(parentIdentifier.getDatabaseName(), parentIdentifier.getTableName());
        return this.getAncestorTablePath(parentTable);
    }

    public List<Blocklet> prune(FilterResolverIntf filterExp, SegmentProperties segmentProperties, List<PartitionSpec> partitions) throws IOException {
        List<BloomQueryModel> bloomQueryModels;
        HashSet<Blocklet> hitBlocklets = null;
        if (filterExp == null) {
            return null;
        }
        if (this.filteredShard.isEmpty()) {
            LOGGER.info((Object)"Bloom filtered shards is empty");
            return new ArrayList<Blocklet>();
        }
        try {
            bloomQueryModels = this.createQueryModel(filterExp.getFilterExpression());
        }
        catch (UnsupportedEncodingException | DictionaryGenerationException e) {
            LOGGER.error((Object)"Exception occurs while creating query model", e);
            throw new RuntimeException(e);
        }
        for (BloomQueryModel bloomQueryModel : bloomQueryModels) {
            HashSet<Blocklet> tempHitBlockletsResult = new HashSet<Blocklet>();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("prune blocklet for query: " + bloomQueryModel));
            }
            BloomCacheKeyValue.CacheKey cacheKey = new BloomCacheKeyValue.CacheKey(this.indexPath.toString(), bloomQueryModel.columnName);
            BloomCacheKeyValue.CacheValue cacheValue = (BloomCacheKeyValue.CacheValue)this.cache.get((Object)cacheKey);
            List<CarbonBloomFilter> bloomIndexList = cacheValue.getBloomFilters();
            for (CarbonBloomFilter bloomFilter : bloomIndexList) {
                byte[] value;
                if (this.needShardPrune && !this.filteredShard.contains(bloomFilter.getShardName())) continue;
                boolean scanRequired = false;
                Iterator iterator = bloomQueryModel.filterValues.iterator();
                while (iterator.hasNext() && !(scanRequired = bloomFilter.membershipTest(new Key(value = (byte[])iterator.next())))) {
                }
                if (scanRequired) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)String.format("BloomCoarseGrainDataMap: Need to scan -> blocklet#%s", String.valueOf(bloomFilter.getBlockletNo())));
                    }
                    Blocklet blocklet = new Blocklet(bloomFilter.getShardName(), String.valueOf(bloomFilter.getBlockletNo()));
                    tempHitBlockletsResult.add(blocklet);
                } else if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)String.format("BloomCoarseGrainDataMap: Skip scan -> blocklet#%s", String.valueOf(bloomFilter.getBlockletNo())));
                }
                if (null == hitBlocklets) {
                    hitBlocklets = tempHitBlockletsResult;
                    continue;
                }
                hitBlocklets.retainAll(tempHitBlockletsResult);
            }
        }
        if (hitBlocklets == null) {
            LOGGER.warn((Object)String.format("HitBlocklets is empty in bloom filter prune method. bloomQueryModels size is %d, filterShards size if %d", bloomQueryModels.size(), this.filteredShard.size()));
            return null;
        }
        return new ArrayList<Blocklet>(hitBlocklets);
    }

    private List<BloomQueryModel> createQueryModel(Expression expression) throws DictionaryGenerationException, UnsupportedEncodingException {
        ArrayList<BloomQueryModel> queryModels = new ArrayList<BloomQueryModel>();
        if (expression instanceof EqualToExpression) {
            Expression left = ((EqualToExpression)expression).getLeft();
            Expression right = ((EqualToExpression)expression).getRight();
            if (left instanceof ColumnExpression && right instanceof LiteralExpression) {
                String column = ((ColumnExpression)left).getColumnName();
                if (this.name2Col.containsKey(column)) {
                    BloomQueryModel bloomQueryModel = this.buildQueryModelForEqual((ColumnExpression)left, (LiteralExpression)right);
                    queryModels.add(bloomQueryModel);
                }
                return queryModels;
            }
            if (left instanceof LiteralExpression && right instanceof ColumnExpression) {
                String column = ((ColumnExpression)right).getColumnName();
                if (this.name2Col.containsKey(column)) {
                    BloomQueryModel bloomQueryModel = this.buildQueryModelForEqual((ColumnExpression)right, (LiteralExpression)left);
                    queryModels.add(bloomQueryModel);
                }
                return queryModels;
            }
            String errorMsg = "BloomFilter can only support the 'equal' filter like 'Col = PlainValue'";
            LOGGER.warn((Object)errorMsg);
            throw new RuntimeException(errorMsg);
        }
        if (expression instanceof InExpression) {
            Expression left = ((InExpression)expression).getLeft();
            Expression right = ((InExpression)expression).getRight();
            if (left instanceof ColumnExpression && right instanceof ListExpression) {
                String column = ((ColumnExpression)left).getColumnName();
                if (this.name2Col.containsKey(column)) {
                    BloomQueryModel bloomQueryModel = this.buildQueryModelForIn((ColumnExpression)left, (ListExpression)right);
                    queryModels.add(bloomQueryModel);
                }
                return queryModels;
            }
            if (left instanceof ListExpression && right instanceof ColumnExpression) {
                String column = ((ColumnExpression)right).getColumnName();
                if (this.name2Col.containsKey(column)) {
                    BloomQueryModel bloomQueryModel = this.buildQueryModelForIn((ColumnExpression)right, (ListExpression)left);
                    queryModels.add(bloomQueryModel);
                }
                return queryModels;
            }
            String errorMsg = "BloomFilter can only support the 'in' filter like 'Col in PlainValue'";
            LOGGER.warn((Object)errorMsg);
            throw new RuntimeException(errorMsg);
        }
        if (expression instanceof AndExpression) {
            queryModels.addAll(this.createQueryModel(((AndExpression)expression).getLeft()));
            queryModels.addAll(this.createQueryModel(((AndExpression)expression).getRight()));
            return queryModels;
        }
        return queryModels;
    }

    private Object getLiteralExpValue(LiteralExpression le) {
        Object literalValue;
        Object expressionValue = le.getLiteralExpValue();
        if (null == expressionValue) {
            literalValue = null;
        } else if (le.getLiteralExpDataType() == DataTypes.DATE) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            format.setLenient(false);
            format.setTimeZone(TimeZone.getTimeZone("GMT"));
            literalValue = format.format(new Date((Long)expressionValue / 1000L));
        } else if (le.getLiteralExpDataType() == DataTypes.TIMESTAMP) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            format.setLenient(false);
            literalValue = format.format(new Date((Long)expressionValue / 1000L));
        } else {
            literalValue = expressionValue;
        }
        return literalValue;
    }

    private BloomQueryModel buildQueryModelForEqual(ColumnExpression ce, LiteralExpression le) throws DictionaryGenerationException, UnsupportedEncodingException {
        ArrayList<byte[]> filterValues = new ArrayList<byte[]>();
        byte[] internalFilterValue = this.getInternalFilterValue(this.name2Col.get(ce.getColumnName()), le);
        filterValues.add(internalFilterValue);
        return new BloomQueryModel(ce.getColumnName(), filterValues);
    }

    private BloomQueryModel buildQueryModelForIn(ColumnExpression ce, ListExpression le) throws DictionaryGenerationException, UnsupportedEncodingException {
        ArrayList<byte[]> filterValues = new ArrayList<byte[]>();
        for (Expression child : le.getChildren()) {
            byte[] internalFilterValue = this.getInternalFilterValue(this.name2Col.get(ce.getColumnName()), (LiteralExpression)child);
            filterValues.add(internalFilterValue);
        }
        return new BloomQueryModel(ce.getColumnName(), filterValues);
    }

    private byte[] getInternalFilterValue(CarbonColumn carbonColumn, LiteralExpression le) throws DictionaryGenerationException, UnsupportedEncodingException {
        byte[] internalFilterValue;
        Object filterLiteralValue = this.getLiteralExpValue(le);
        String strFilterValue = null;
        if (null != filterLiteralValue) {
            strFilterValue = String.valueOf(filterLiteralValue);
        }
        Object convertedValue = this.name2Converters.get(carbonColumn.getColName()).convert((Object)strFilterValue, this.badRecordLogHolder);
        if (carbonColumn.isMeasure().booleanValue()) {
            if (convertedValue == null) {
                convertedValue = DataConvertUtil.getNullValueForMeasure(carbonColumn.getDataType(), carbonColumn.getColumnSchema().getScale());
            }
            if (carbonColumn.getDataType().equals((Object)DataTypes.BOOLEAN)) {
                convertedValue = BooleanConvert.boolean2Byte((boolean)((Boolean)convertedValue));
            }
            internalFilterValue = CarbonUtil.getValueAsBytes((DataType)carbonColumn.getDataType(), (Object)convertedValue);
        } else if (carbonColumn.hasEncoding(Encoding.DIRECT_DICTIONARY) || carbonColumn.hasEncoding(Encoding.DICTIONARY)) {
            internalFilterValue = CarbonUtil.getValueAsBytes((DataType)DataTypes.INT, (Object)convertedValue);
        } else if (DataTypeUtil.isPrimitiveColumn((DataType)carbonColumn.getDataType())) {
            if (convertedValue == null) {
                convertedValue = DataConvertUtil.getNullValueForMeasure(carbonColumn.getDataType(), carbonColumn.getColumnSchema().getScale());
            }
            internalFilterValue = CarbonUtil.getValueAsBytes((DataType)carbonColumn.getDataType(), (Object)convertedValue);
        } else {
            internalFilterValue = (byte[])convertedValue;
        }
        if (internalFilterValue.length == 0) {
            internalFilterValue = CarbonCommonConstants.MEMBER_DEFAULT_VAL_ARRAY;
        }
        return internalFilterValue;
    }

    public boolean isScanRequired(FilterResolverIntf filterExp) {
        return true;
    }

    public void clear() {
    }

    public void finish() {
    }

    static class BloomQueryModel {
        private String columnName;
        private List<byte[]> filterValues;

        private BloomQueryModel(String columnName, List<byte[]> filterValues) {
            this.columnName = columnName;
            this.filterValues = filterValues;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("BloomQueryModel{");
            sb.append("columnName='").append(this.columnName).append('\'');
            sb.append(", filterValues=");
            for (byte[] value : this.filterValues) {
                sb.append(Arrays.toString(value));
            }
            sb.append('}');
            return sb.toString();
        }
    }
}

