/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.datamap.bloom;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import org.apache.carbondata.core.cache.Cacheable;
import org.apache.hadoop.util.bloom.CarbonBloomFilter;

public class BloomCacheKeyValue {

    public static class CacheValue
    implements Cacheable {
        private List<CarbonBloomFilter> bloomFilters;
        private int size;

        public CacheValue(List<CarbonBloomFilter> bloomFilters) {
            this.bloomFilters = bloomFilters;
            for (CarbonBloomFilter bloomFilter : bloomFilters) {
                this.size += bloomFilter.getSize();
            }
        }

        public long getFileTimeStamp() {
            return 0L;
        }

        public int getAccessCount() {
            return 0;
        }

        public long getMemorySize() {
            return this.size;
        }

        public void invalidate() {
            this.bloomFilters = null;
        }

        public List<CarbonBloomFilter> getBloomFilters() {
            return this.bloomFilters;
        }
    }

    public static class CacheKey
    implements Serializable {
        private static final long serialVersionUID = -1478238084352505372L;
        private String shardPath;
        private String indexColumn;

        CacheKey(String shardPath, String indexColumn) {
            this.shardPath = shardPath;
            this.indexColumn = indexColumn;
        }

        public String getShardPath() {
            return this.shardPath;
        }

        public String getIndexColumn() {
            return this.indexColumn;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("CacheKey{");
            sb.append("shardPath='").append(this.shardPath).append('\'');
            sb.append(", indexColumn='").append(this.indexColumn).append('\'');
            sb.append('}');
            return sb.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return Objects.equals(this.shardPath, cacheKey.shardPath) && Objects.equals(this.indexColumn, cacheKey.indexColumn);
        }

        public int hashCode() {
            return Objects.hash(this.shardPath, this.indexColumn);
        }
    }
}

