/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util.bloom;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.BitSet;
import org.apache.hadoop.util.bloom.BloomFilter;
import org.apache.hadoop.util.bloom.HashFunction;
import org.apache.hadoop.util.bloom.Key;
import org.roaringbitmap.RoaringBitmap;

public class CarbonBloomFilter
extends BloomFilter {
    private RoaringBitmap bitmap;
    private boolean compress;
    private int blockletNo;
    private String shardName;

    public CarbonBloomFilter() {
    }

    public CarbonBloomFilter(int vectorSize, int nbHash, int hashType, boolean compress) {
        super(vectorSize, nbHash, hashType);
        this.compress = compress;
    }

    public boolean membershipTest(Key key) {
        if (key == null) {
            throw new NullPointerException("key cannot be null");
        }
        int[] h = this.hash.hash(key);
        this.hash.clear();
        if (this.compress) {
            for (int i = 0; i < this.nbHash; ++i) {
                if (this.bitmap.contains(h[i])) continue;
                return false;
            }
        } else {
            for (int i = 0; i < this.nbHash; ++i) {
                if (this.bits.get(h[i])) continue;
                return false;
            }
        }
        return true;
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.blockletNo);
        out.writeInt(this.nbHash);
        out.writeByte(this.hashType);
        out.writeInt(this.vectorSize);
        out.writeBoolean(this.compress);
        BitSet bits = this.getBitSet();
        if (!this.compress) {
            byte[] bytes = bits.toByteArray();
            out.writeInt(bytes.length);
            out.write(bytes);
        } else {
            RoaringBitmap bitmap = new RoaringBitmap();
            int length = bits.cardinality();
            int nextSetBit = bits.nextSetBit(0);
            for (int i = 0; i < length; ++i) {
                bitmap.add(nextSetBit);
                nextSetBit = bits.nextSetBit(nextSetBit + 1);
            }
            bitmap.serialize(out);
        }
    }

    public void readFields(DataInput in) throws IOException {
        this.blockletNo = in.readInt();
        this.nbHash = in.readInt();
        this.hashType = in.readByte();
        this.vectorSize = in.readInt();
        this.compress = in.readBoolean();
        if (!this.compress) {
            int len = in.readInt();
            byte[] bytes = new byte[len];
            in.readFully(bytes);
            this.setBitSet(BitSet.valueOf(bytes));
        } else {
            this.bitmap = new RoaringBitmap();
            this.bitmap.deserialize(in);
        }
        this.hash = new HashFunction(this.vectorSize, this.nbHash, this.hashType);
    }

    public int getSize() {
        int size = 14;
        if (this.compress) {
            size += this.bitmap.getSizeInBytes();
        } else {
            try {
                size += this.getBitSet().toLongArray().length * 8;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return size;
    }

    private BitSet getBitSet() throws IOException {
        try {
            Field field = BloomFilter.class.getDeclaredField("bits");
            field.setAccessible(true);
            return (BitSet)field.get((Object)this);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private void setBitSet(BitSet bitSet) throws IOException {
        try {
            Field field = BloomFilter.class.getDeclaredField("bits");
            field.setAccessible(true);
            field.set((Object)this, bitSet);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public void setBlockletNo(int blockletNo) {
        this.blockletNo = blockletNo;
    }

    public int getBlockletNo() {
        return this.blockletNo;
    }

    public String getShardName() {
        return this.shardName;
    }

    public void setShardName(String shardName) {
        this.shardName = shardName;
    }
}

