/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util.bloom;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.BitSet;
import org.apache.hadoop.util.bloom.BloomFilter;
import org.apache.hadoop.util.bloom.HashFunction;
import org.apache.hadoop.util.bloom.Key;
import org.roaringbitmap.RoaringBitmap;

public class CarbonBloomFilter
extends BloomFilter {
    private RoaringBitmap bitmap;
    private boolean compress;

    public CarbonBloomFilter() {
    }

    public CarbonBloomFilter(int vectorSize, int nbHash, int hashType, boolean compress) {
        super(vectorSize, nbHash, hashType);
        this.compress = compress;
    }

    public boolean membershipTest(Key key) {
        if (key == null) {
            throw new NullPointerException("key cannot be null");
        }
        int[] h = this.hash.hash(key);
        this.hash.clear();
        if (this.compress) {
            for (int i = 0; i < this.nbHash; ++i) {
                if (this.bitmap.contains(h[i])) continue;
                return false;
            }
        } else {
            for (int i = 0; i < this.nbHash; ++i) {
                if (this.bits.get(h[i])) continue;
                return false;
            }
        }
        return true;
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.nbHash);
        out.writeByte(this.hashType);
        out.writeInt(this.vectorSize);
        out.writeBoolean(this.compress);
        if (!this.compress) {
            byte[] bytes = this.bits.toByteArray();
            out.writeInt(bytes.length);
            out.write(bytes);
        } else {
            RoaringBitmap bitmap = new RoaringBitmap();
            int length = this.bits.cardinality();
            int nextSetBit = this.bits.nextSetBit(0);
            for (int i = 0; i < length; ++i) {
                bitmap.add(nextSetBit);
                nextSetBit = this.bits.nextSetBit(nextSetBit + 1);
            }
            bitmap.serialize(out);
        }
    }

    public void readFields(DataInput in) throws IOException {
        this.nbHash = in.readInt();
        this.hashType = in.readByte();
        this.vectorSize = in.readInt();
        this.compress = in.readBoolean();
        if (!this.compress) {
            int len = in.readInt();
            byte[] bytes = new byte[len];
            in.readFully(bytes);
            this.bits = BitSet.valueOf(bytes);
        } else {
            this.bitmap = new RoaringBitmap();
            this.bitmap.deserialize(in);
        }
        this.hash = new HashFunction(this.vectorSize, this.nbHash, this.hashType);
    }
}

