/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.datamap.bloom;

import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.carbondata.common.annotations.InterfaceAudience;
import org.apache.carbondata.common.logging.LogService;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.datamap.Segment;
import org.apache.carbondata.core.datamap.dev.DataMapWriter;
import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.carbondata.core.datastore.page.ColumnPage;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonColumn;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.datamap.bloom.BloomCoarseGrainDataMap;
import org.apache.carbondata.datamap.bloom.BloomDMModel;
import org.apache.hadoop.util.bloom.CarbonBloomFilter;
import org.apache.hadoop.util.bloom.Key;

@InterfaceAudience.Internal
public class BloomDataMapWriter
extends DataMapWriter {
    private static final LogService LOG = LogServiceFactory.getLogService((String)BloomDataMapWriter.class.getCanonicalName());
    private int bloomFilterSize;
    private double bloomFilterFpp;
    private boolean compressBloom;
    protected int currentBlockletId;
    private List<String> currentDMFiles;
    private List<DataOutputStream> currentDataOutStreams;
    protected List<CarbonBloomFilter> indexBloomFilters;

    BloomDataMapWriter(String tablePath, String dataMapName, List<CarbonColumn> indexColumns, Segment segment, String shardName, int bloomFilterSize, double bloomFilterFpp, boolean compressBloom) throws IOException {
        super(tablePath, dataMapName, indexColumns, segment, shardName);
        this.bloomFilterSize = bloomFilterSize;
        this.bloomFilterFpp = bloomFilterFpp;
        this.compressBloom = compressBloom;
        this.currentDMFiles = new ArrayList<String>(indexColumns.size());
        this.currentDataOutStreams = new ArrayList<DataOutputStream>(indexColumns.size());
        this.indexBloomFilters = new ArrayList<CarbonBloomFilter>(indexColumns.size());
        this.initDataMapFile();
        this.resetBloomFilters();
    }

    public void onBlockStart(String blockId) throws IOException {
    }

    public void onBlockEnd(String blockId) throws IOException {
    }

    public void onBlockletStart(int blockletId) {
    }

    protected void resetBloomFilters() {
        this.indexBloomFilters.clear();
        List indexColumns = this.getIndexColumns();
        int[] stats = this.calculateBloomStats();
        for (int i = 0; i < indexColumns.size(); ++i) {
            this.indexBloomFilters.add(new CarbonBloomFilter(stats[0], stats[1], 1, this.compressBloom));
        }
    }

    private int[] calculateBloomStats() {
        double sizeinBits = (double)(-this.bloomFilterSize) * Math.log(this.bloomFilterFpp) / Math.pow(Math.log(2.0), 2.0);
        double numberOfHashes = sizeinBits / (double)this.bloomFilterSize * Math.log(2.0);
        int[] stats = new int[]{(int)Math.ceil(sizeinBits), (int)Math.ceil(numberOfHashes)};
        return stats;
    }

    public void onBlockletEnd(int blockletId) {
        this.writeBloomDataMapFile();
        ++this.currentBlockletId;
    }

    public void onPageAdded(int blockletId, int pageId, int pageSize, ColumnPage[] pages) {
        List indexColumns = this.getIndexColumns();
        for (int rowId = 0; rowId < pageSize; ++rowId) {
            for (int i = 0; i < indexColumns.size(); ++i) {
                byte[] indexValue;
                Object data = pages[i].getData(rowId);
                DataType dataType = ((CarbonColumn)indexColumns.get(i)).getDataType();
                if (DataTypes.STRING == dataType) {
                    indexValue = this.getStringData(data);
                } else if (DataTypes.BYTE_ARRAY == dataType) {
                    byte[] originValue = (byte[])data;
                    indexValue = new byte[originValue.length - 2];
                    System.arraycopy(originValue, 2, indexValue, 0, originValue.length - 2);
                } else {
                    indexValue = CarbonUtil.getValueAsBytes((DataType)dataType, (Object)data);
                }
                this.indexBloomFilters.get(i).add(new Key(indexValue));
            }
        }
    }

    protected byte[] getStringData(Object data) {
        byte[] lvData = (byte[])data;
        byte[] indexValue = new byte[lvData.length - 2];
        System.arraycopy(lvData, 2, indexValue, 0, lvData.length - 2);
        return indexValue;
    }

    private void initDataMapFile() throws IOException {
        if (!FileFactory.isFileExist((String)this.dataMapPath) && !FileFactory.mkdirs((String)this.dataMapPath, (FileFactory.FileType)FileFactory.getFileType((String)this.dataMapPath))) {
            throw new IOException("Failed to create directory " + this.dataMapPath);
        }
        List indexColumns = this.getIndexColumns();
        for (int indexColId = 0; indexColId < indexColumns.size(); ++indexColId) {
            String dmFile = BloomCoarseGrainDataMap.getBloomIndexFile(this.dataMapPath, ((CarbonColumn)indexColumns.get(indexColId)).getColName());
            DataOutputStream dataOutStream = null;
            try {
                FileFactory.createNewFile((String)dmFile, (FileFactory.FileType)FileFactory.getFileType((String)dmFile));
                dataOutStream = FileFactory.getDataOutputStream((String)dmFile, (FileFactory.FileType)FileFactory.getFileType((String)dmFile));
            }
            catch (IOException e) {
                CarbonUtil.closeStreams((Closeable[])new Closeable[]{dataOutStream});
                throw new IOException(e);
            }
            this.currentDMFiles.add(dmFile);
            this.currentDataOutStreams.add(dataOutStream);
        }
    }

    protected void writeBloomDataMapFile() {
        List indexColumns = this.getIndexColumns();
        try {
            for (int indexColId = 0; indexColId < indexColumns.size(); ++indexColId) {
                BloomDMModel model = new BloomDMModel(this.currentBlockletId, this.indexBloomFilters.get(indexColId));
                model.write(this.currentDataOutStreams.get(indexColId));
                this.currentDataOutStreams.get(indexColId).flush();
            }
        }
        catch (Exception e) {
            for (DataOutputStream dataOutputStream : this.currentDataOutStreams) {
                CarbonUtil.closeStreams((Closeable[])new Closeable[]{dataOutputStream});
            }
            throw new RuntimeException(e);
        }
        finally {
            this.resetBloomFilters();
        }
    }

    public void finish() throws IOException {
        if (this.indexBloomFilters.size() > 0) {
            this.writeBloomDataMapFile();
        }
        this.releaseResouce();
    }

    protected void releaseResouce() {
        List indexColumns = this.getIndexColumns();
        for (int indexColId = 0; indexColId < indexColumns.size(); ++indexColId) {
            CarbonUtil.closeStreams((Closeable[])new Closeable[]{this.currentDataOutStreams.get(indexColId)});
        }
    }
}

