/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.datamap.bloom;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.CacheStats;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.carbondata.common.annotations.InterfaceAudience;
import org.apache.carbondata.common.logging.LogService;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.datamap.bloom.BloomCoarseGrainDataMap;
import org.apache.carbondata.datamap.bloom.BloomDMModel;

@InterfaceAudience.Internal
public class BloomDataMapCache
implements Serializable {
    private static final LogService LOGGER = LogServiceFactory.getLogService((String)BloomDataMapCache.class.getName());
    private static final long serialVersionUID = 20160822L;
    private static final int DEFAULT_CACHE_EXPIRED_HOURS = 2;
    private LoadingCache<CacheKey, List<BloomDMModel>> bloomDMCache = null;

    private BloomDataMapCache() {
        RemovalListener<CacheKey, List<BloomDMModel>> listener = new RemovalListener<CacheKey, List<BloomDMModel>>(){

            public void onRemoval(RemovalNotification<CacheKey, List<BloomDMModel>> notification) {
                LOGGER.info(String.format("Remove bloom datamap entry %s from cache due to %s", notification.getKey(), notification.getCause()));
            }
        };
        CacheLoader<CacheKey, List<BloomDMModel>> cacheLoader = new CacheLoader<CacheKey, List<BloomDMModel>>(){

            public List<BloomDMModel> load(CacheKey key) throws Exception {
                LOGGER.info(String.format("Load bloom datamap entry %s to cache", key));
                return BloomDataMapCache.this.loadBloomDataMapModel(key);
            }
        };
        int cacheSizeInBytes = this.validateAndGetCacheSize() * 1024 * 1024;
        this.bloomDMCache = CacheBuilder.newBuilder().recordStats().maximumSize((long)cacheSizeInBytes).expireAfterAccess(2L, TimeUnit.HOURS).removalListener((RemovalListener)listener).build((CacheLoader)cacheLoader);
    }

    public static BloomDataMapCache getInstance() {
        return SingletonHolder.INSTANCE;
    }

    protected Object readResolve() {
        return BloomDataMapCache.getInstance();
    }

    private int validateAndGetCacheSize() {
        int cacheSize;
        String cacheSizeStr = CarbonProperties.getInstance().getProperty("carbon.query.datamap.bloom.cache.size", "512");
        try {
            cacheSize = Integer.parseInt(cacheSizeStr);
            if (cacheSize <= 0) {
                throw new NumberFormatException("Value should be greater than 0: " + cacheSize);
            }
        }
        catch (NumberFormatException ex) {
            LOGGER.error(String.format("The value '%s' for '%s' is invalid, it must be an Integer that greater than 0. Use default value '%s' instead.", cacheSizeStr, "carbon.query.datamap.bloom.cache.size", "512"));
            cacheSize = Integer.parseInt("512");
        }
        return cacheSize;
    }

    private List<BloomDMModel> loadBloomDataMapModel(CacheKey cacheKey) {
        ArrayList<BloomDMModel> arrayList;
        DataInputStream dataInStream = null;
        ArrayList<BloomDMModel> bloomDMModels = new ArrayList<BloomDMModel>();
        try {
            String indexFile = this.getIndexFileFromCacheKey(cacheKey);
            dataInStream = FileFactory.getDataInputStream((String)indexFile, (FileFactory.FileType)FileFactory.getFileType((String)indexFile));
            try {
                while (dataInStream.available() > 0) {
                    BloomDMModel model = new BloomDMModel();
                    model.readFields(dataInStream);
                    bloomDMModels.add(model);
                }
            }
            catch (EOFException e) {
                LOGGER.info(String.format("Read %d bloom indices from %s", bloomDMModels.size(), indexFile));
            }
            this.bloomDMCache.put((Object)cacheKey, bloomDMModels);
            arrayList = bloomDMModels;
        }
        catch (IOException e) {
            try {
                this.clear(cacheKey);
                LOGGER.error((Throwable)e, "Error occurs while reading bloom index");
                throw new RuntimeException("Error occurs while reading bloom index", e);
            }
            catch (Throwable throwable) {
                CarbonUtil.closeStreams((Closeable[])new Closeable[]{dataInStream});
                throw throwable;
            }
        }
        CarbonUtil.closeStreams((Closeable[])new Closeable[]{dataInStream});
        return arrayList;
    }

    private String getIndexFileFromCacheKey(CacheKey cacheKey) {
        return BloomCoarseGrainDataMap.getBloomIndexFile(cacheKey.shardPath, cacheKey.indexColumn);
    }

    public List<BloomDMModel> getBloomDMModelByKey(CacheKey cacheKey) {
        return (List)this.bloomDMCache.getUnchecked((Object)cacheKey);
    }

    private String getCacheStatus() {
        StringBuilder sb = new StringBuilder();
        CacheStats stats = this.bloomDMCache.stats();
        sb.append("hitCount: ").append(stats.hitCount()).append(System.lineSeparator()).append("hitRate: ").append(stats.hitCount()).append(System.lineSeparator()).append("loadCount: ").append(stats.loadCount()).append(System.lineSeparator()).append("averageLoadPenalty: ").append(stats.averageLoadPenalty()).append(System.lineSeparator()).append("evictionCount: ").append(stats.evictionCount());
        return sb.toString();
    }

    private void clear(CacheKey cacheKey) {
        LOGGER.info(String.format("Current meta cache statistic: %s", this.getCacheStatus()));
        LOGGER.info("Trigger invalid cache for bloom datamap, key is " + cacheKey);
        this.bloomDMCache.invalidate((Object)cacheKey);
    }

    public static class CacheKey {
        private String shardPath;
        private String indexColumn;

        CacheKey(String shardPath, String indexColumn) {
            this.shardPath = shardPath;
            this.indexColumn = indexColumn;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("CacheKey{");
            sb.append("shardPath='").append(this.shardPath).append('\'');
            sb.append(", indexColumn='").append(this.indexColumn).append('\'');
            sb.append('}');
            return sb.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return Objects.equals(this.shardPath, cacheKey.shardPath) && Objects.equals(this.indexColumn, cacheKey.indexColumn);
        }

        public int hashCode() {
            return Objects.hash(this.shardPath, this.indexColumn);
        }
    }

    private static class SingletonHolder {
        private static final BloomDataMapCache INSTANCE = new BloomDataMapCache();

        private SingletonHolder() {
        }
    }
}

