/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.datamap.bloom;

import java.io.IOException;
import java.util.List;
import org.apache.carbondata.common.annotations.InterfaceAudience;
import org.apache.carbondata.core.constants.CarbonCommonConstants;
import org.apache.carbondata.core.datamap.Segment;
import org.apache.carbondata.core.datamap.dev.DataMapBuilder;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonColumn;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.datamap.bloom.BloomDataMapWriter;
import org.apache.hadoop.util.bloom.CarbonBloomFilter;
import org.apache.hadoop.util.bloom.Key;

@InterfaceAudience.Internal
public class BloomDataMapBuilder
extends BloomDataMapWriter
implements DataMapBuilder {
    BloomDataMapBuilder(String tablePath, String dataMapName, List<CarbonColumn> indexColumns, Segment segment, String shardName, int bloomFilterSize, double bloomFilterFpp, boolean bloomCompress) throws IOException {
        super(tablePath, dataMapName, indexColumns, segment, shardName, bloomFilterSize, bloomFilterFpp, bloomCompress);
    }

    public void initialize() throws IOException {
        super.resetBloomFilters();
    }

    public void addRow(int blockletId, int pageId, int rowId, Object[] values) {
        if (this.currentBlockletId != blockletId) {
            super.writeBloomDataMapFile();
            this.currentBlockletId = blockletId;
        }
        List indexColumns = this.getIndexColumns();
        for (int i = 0; i < indexColumns.size(); ++i) {
            byte[] indexValue;
            Object data = values[i];
            DataType dataType = ((CarbonColumn)indexColumns.get(i)).getDataType();
            if (DataTypes.STRING == dataType) {
                indexValue = this.getStringData(data);
            } else if (DataTypes.BYTE_ARRAY == dataType) {
                byte[] originValue = (byte[])data;
                indexValue = new byte[originValue.length - 2];
                System.arraycopy(originValue, 2, indexValue, 0, originValue.length - 2);
            } else {
                indexValue = CarbonUtil.getValueAsBytes((DataType)dataType, (Object)data);
            }
            ((CarbonBloomFilter)((Object)this.indexBloomFilters.get(i))).add(new Key(indexValue));
        }
    }

    @Override
    public void finish() throws IOException {
        super.finish();
    }

    public void close() throws IOException {
        this.releaseResouce();
    }

    @Override
    protected byte[] getStringData(Object data) {
        return ((String)data).getBytes(CarbonCommonConstants.DEFAULT_CHARSET_CLASS);
    }
}

