/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.datamap.bloom;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.carbondata.common.annotations.InterfaceAudience;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.util.bloom.CarbonBloomFilter;

@InterfaceAudience.Internal
public class BloomDMModel
implements Writable {
    private int blockletNo;
    private CarbonBloomFilter bloomFilter;

    public BloomDMModel() {
    }

    public BloomDMModel(int blockletNo, CarbonBloomFilter bloomFilter) {
        this.blockletNo = blockletNo;
        this.bloomFilter = bloomFilter;
    }

    public int getBlockletNo() {
        return this.blockletNo;
    }

    public CarbonBloomFilter getBloomFilter() {
        return this.bloomFilter;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("BloomDMModel{");
        sb.append(", blockletNo=").append(this.blockletNo);
        sb.append(", bloomFilter=").append((Object)this.bloomFilter);
        sb.append('}');
        return sb.toString();
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.blockletNo);
        this.bloomFilter.write(out);
    }

    public void readFields(DataInput in) throws IOException {
        this.blockletNo = in.readInt();
        this.bloomFilter = new CarbonBloomFilter();
        this.bloomFilter.readFields(in);
    }
}

